/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.project.impltypes;

import com.ibm.ccl.sca.facets.core.impltype.IImplTypePreferenceProvider;
import com.ibm.ccl.sca.facets.core.impltype.ImplTypeEntry;
import com.ibm.ccl.sca.internal.ui.project.IImplTypeState;
import com.ibm.ccl.sca.ui.messages.Messages;
import java.net.URL;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class ImplTypeLabelProvider
implements ILabelProvider,
ITableLabelProvider {
    Hashtable<String, Image> labelImageMap = new Hashtable();
    IProject project;
    private IImplTypeState state;

    public ImplTypeLabelProvider(Set<ImplTypeEntry> allImplTypes, IProject project, IImplTypeState state) {
        for (ImplTypeEntry entry : allImplTypes) {
            this.labelImageMap.put(entry.getID(), this.getImage(entry));
        }
        this.project = project;
        this.state = state;
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        return ((ImplTypeEntry)element).getName();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            ImplTypeEntry entry = (ImplTypeEntry)element;
            return this.labelImageMap.get(entry.getID());
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        ImplTypeEntry entry = (ImplTypeEntry)element;
        if (columnIndex == 0) {
            return this.getName(entry);
        }
        IImplTypePreferenceProvider provider = entry.getPreferenceProvider();
        if (provider != null && (provider.getConfigPageID(this.project) != null || provider.getKeys() != null)) {
            return "...";
        }
        return null;
    }

    public void dispose() {
        for (Image image : this.labelImageMap.values()) {
            if (image == null) continue;
            image.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    private String getName(ImplTypeEntry entry) {
        if (this.state == null) {
            return this.project == null || entry.isEnabled(this.project) ? entry.getName() : Messages.bind((String)Messages.IMPL_TYPE_UNAVAILABLE_IN_PROJECT, (Object)entry.getName());
        }
        if (this.state.isEnabled(entry)) {
            return entry.getName();
        }
        if (this.project == null) {
            return Messages.bind((String)Messages.IMPL_TYPE_UNAVAILABLE_IN_CONTEXT, (Object)entry.getName());
        }
        return Messages.bind((String)Messages.IMPL_TYPE_UNAVAILABLE_IN_PROJECT, (Object)entry.getName());
    }

    private Image getImage(ImplTypeEntry entry) {
        Bundle iconBundle = Platform.getBundle((String)entry.getIconNamespace());
        URL iconURL = FileLocator.find((Bundle)iconBundle, (IPath)new Path(entry.getIconPath()), null);
        return ImageDescriptor.createFromURL((URL)iconURL).createImage();
    }
}

