/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.project.impltypes;

import com.ibm.ccl.sca.facets.core.Activator;
import com.ibm.ccl.sca.facets.core.impltype.ImplTypeEntry;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.IProjectFacetActionEvent;

public class FacetedProjectListener
implements IFacetedProjectListener {
    static final String SOAFP_FACET_BASE = "com.ibm.ccl.soafp";
    private static final String IMPLEMENTATION_JAVA = "implementation.java";
    private static final String IMPLEMENTATION_COMPOSITE = "implementation.composite";
    private Set<ImplTypeEntry> allImplTypes;
    private Set<ImplTypeEntry> selectedImplTypes;

    public void handleEvent(IFacetedProjectEvent event) {
        IProjectFacetActionEvent actionEvent = (IProjectFacetActionEvent)event;
        IProjectFacet facet = actionEvent.getProjectFacet();
        if (!facet.getId().equals(SOAFP_FACET_BASE)) {
            return;
        }
        IProject project = actionEvent.getProject().getProject();
        switch (actionEvent.getType()) {
            case POST_INSTALL: {
                this.processImplTypes(project);
            }
        }
    }

    public void processImplTypes(IProject project) {
        try {
            IProjectDescription projDesc = project.getDescription();
            this.allImplTypes = Activator.getDefault().getAllImplTypes();
            this.selectedImplTypes = new HashSet<ImplTypeEntry>();
            for (ImplTypeEntry entry : this.allImplTypes) {
                if (entry.getID().equals(IMPLEMENTATION_COMPOSITE)) {
                    this.selectedImplTypes.add(entry);
                }
                if (!entry.getID().equals(IMPLEMENTATION_JAVA) || !projDesc.hasNature("org.eclipse.jdt.core.javanature")) continue;
                this.selectedImplTypes.add(entry);
            }
            this.saveImplTypesToStore(project);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void saveImplTypesToStore(IProject project) {
        try {
            for (ImplTypeEntry entry : this.allImplTypes) {
                QualifiedName qn = new QualifiedName("com.ibm.ccl.sca.core", entry.getID());
                if (ImplTypeEntry.isEntryInSet((ImplTypeEntry)entry, this.selectedImplTypes)) {
                    project.setPersistentProperty(qn, "true");
                    continue;
                }
                project.setPersistentProperty(qn, "false");
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

