/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.project;

import com.ibm.ccl.sca.internal.ui.preferences.ValidationPreferenceGroup;
import com.ibm.ccl.sca.ui.messages.Messages;
import com.ibm.ccl.sca.ui.util.UIUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class ValidationPropertyPage
extends PropertyPage {
    private String INFOPOP_VALIDATION_PROPERTIES = "VALIDATION_PROPERTIES";
    private Button projectButton;
    private Link workspaceSettings;
    private ValidationPreferenceGroup group;

    private void setEnabled(boolean enabled) {
        this.workspaceSettings.setEnabled(!enabled);
        this.group.getConfig().setEnabled(enabled);
    }

    private void createProjectSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.ccl.sca.ui." + this.INFOPOP_VALIDATION_PROPERTIES);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.projectButton = new Button(composite, 32);
        this.projectButton.setText(Messages.SCAProjectPropertyPage_0);
        this.projectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean useProjectSettings = ValidationPropertyPage.this.projectButton.getSelection();
                if (!useProjectSettings) {
                    ValidationPropertyPage.this.group.getConfig().restoreDefaults();
                }
                ValidationPropertyPage.this.setEnabled(useProjectSettings);
            }
        });
        this.workspaceSettings = UIUtils.createLinkToPreference(composite, Messages.SCAProjectPropertyPage_1, "com.ibm.ccl.sca.internal.ui.preferences.validationPreferencePage");
        this.workspaceSettings.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        Label divider = new Label(parent, 258);
        divider.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    private void createPreferenceSection(Composite parent) {
        this.group = new ValidationPreferenceGroup(this.getShell(), (IProject)this.getElement().getAdapter(IProject.class));
        this.group.createInto(parent);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.createProjectSection(composite);
        this.createPreferenceSection(composite);
        boolean isUsingProjectSettings = this.group.getConfig().isUsingProjectSettings();
        this.projectButton.setSelection(isUsingProjectSettings);
        this.setEnabled(isUsingProjectSettings);
        return composite;
    }

    protected void performApply() {
        this.group.applyChanges(this.projectButton.getSelection());
    }

    protected void performDefaults() {
        this.projectButton.setSelection(false);
        this.group.getConfig().restoreDefaults();
        this.setEnabled(false);
    }

    public boolean performOk() {
        return this.group.applyChanges(this.projectButton.getSelection());
    }
}

