/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.project;

import com.ibm.ccl.sca.core.tracing.LogWriter;
import com.ibm.ccl.sca.core.util.JavaUtil;
import com.ibm.ccl.sca.core.util.StatusUtil;
import com.ibm.ccl.sca.facets.core.impltype.IImplTypeChangeEvent;
import com.ibm.ccl.sca.facets.core.impltype.IImplTypeChangeListener;
import com.ibm.ccl.sca.facets.core.impltype.ImplTypeChangeEvent;
import com.ibm.ccl.sca.facets.core.impltype.ImplTypeEntry;
import com.ibm.ccl.sca.internal.ui.project.SCAProjectCreationPage;
import com.ibm.ccl.sca.ui.messages.Messages;
import com.ibm.ccl.sca.ui.plugin.SCAToolsUIPlugin;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.preferences.NewJavaProjectPreferencePage;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPage;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.osgi.framework.Bundle;

public class SCAProjectWizard
extends Wizard
implements INewWizard {
    private static final String SCAPROJECT_WIZARD_GIF = "icons/scaproject_wizard.gif";
    private static final String OUTPUT_FOLDER_NAME = "bin";
    private static final String SOURCE_FOLDER_NAME = "src";
    private IProject existingProject;
    private SCAProjectCreationPage projectPage;
    private NewJavaProjectWizardPage javaProjectPage;
    private IProject project;

    public SCAProjectWizard() {
        this(null);
        this.setWindowTitle(Messages.TITLE_NEW_SCA_PROJECT_WIZARD);
    }

    public SCAProjectWizard(IProject existingProject) {
        this.existingProject = existingProject;
        Bundle bundle = Platform.getBundle((String)"com.ibm.ccl.sca.ui");
        URL url = bundle.getEntry(SCAPROJECT_WIZARD_GIF);
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromURL((URL)url));
    }

    public boolean performFinish() {
        WorkspaceModifyOperation createProject = new WorkspaceModifyOperation((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot()){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                SCAProjectWizard.this.performFinish(monitor);
            }
        };
        IWorkbench wb = PlatformUI.getWorkbench();
        IProgressService ps = wb.getProgressService();
        LogWriter logger = new LogWriter();
        try {
            ps.runInUI((IRunnableContext)ps, (IRunnableWithProgress)createProject, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }
        catch (InvocationTargetException e) {
            logger.write((Plugin)SCAToolsUIPlugin.getDefault(), 4, (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.write((Plugin)SCAToolsUIPlugin.getDefault(), 8, (Throwable)e);
        }
        return true;
    }

    public boolean performFinish(IProgressMonitor monitor) throws InterruptedException {
        IProject newProject = this.projectPage.getProjectHandle();
        IPath projectLoc = null;
        if (this.existingProject == null && !this.projectPage.useDefaults()) {
            projectLoc = this.projectPage.getLocationPath();
        }
        this.createProject(newProject, projectLoc, monitor);
        this.saveImplTypesToStore(newProject);
        if (this.existingProject != null) {
            try {
                JavaUtil.forceResolveClasspathEntries((IProject)newProject);
            }
            catch (CoreException e) {
                SCAToolsUIPlugin.getDefault().getLog().log(e.getStatus());
            }
        }
        if (newProject.exists()) {
            this.project = newProject;
            return true;
        }
        this.project = null;
        return false;
    }

    private void createProject(IProject newProject, IPath projectLoc, IProgressMonitor monitor) {
        IProjectDescription projectDesc = ResourcesPlugin.getWorkspace().newProjectDescription(newProject.getName());
        projectDesc.setLocation(projectLoc);
        try {
            Object runtimes;
            if (this.existingProject == null) {
                newProject.create(projectDesc, null);
            }
            newProject.open(null);
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)newProject, (boolean)true, null);
            IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)"com.ibm.ccl.sca");
            facetedProject.installProjectFacet(facet.getDefaultVersion(), null, null);
            IRuntime selectedRuntime = this.projectPage.getRuntimeSelection();
            if (selectedRuntime != null) {
                Map<IRuntime, SortedSet<IProjectFacetVersion>> runtimeFacetMap = this.projectPage.getRuntimeFacetMap();
                runtimes = runtimeFacetMap.keySet().toArray();
                SortedSet<IProjectFacetVersion> sortedFVSet = runtimeFacetMap.get(runtimes[this.projectPage.serverTargetCombo.getSelectionIndex()]);
                int fvSelectionIndex = this.projectPage.facetVersionCombo.getSelectionIndex();
                if (fvSelectionIndex != -1) {
                    IProjectFacetVersion fv = null;
                    Iterator it = sortedFVSet.iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        fv = (IProjectFacetVersion)it.next();
                        if (fvSelectionIndex == sortedFVSet.size() - i - 1) break;
                    }
                    if (fv != null) {
                        facetedProject.installProjectFacet(fv, null, null);
                    }
                }
            }
            this.setupForImplTypes(newProject, monitor);
            if (selectedRuntime != null) {
                Set runSet = facetedProject.getTargetedRuntimes();
                if (runSet.isEmpty() || !runSet.contains(selectedRuntime)) {
                    runtimes = new HashSet();
                    runtimes.add(selectedRuntime);
                    facetedProject.setTargetedRuntimes((Set)runtimes, (IProgressMonitor)new NullProgressMonitor());
                }
                facetedProject.setPrimaryRuntime(selectedRuntime, (IProgressMonitor)new NullProgressMonitor());
                if (selectedRuntime != null) {
                    facetedProject.addTargetedRuntime(selectedRuntime, null);
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void setupForImplTypes(IProject project, IProgressMonitor monitor) {
        try {
            Set<ImplTypeEntry> selectedImplTypes = this.projectPage.getSelectedImplTypes();
            for (ImplTypeEntry entry : selectedImplTypes) {
                IImplTypeChangeListener listener = entry.getListener();
                if (listener != null) {
                    listener.implTypeChanged((IImplTypeChangeEvent)new ImplTypeChangeEvent(project, true));
                }
                if (!entry.getID().equals("implementation.java")) continue;
                this.configureJavaProject(project, monitor);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void configureJavaProject(IProject newProject, IProgressMonitor monitor) throws CoreException, JavaModelException {
        IProjectDescription description = newProject.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = "org.eclipse.jdt.core.javanature";
        description.setNatureIds(newNatures);
        newProject.setDescription(description, monitor);
        IJavaProject javaProj = JavaCore.create((IProject)newProject);
        if (this.javaProjectPage.getOutputLocation().segmentCount() == 0) {
            if (this.existingProject == null) {
                IPath binPath = newProject.getFullPath().append(OUTPUT_FOLDER_NAME);
                javaProj.setOutputLocation(binPath, null);
                SCAProjectWizard.createFolder((IContainer)newProject, SOURCE_FOLDER_NAME);
                IClasspathEntry[] defEntries = this.createRawClasspath(newProject, SOURCE_FOLDER_NAME);
                javaProj.setRawClasspath(defEntries, monitor);
            }
        } else {
            IClasspathEntry[] entries = this.javaProjectPage.getRawClassPath();
            IClasspathEntry foundEntry = null;
            IClasspathEntry[] iClasspathEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (!this.isInJreEntries(entry)) {
                    foundEntry = entry;
                    break;
                }
                ++n2;
            }
            if (foundEntry == null) {
                IStatus errStatus = StatusUtil.errorStatus((String)Messages.NO_SOURCE_FOLDER_ENTRY);
                SCAToolsUIPlugin.getDefault().getLog().log(errStatus);
                return;
            }
            String sourceEntry = foundEntry.getPath().removeFirstSegments(1).toString();
            SCAProjectWizard.createFolder((IContainer)newProject, sourceEntry);
            javaProj.setOutputLocation(this.javaProjectPage.getOutputLocation(), null);
            javaProj.setRawClasspath(this.javaProjectPage.getRawClassPath(), monitor);
        }
    }

    private IClasspathEntry[] createRawClasspath(IProject project, String sourceEntry) {
        IClasspathEntry[] defEntries = new IClasspathEntry[]{JavaCore.newSourceEntry((IPath)project.getFullPath().append(sourceEntry))};
        IClasspathEntry[] jreEntry = NewJavaProjectPreferencePage.getDefaultJRELibrary();
        IClasspathEntry[] newEntries = new IClasspathEntry[defEntries.length + jreEntry.length];
        System.arraycopy(defEntries, 0, newEntries, 0, defEntries.length);
        System.arraycopy(jreEntry, 0, newEntries, defEntries.length, jreEntry.length);
        return newEntries;
    }

    public void saveImplTypesToStore(IProject project) {
        this.projectPage.saveImplValuesToPreferenceStore(project);
    }

    private boolean isInJreEntries(IClasspathEntry entry) {
        IClasspathEntry[] jreEntry;
        IClasspathEntry[] iClasspathEntryArray = jreEntry = NewJavaProjectPreferencePage.getDefaultJRELibrary();
        int n = jreEntry.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry e = iClasspathEntryArray[n2];
            if (e.getPath().equals((Object)entry.getPath())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static IFolder createFolder(IContainer container, String folderName) {
        IFolder folder = container.getFolder((IPath)new Path(folderName));
        if (!folder.exists()) {
            try {
                folder.create(true, true, null);
                return folder;
            }
            catch (CoreException ce) {
                ce.printStackTrace();
                return null;
            }
        }
        return folder;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.projectPage = new SCAProjectCreationPage(Messages.PAGE_NAME_SCA_PROJECT, this.existingProject);
        if (this.existingProject == null) {
            this.projectPage.setTitle(Messages.TITLE_CREATE_NEW_SCA_PROJECT);
        } else {
            this.projectPage.setTitle(Messages.TITLE_ADD_SCA_SUPPORT);
        }
        this.projectPage.setDescription(Messages.DESC_ENTER_GENERIC_INFO);
        this.addPage((IWizardPage)this.projectPage);
        this.javaProjectPage = new NewJavaProjectWizardPage(ResourcesPlugin.getWorkspace().getRoot(), (WizardNewProjectCreationPage)this.projectPage);
        this.addPage((IWizardPage)this.javaProjectPage);
    }

    public IProject getSCAProject() {
        return this.project;
    }
}

