/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.project;

import com.ibm.ccl.sca.core.plugin.SCAToolsCorePlugin;
import com.ibm.ccl.sca.core.preferences.SCAPreferences;
import com.ibm.ccl.sca.facets.core.Activator;
import com.ibm.ccl.sca.facets.core.SCAFacetUtils;
import com.ibm.ccl.sca.facets.core.impltype.ImplTypeEntry;
import com.ibm.ccl.sca.internal.ui.project.IImplTypeState;
import com.ibm.ccl.sca.internal.ui.project.impltypes.ImplTypeContentProvider;
import com.ibm.ccl.sca.internal.ui.project.impltypes.ImplTypeLabelProvider;
import com.ibm.ccl.sca.internal.ui.project.impltypes.ImplTypeViewerComparator;
import com.ibm.ccl.sca.ui.messages.Messages;
import com.ibm.ccl.sca.ui.util.UIUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.ui.ServerUIUtil;

public class SCAProjectCreationPage
extends WizardNewProjectCreationPage
implements IImplTypeState {
    private String INFOPOP_SCAPROJECT_CREATION = "SCAPROJECTCREATION";
    public Combo serverTargetCombo;
    public Combo facetVersionCombo;
    public Button createNewRuntime;
    public static int NUM_DEFAULT_IMPL_TYPES = 2;
    public static final String SCAFP_FACET_BASE = "com.ibm.websphere.scafp";
    public static final String IMPLEMENTATION_ID_JAVA = "implementation.java";
    public static final String IMPLEMENTATION_ID_COMPOSITE = "implementation.composite";
    Map<IRuntime, SortedSet<IProjectFacetVersion>> runtimeFacetMap;
    ArrayList<IRuntime> runtimes;
    private IProject existingProject;
    private Set<ImplTypeEntry> allImplTypes;
    private Set<ImplTypeEntry> selectedImplTypes;
    private ScrolledComposite implTypesScroll;
    private CheckboxTableViewer implTypesTableViewer;
    private boolean nextEnabled = false;
    private List<IProjectFacetVersion> selectedFacetVersions = new ArrayList<IProjectFacetVersion>();

    public SCAProjectCreationPage(String pageName, IProject existingProject) {
        super(pageName);
        this.existingProject = existingProject;
        if (existingProject != null) {
            this.setInitialProjectName(existingProject.getName());
        }
        this.allImplTypes = Activator.getDefault().getAllImplTypes();
        this.selectedImplTypes = new HashSet<ImplTypeEntry>();
    }

    private void initControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout());
        Composite projectComposite = new Composite(composite, 0);
        projectComposite.setLayoutData((Object)new GridData(768));
        projectComposite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(projectComposite, 0);
        label.setText(Messages.PROJECT);
        Text text = new Text(projectComposite, 2048);
        text.setLayoutData((Object)new GridData(768));
        text.setText(this.existingProject.getName());
        text.setEnabled(false);
        this.setPageComplete(true);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    public void createControl(Composite parent) {
        if (this.existingProject == null) {
            super.createControl(parent);
        } else {
            this.initControl(parent);
        }
        Composite pageui = (Composite)this.getControl();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)pageui, "com.ibm.ccl.sca.ui." + this.INFOPOP_SCAPROJECT_CREATION);
        this.runtimeFacetMap = this.prepRuntimesAndFacets();
        if (this.runtimeFacetMap.keySet().size() > 0) {
            this.createTargetedRuntimeControls(pageui);
        }
        UIUtils uiUtils = new UIUtils("com.ibm.ccl.sca.ui");
        Group projectGroup = uiUtils.createGroup(pageui, Messages.PROJECT_SETTINGS, null, null);
        GridData gridData = new GridData(1808);
        Label implTypesLabel = new Label((Composite)projectGroup, 16384);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalSpan = 1;
        gridData.verticalIndent = 20;
        implTypesLabel.setLayoutData((Object)gridData);
        implTypesLabel.setText(Messages.LABEL_IMPL_TYPES_WIZARD);
        this.implTypesScroll = new ScrolledComposite((Composite)projectGroup, 2816);
        this.implTypesScroll.setExpandHorizontal(true);
        this.implTypesScroll.setExpandVertical(true);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalSpan = 1;
        this.implTypesScroll.setLayoutData((Object)gridData);
        this.implTypesTableViewer = CheckboxTableViewer.newCheckList((Composite)this.implTypesScroll, (int)2);
        this.implTypesScroll.setContent((Control)this.implTypesTableViewer.getTable());
        this.implTypesTableViewer.setContentProvider((IContentProvider)new ImplTypeContentProvider());
        this.implTypesTableViewer.setLabelProvider((IBaseLabelProvider)new ImplTypeLabelProvider(this.allImplTypes, this.existingProject, this));
        this.implTypesTableViewer.setComparator((ViewerComparator)new ImplTypeViewerComparator());
        this.implTypesTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                SCAProjectCreationPage.this.implTypeChecked(event, (ImplTypeEntry)event.getElement());
            }
        });
        this.updateSelectedFacetStr();
        this.setupTableViewer(this.implTypesTableViewer);
        this.setImplValuesAndTableView();
    }

    private void createTargetedRuntimeControls(Composite pageui) {
        UIUtils uiUtils = new UIUtils("com.ibm.ccl.sca.ui");
        Group runtimeGroup = uiUtils.createGroup(pageui, Messages.TARGET_RUNTIME, Messages.TARGET_RUNTIME_TOOLTIP, null, 1, -1, -1);
        Composite runtimeComposite = uiUtils.createComposite((Composite)runtimeGroup, 3);
        this.serverTargetCombo = uiUtils.createCombo(runtimeComposite, null, Messages.TARGET_RUNTIME_TOOLTIP, null, 2056);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        this.serverTargetCombo.setLayoutData((Object)gridData);
        this.serverTargetCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                Object[] runtimes = SCAProjectCreationPage.this.runtimeFacetMap.keySet().toArray();
                if (SCAProjectCreationPage.this.serverTargetCombo.getSelectionIndex() == runtimes.length) {
                    SCAProjectCreationPage.this.facetVersionCombo.removeAll();
                    SCAProjectCreationPage.this.facetVersionCombo.add("");
                    SCAProjectCreationPage.this.facetVersionCombo.select(0);
                    SCAProjectCreationPage.this.facetVersionCombo.setEnabled(false);
                } else {
                    SortedSet<IProjectFacetVersion> sortedFVSet = SCAProjectCreationPage.this.runtimeFacetMap.get(runtimes[SCAProjectCreationPage.this.serverTargetCombo.getSelectionIndex()]);
                    Object[] fvArray = sortedFVSet.toArray();
                    SCAProjectCreationPage.this.facetVersionCombo.setEnabled(true);
                    SCAProjectCreationPage.this.facetVersionCombo.removeAll();
                    int i = fvArray.length - 1;
                    while (i >= 0) {
                        SCAProjectCreationPage.this.facetVersionCombo.add(fvArray[i].toString());
                        --i;
                    }
                    SCAProjectCreationPage.this.facetVersionCombo.select(0);
                }
                SCAProjectCreationPage.this.updateSelectedFacetStr();
                SCAProjectCreationPage.this.setupTableViewer(SCAProjectCreationPage.this.implTypesTableViewer);
                SCAProjectCreationPage.this.setImplValuesAndTableView();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.runtimes = new ArrayList<IRuntime>(this.runtimeFacetMap.keySet());
        int i = 0;
        while (i < this.runtimes.size()) {
            this.serverTargetCombo.add(this.runtimes.get(i).getLocalizedName(), i);
            ++i;
        }
        this.serverTargetCombo.add(Messages.NONE);
        if (this.serverTargetCombo.getSelectionIndex() == -1 && this.serverTargetCombo.getVisibleItemCount() != 0) {
            this.serverTargetCombo.select(0);
        }
        this.createNewRuntime = uiUtils.createPushButton(runtimeComposite, Messages.NEW_RUNTIME, Messages.NEW_RUNTIME_TOOLTIP, null);
        this.createNewRuntime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                boolean runtimeCreated = ServerUIUtil.showNewRuntimeWizard((Shell)SCAProjectCreationPage.this.getShell(), null, null, (String)"com.ibm.ws.ast.st.runtime.v70");
                if (runtimeCreated) {
                    SCAProjectCreationPage.this.runtimeFacetMap = SCAProjectCreationPage.this.prepRuntimesAndFacets();
                    SCAProjectCreationPage.this.serverTargetCombo.removeAll();
                    SCAProjectCreationPage.this.runtimes = new ArrayList<IRuntime>(SCAProjectCreationPage.this.runtimeFacetMap.keySet());
                    int i = 0;
                    while (i < SCAProjectCreationPage.this.runtimes.size()) {
                        SCAProjectCreationPage.this.serverTargetCombo.add(SCAProjectCreationPage.this.runtimes.get(i).getLocalizedName(), i);
                        ++i;
                    }
                    SCAProjectCreationPage.this.serverTargetCombo.add(Messages.NONE);
                    if (SCAProjectCreationPage.this.serverTargetCombo.getSelectionIndex() == -1 && SCAProjectCreationPage.this.serverTargetCombo.getVisibleItemCount() != 0) {
                        SCAProjectCreationPage.this.serverTargetCombo.select(0);
                    }
                    if (SCAProjectCreationPage.this.runtimes.size() > 0) {
                        SCAProjectCreationPage.this.serverTargetCombo.select(SCAProjectCreationPage.this.runtimes.size() - 1);
                    }
                    SortedSet<IProjectFacetVersion> sortedFVSet = SCAProjectCreationPage.this.runtimeFacetMap.get(SCAProjectCreationPage.this.runtimes.get(SCAProjectCreationPage.this.serverTargetCombo.getSelectionIndex()));
                    Object[] fvArray = sortedFVSet.toArray();
                    SCAProjectCreationPage.this.facetVersionCombo.setEnabled(true);
                    SCAProjectCreationPage.this.facetVersionCombo.removeAll();
                    int i2 = fvArray.length - 1;
                    while (i2 >= 0) {
                        SCAProjectCreationPage.this.facetVersionCombo.add(fvArray[i2].toString());
                        --i2;
                    }
                    SCAProjectCreationPage.this.facetVersionCombo.select(0);
                    SCAProjectCreationPage.this.updateSelectedFacetStr();
                    SCAProjectCreationPage.this.setupTableViewer(SCAProjectCreationPage.this.implTypesTableViewer);
                    SCAProjectCreationPage.this.setImplValuesAndTableView();
                }
            }
        });
        Composite facetVersionComposite = uiUtils.createComposite((Composite)runtimeGroup, 2);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.facetVersionCombo = uiUtils.createCombo(facetVersionComposite, Messages.FACET_VERSION, Messages.FACET_VERSION_TOOLTIP, null, 2056);
        this.facetVersionCombo.setLayoutData((Object)gridData);
        Object[] runtimes = this.runtimeFacetMap.keySet().toArray();
        SortedSet<IProjectFacetVersion> sortedFVSet = this.runtimeFacetMap.get(runtimes[this.serverTargetCombo.getSelectionIndex()]);
        Object[] fvArray = sortedFVSet.toArray();
        int i2 = fvArray.length - 1;
        while (i2 >= 0) {
            this.facetVersionCombo.add(fvArray[i2].toString());
            --i2;
        }
        this.facetVersionCombo.select(0);
        this.facetVersionCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                SCAProjectCreationPage.this.updateSelectedFacetStr();
                SCAProjectCreationPage.this.setupTableViewer(SCAProjectCreationPage.this.implTypesTableViewer);
                SCAProjectCreationPage.this.setImplValuesAndTableView();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    private HashMap<IRuntime, SortedSet<IProjectFacetVersion>> prepRuntimesAndFacets() {
        List allfvs = SCAFacetUtils.getAllFacetVersionsDependingOnSCA();
        HashSet allSCARuntimes = new HashSet();
        for (IProjectFacetVersion fv : allfvs) {
            HashSet<IProjectFacetVersion> fvSet = new HashSet<IProjectFacetVersion>();
            fvSet.add(fv);
            Set tmpSet = RuntimeManager.getRuntimes(fvSet);
            if (tmpSet == null) continue;
            allSCARuntimes.addAll(tmpSet);
        }
        HashMap<IRuntime, SortedSet<IProjectFacetVersion>> runtimeFacetMap = new HashMap<IRuntime, SortedSet<IProjectFacetVersion>>();
        for (IRuntime runtime : allSCARuntimes) {
            TreeSet<IProjectFacetVersion> fvSortedSet = new TreeSet<IProjectFacetVersion>();
            for (IProjectFacetVersion fv : allfvs) {
                if (!runtime.supports(fv)) continue;
                fvSortedSet.add(fv);
            }
            runtimeFacetMap.put(runtime, fvSortedSet);
        }
        return runtimeFacetMap;
    }

    private void updateSelectedFacetStr() {
        this.selectedFacetVersions.clear();
        IRuntime selectedRuntime = this.getRuntimeSelection();
        if (selectedRuntime != null) {
            SortedSet<IProjectFacetVersion> facetVersions = this.runtimeFacetMap.get(selectedRuntime);
            int idx = facetVersions.size() - this.facetVersionCombo.getSelectionIndex() - 1;
            IProjectFacetVersion facetVersion = (IProjectFacetVersion)facetVersions.toArray()[idx];
            this.selectedFacetVersions.add(facetVersion);
        }
    }

    private void setImplValuesAndTableView() {
        SCAPreferences preferences = SCAToolsCorePlugin.getInstance().getPreferences();
        for (ImplTypeEntry entry : this.allImplTypes) {
            if (preferences.getSelectedImplType(entry.getID(), null) && this.isEnabled(entry)) {
                this.implTypesTableViewer.setChecked((Object)entry, true);
                this.selectedImplTypes.add(entry);
                if (entry.getID().equals(IMPLEMENTATION_ID_JAVA)) {
                    this.nextEnabled = true;
                }
                if (!entry.isRequired()) continue;
                this.implTypesTableViewer.setChecked((Object)entry, true);
                this.implTypesTableViewer.setGrayed((Object)entry, true);
                continue;
            }
            this.implTypesTableViewer.setChecked((Object)entry, false);
        }
    }

    public void saveImplValuesToPreferenceStore(IProject project) {
        boolean selection;
        SCAPreferences preferences = SCAToolsCorePlugin.getInstance().getPreferences();
        boolean listChanged = false;
        if (this.implTypesTableViewer == null) {
            return;
        }
        for (ImplTypeEntry entry : this.allImplTypes) {
            selection = this.implTypesTableViewer.getChecked((Object)entry);
            boolean oldValue = preferences.getSelectedImplType(entry.getID(), null);
            if (!entry.isEnabled(project) || selection == oldValue) continue;
            listChanged = true;
            break;
        }
        if (listChanged) {
            preferences.setProjectEnabled(project, true);
            for (ImplTypeEntry entry : this.allImplTypes) {
                selection = this.implTypesTableViewer.getChecked((Object)entry);
                preferences.setSelectedImplType(entry.getID(), selection, project);
            }
            preferences.flushPreferences(project);
        }
    }

    private void setupTableViewer(CheckboxTableViewer implTypesTableViewer) {
        implTypesTableViewer.setInput(this.allImplTypes);
        for (ImplTypeEntry entry : this.allImplTypes) {
            if (entry.isRequired() || !this.isEnabled(entry)) {
                implTypesTableViewer.setGrayed((Object)entry, true);
                continue;
            }
            implTypesTableViewer.setGrayed((Object)entry, false);
        }
    }

    private void implTypeChecked(CheckStateChangedEvent event, ImplTypeEntry entry) {
        if (!this.isEnabled(entry)) {
            this.implTypesTableViewer.setChecked((Object)entry, false);
            entry.setSelected(false);
        }
        if (event.getChecked()) {
            entry.setSelected(true);
            if (!ImplTypeEntry.isEntryInSet((ImplTypeEntry)entry, this.selectedImplTypes)) {
                this.selectedImplTypes.add(entry);
                if (entry.getID().equals(IMPLEMENTATION_ID_JAVA)) {
                    this.nextEnabled = true;
                    this.setPageComplete(this.isPageComplete());
                }
            }
        } else if (!entry.isRequired()) {
            entry.setSelected(false);
            for (ImplTypeEntry e : this.selectedImplTypes) {
                if (!e.getID().equals(entry.getID())) continue;
                this.selectedImplTypes.remove(e);
                if (entry.getID().equals(IMPLEMENTATION_ID_JAVA)) {
                    this.nextEnabled = false;
                    this.setPageComplete(this.isPageComplete());
                }
                break;
            }
        } else {
            this.implTypesTableViewer.setChecked((Object)entry, true);
            entry.setSelected(true);
        }
    }

    public IRuntime getRuntimeSelection() {
        if (this.serverTargetCombo == null) {
            return null;
        }
        if (this.runtimes.size() <= this.serverTargetCombo.getSelectionIndex()) {
            return null;
        }
        return this.runtimes.get(this.serverTargetCombo.getSelectionIndex());
    }

    public Map<IRuntime, SortedSet<IProjectFacetVersion>> getRuntimeFacetMap() {
        return this.runtimeFacetMap;
    }

    @Override
    public boolean isEnabled(ImplTypeEntry entry) {
        return entry.isEnabled(this.existingProject, this.selectedFacetVersions);
    }

    public Set<ImplTypeEntry> getAllImplTypes() {
        return this.allImplTypes;
    }

    public Set<ImplTypeEntry> getSelectedImplTypes() {
        return this.selectedImplTypes;
    }

    public void setVisible(boolean visible) {
        if (this.existingProject == null) {
            super.setVisible(visible);
        } else {
            this.getControl().setVisible(visible);
        }
    }

    protected boolean validatePage() {
        if (this.existingProject == null) {
            return super.validatePage();
        }
        return true;
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage() && this.nextEnabled;
    }
}

