/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.preferences;

import com.ibm.ccl.sca.ui.messages.Messages;
import com.ibm.ccl.sca.ui.plugin.SCAToolsUIPlugin;
import com.ibm.ccl.sca.ui.validation.ValidationRulesConfiguration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class ValidationPreferenceGroup {
    private static final String CONTRIBUTION_FACTORY = "com.ibm.ccl.sca.core.ContributionRuleFactory";
    private static final String COMPOSITE_FACTORY = "com.ibm.ccl.sca.core.CompositeRuleFactory";
    private static final String CONFIG_EXT_ID = "com.ibm.ccl.sca.ui.validationRulesConfiguration";
    private static final String VAL_BUILDER_ID = "org.eclipse.wst.validation.validationbuilder";
    private static final String[] BUTTON_LABELS = new String[]{Messages.LABEL_YES, Messages.LABEL_NO, Messages.LABEL_CANCEL};
    private Shell shell;
    private IProject project;
    private ValidationRulesConfiguration config;

    public ValidationPreferenceGroup(Shell shell, IProject project) {
        this.shell = shell;
        this.project = project;
    }

    public void createInto(Composite parent) {
        IConfigurationElement[] configs;
        ArrayList<String> coreIds = new ArrayList<String>();
        coreIds.add(CONTRIBUTION_FACTORY);
        coreIds.add(COMPOSITE_FACTORY);
        TreeSet<SectionInfo> otherIds = new TreeSet<SectionInfo>(new Comparator<SectionInfo>(){

            @Override
            public int compare(SectionInfo object1, SectionInfo object2) {
                if (!object1.weight.equals(object2.weight)) {
                    return object1.weight.compareTo(object2.weight);
                }
                return object1.label.compareTo(object2.label);
            }
        });
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = configs = extensionRegistry.getConfigurationElementsFor(CONFIG_EXT_ID);
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement factories = iConfigurationElementArray[n2];
            String label = factories.getDeclaringExtension().getLabel();
            if (label == null || label.length() == 0) {
                IConfigurationElement[] iConfigurationElementArray2 = factories.getChildren();
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement factory = iConfigurationElementArray2[n4];
                    coreIds.add(factory.getAttribute("id"));
                    ++n4;
                }
            } else {
                Float weight = Float.valueOf(0.0f);
                try {
                    String attr = factories.getAttribute("weight");
                    if (attr != null) {
                        weight = Float.valueOf(attr);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    weight = Float.valueOf(0.0f);
                }
                IConfigurationElement[] children = factories.getChildren();
                String[] ids = new String[children.length];
                int i = 0;
                while (i < children.length) {
                    ids[i] = children[i].getAttribute("id");
                    ++i;
                }
                otherIds.add(new SectionInfo(weight.floatValue(), label, ids));
            }
            ++n2;
        }
        this.config = new ValidationRulesConfiguration(this.project);
        this.config.addSection(Messages.LABEL_CORE_ASSEMBLY_RULES, coreIds.toArray(new String[coreIds.size()]));
        for (SectionInfo section : otherIds) {
            this.config.addSection(section.label, section.ids);
        }
        this.config.createInto(parent);
    }

    public ValidationRulesConfiguration getConfig() {
        return this.config;
    }

    public boolean applyChanges(boolean useProjectSettings) {
        boolean doBuild = false;
        if (this.config.isDirty()) {
            String message = this.project == null ? Messages.MSG_VALIDATION_SETTINGS_CHANGED : Messages.MSG_PROJECT_VALIDATION_SETTINGS_CHANGED;
            MessageDialog dialog = new MessageDialog(this.shell, Messages.TITLE_VALIDATION_SETTINGS_CHANGED, null, message, 3, BUTTON_LABELS, 2);
            int build = dialog.open();
            if (build == -1 || build == 2) {
                return false;
            }
            doBuild = build == 0;
        }
        this.config.applyChanges(useProjectSettings);
        if (doBuild) {
            try {
                if (this.project == null) {
                    ResourcesPlugin.getWorkspace().build(6, null);
                } else {
                    this.project.build(6, VAL_BUILDER_ID, null, null);
                }
            }
            catch (CoreException e) {
                SCAToolsUIPlugin.getDefault().getLog().log(e.getStatus());
            }
        }
        return true;
    }

    private static class SectionInfo {
        Float weight;
        String label;
        String[] ids;

        SectionInfo(float weight, String label, String[] ids) {
            this.weight = Float.valueOf(weight);
            this.label = label;
            this.ids = ids;
        }
    }
}

