/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.preferences;

import com.ibm.ccl.sca.core.interfacetypes.InterfaceType;
import com.ibm.ccl.sca.core.plugin.SCAToolsCorePlugin;
import com.ibm.ccl.sca.core.preferences.SCAPreferences;
import com.ibm.ccl.sca.facets.core.Activator;
import com.ibm.ccl.sca.facets.core.SCAFacetUtils;
import com.ibm.ccl.sca.facets.core.impltype.IImplTypeChangeEvent;
import com.ibm.ccl.sca.facets.core.impltype.IImplTypeChangeListener;
import com.ibm.ccl.sca.facets.core.impltype.IImplTypePreferenceProvider;
import com.ibm.ccl.sca.facets.core.impltype.ImplTypeChangeEvent;
import com.ibm.ccl.sca.facets.core.impltype.ImplTypeEntry;
import com.ibm.ccl.sca.internal.ui.project.impltypes.ImplTypeContentProvider;
import com.ibm.ccl.sca.internal.ui.project.impltypes.ImplTypeLabelProvider;
import com.ibm.ccl.sca.ui.messages.Messages;
import com.ibm.ccl.sca.ui.util.LabelAndId;
import com.ibm.ccl.sca.ui.util.UIUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class SCAPreferencesComposite
extends Composite {
    private IProject project;
    private SCAPreferences preferences;
    private UIUtils utils;
    private Text folderLocation;
    private Text namespace;
    private Combo interfaceTypes;
    private CheckboxTableViewer implTypesTableViewer;
    private Combo implTypeSelected;
    private Set<ImplTypeEntry> allImplTypes;
    private Map<String, Boolean> oldSelectedMap;
    private IWorkbenchPreferenceContainer container;
    private IImplTypePreferenceProvider dataBindingPreferenceProvider;
    private String dataBindingKey;
    private Combo dataBindingCombo;
    public static final String POLICY_PAGE_ID = "org.eclipse.wst.ws.internal.ui.wsi.preferences.WSICompliancePreferencePage";
    public static final String PROJECT_POLICY_PAGE_ID = "org.eclipse.wst.ws.internal.ui.wsi.properties.WSICompliancePropertyPage";

    public SCAPreferencesComposite(Composite parent, int style, IProject project, IWorkbenchPreferenceContainer container) {
        super(parent, style);
        this.project = project;
        this.preferences = SCAToolsCorePlugin.getInstance().getPreferences();
        this.utils = new UIUtils("com.ibm.ccl.sca.ui");
        this.container = container;
    }

    public Control createContents() {
        this.allImplTypes = Activator.getDefault().getAllImplTypes();
        GridLayout layout = new GridLayout();
        GridData gridData = new GridData(1808);
        layout.numColumns = 2;
        layout.horizontalSpacing = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(gridData);
        this.folderLocation = this.utils.createText(this, Messages.SCAPreferencesComposite_0, null, null, 2048);
        this.namespace = this.utils.createText(this, Messages.SCAPreferencesComposite_3, null, null, 2048);
        this.interfaceTypes = this.utils.createCombo(this, Messages.SCAPreferencesComposite_1, null, null, 8);
        gridData = new GridData(768);
        Label horizontalSpan = new Label((Composite)this, 258);
        gridData.horizontalSpan = 2;
        horizontalSpan.setLayoutData((Object)gridData);
        Label implTypesLabel = new Label((Composite)this, 16384);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        implTypesLabel.setLayoutData((Object)gridData);
        implTypesLabel.setText(Messages.LABEL_IMPL_TYPES_PROPERTY);
        ScrolledComposite implTypesScroll = new ScrolledComposite((Composite)this, 2816);
        implTypesScroll.setExpandHorizontal(true);
        implTypesScroll.setExpandVertical(true);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        implTypesScroll.setLayoutData((Object)gridData);
        Table table = new Table((Composite)implTypesScroll, 65568);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        new TableColumn(table, 0);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(90));
        this.implTypesTableViewer = new CheckboxTableViewer(table);
        implTypesScroll.setContent((Control)this.implTypesTableViewer.getTable());
        this.implTypesTableViewer.setContentProvider((IContentProvider)new ImplTypeContentProvider());
        this.implTypesTableViewer.setLabelProvider((IBaseLabelProvider)new ImplTypeLabelProvider(this.allImplTypes, this.project, null));
        this.implTypesTableViewer.setSorter(new ViewerSorter());
        this.implTypesTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ImplTypeEntry entry = (ImplTypeEntry)event.getElement();
                SCAPreferencesComposite.this.implTypeChecked(entry);
                SCAPreferencesComposite.this.setImplSelectValues(false);
            }
        });
        this.setupTableViewer(this.implTypesTableViewer);
        this.implTypeSelected = this.utils.createCombo(this, Messages.SCAPreferencesComposite_2, null, null, 8);
        for (ImplTypeEntry entry : this.allImplTypes) {
            this.dataBindingPreferenceProvider = entry.getPreferenceProvider();
            if (this.dataBindingPreferenceProvider == null) continue;
            gridData = new GridData(768);
            horizontalSpan = new Label((Composite)this, 258);
            gridData.horizontalSpan = 2;
            horizontalSpan.setLayoutData((Object)gridData);
            this.dataBindingKey = this.dataBindingPreferenceProvider.getKeys()[0];
            this.dataBindingCombo = this.utils.createCombo(this, this.dataBindingPreferenceProvider.getKeyLabel(this.dataBindingKey), null, null, 8);
            String[] stringArray = this.dataBindingPreferenceProvider.getValueLabels(this.dataBindingKey);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String valueLabel = stringArray[n2];
                this.dataBindingCombo.add(valueLabel);
                ++n2;
            }
            break block0;
        }
        Link intentSettings = UIUtils.createLinkToPage(this, Messages.SCAPreferencesComposite_6, this.getPolicyId(), this.container);
        intentSettings.setLayoutData((Object)new GridData(1, 0x1000008, false, false));
        this.init();
        this.storeOldSelectedImpls();
        return this;
    }

    public void enableControls(boolean enabled) {
        this.folderLocation.setEnabled(enabled);
        this.namespace.setEnabled(enabled);
        this.interfaceTypes.setEnabled(enabled);
        this.implTypesTableViewer.getTable().setEnabled(enabled);
        this.implTypeSelected.setEnabled(enabled);
        if (this.dataBindingCombo != null) {
            this.dataBindingCombo.setEnabled(enabled);
        }
    }

    private void storeOldSelectedImpls() {
        this.oldSelectedMap = new HashMap<String, Boolean>();
        for (ImplTypeEntry entry : this.allImplTypes) {
            String id = entry.getID();
            if (!entry.isEnabled(this.project)) continue;
            this.oldSelectedMap.put(id, this.preferences.getSelectedImplType(id, this.project));
        }
    }

    private void implTypeChecked(ImplTypeEntry entry) {
        if (entry.isRequired()) {
            this.implTypesTableViewer.setChecked((Object)entry, true);
        }
        if (!entry.isEnabled(this.project)) {
            this.implTypesTableViewer.setChecked((Object)entry, false);
        }
    }

    private void setupTableViewer(CheckboxTableViewer implTypesTableViewer) {
        implTypesTableViewer.setInput(this.allImplTypes);
        for (ImplTypeEntry entry : this.allImplTypes) {
            if (!entry.isRequired() && entry.isEnabled(this.project)) continue;
            implTypesTableViewer.setGrayed((Object)entry, true);
        }
    }

    private void setImplSelectValues(boolean useDefaultValue) {
        ArrayList<ImplTypeEntry> types = new ArrayList<ImplTypeEntry>();
        LabelAndId[] labelAndIds = null;
        String defaultId = null;
        int defaultIndex = -1;
        if (useDefaultValue) {
            defaultId = this.preferences.getDefaultImplTypeID(this.project);
        } else {
            LabelAndId[] oldLabelAndIds = (LabelAndId[])this.implTypeSelected.getData();
            defaultId = oldLabelAndIds[this.implTypeSelected.getSelectionIndex()].id;
        }
        for (ImplTypeEntry entry : this.allImplTypes) {
            if (!this.implTypesTableViewer.getChecked((Object)entry)) continue;
            types.add(entry);
        }
        labelAndIds = new LabelAndId[types.size() + 1];
        labelAndIds[0] = new LabelAndId();
        labelAndIds[0].id = "";
        labelAndIds[0].label = Messages.SCAPreferencesComposite_4;
        int index = 1;
        while (index < labelAndIds.length) {
            labelAndIds[index] = new LabelAndId();
            labelAndIds[index].id = ((ImplTypeEntry)types.get(index - 1)).getID();
            labelAndIds[index].label = ((ImplTypeEntry)types.get(index - 1)).getName();
            ++index;
        }
        this.implTypeSelected.removeAll();
        index = 0;
        while (index < labelAndIds.length) {
            LabelAndId labelAndId = labelAndIds[index];
            this.implTypeSelected.add(labelAndId.label);
            if (labelAndId.id.equals(defaultId)) {
                defaultIndex = index;
            }
            ++index;
        }
        if (defaultIndex == -1) {
            defaultIndex = 0;
        }
        this.implTypeSelected.select(defaultIndex);
        this.implTypeSelected.setData((Object)labelAndIds);
    }

    private void setDataBindingValues() {
        String selectedValue = this.preferences.getExtendedPref(this.dataBindingKey, this.dataBindingPreferenceProvider.getValues(this.dataBindingKey)[0], this.project);
        this.dataBindingCombo.select(this.dataBindingPreferenceProvider.indexOf(this.dataBindingKey, selectedValue));
    }

    public void init() {
        this.folderLocation.setText(this.preferences.getDefaultProjectFolder(this.project));
        this.namespace.setText(this.preferences.getNamespace(this.project));
        this.setInterfaceValues();
        this.setImplValues();
        this.setImplSelectValues(true);
        if (this.dataBindingPreferenceProvider != null) {
            this.setDataBindingValues();
        }
    }

    private void setInterfaceValues() {
        List types = SCAToolsCorePlugin.getInstance().getInterfaceRegistry().getInterfaceTypes();
        LabelAndId[] labelAndIds = new LabelAndId[types.size() + 1];
        String defaultId = this.preferences.getDefaultInterfaceTypeID(this.project);
        String defaultLabel = null;
        labelAndIds[0] = new LabelAndId();
        labelAndIds[0].id = "";
        labelAndIds[0].label = Messages.SCAPreferencesComposite_5;
        int index = 1;
        while (index < labelAndIds.length) {
            labelAndIds[index] = new LabelAndId();
            labelAndIds[index].id = ((InterfaceType)types.get(index - 1)).getId();
            labelAndIds[index].label = ((InterfaceType)types.get(index - 1)).getName();
            ++index;
        }
        this.interfaceTypes.removeAll();
        LabelAndId[] labelAndIdArray = labelAndIds;
        int n = labelAndIds.length;
        int n2 = 0;
        while (n2 < n) {
            LabelAndId labelAndId = labelAndIdArray[n2];
            this.interfaceTypes.add(labelAndId.label);
            if (labelAndId.id.equals(defaultId)) {
                defaultLabel = labelAndId.label;
            }
            ++n2;
        }
        this.interfaceTypes.setText(defaultLabel);
        this.interfaceTypes.setData((Object)labelAndIds);
    }

    private void setImplValues() {
        for (ImplTypeEntry entry : this.allImplTypes) {
            if (entry.isEnabled(this.project)) {
                this.implTypesTableViewer.setChecked((Object)entry, this.preferences.getSelectedImplType(entry.getID(), this.project));
                continue;
            }
            this.implTypesTableViewer.setChecked((Object)entry, false);
        }
    }

    public void performDefaults() {
        this.preferences.restoreDefaults(this.project);
        this.init();
    }

    public void storeValues() {
        this.preferences.setDefaultProjectFolder(this.folderLocation.getText(), this.project);
        this.preferences.setNamespace(this.namespace.getText(), this.project);
        int selectionIndex = this.interfaceTypes.getSelectionIndex();
        LabelAndId[] labelAndIds = (LabelAndId[])this.interfaceTypes.getData();
        this.preferences.setDefaultInterfaceTypeID(labelAndIds[selectionIndex].id, this.project);
        for (ImplTypeEntry entry : this.allImplTypes) {
            this.preferences.setSelectedImplType(entry.getID(), this.implTypesTableViewer.getChecked((Object)entry), this.project);
        }
        selectionIndex = this.implTypeSelected.getSelectionIndex();
        labelAndIds = (LabelAndId[])this.implTypeSelected.getData();
        this.preferences.setDefaultImplypeID(labelAndIds[selectionIndex].id, this.project);
        if (this.dataBindingPreferenceProvider != null) {
            this.preferences.setExtendedPref(this.dataBindingKey, this.dataBindingPreferenceProvider.getValues(this.dataBindingKey)[this.dataBindingCombo.getSelectionIndex()], this.project);
        }
        this.preferences.flushPreferences(this.project);
        this.callListeners();
        this.storeOldSelectedImpls();
    }

    public boolean checkIfOkToSaveValues() {
        boolean okToSave = true;
        for (ImplTypeEntry entry : this.allImplTypes) {
            String id = entry.getID();
            Boolean oldValue = this.oldSelectedMap.get(id);
            boolean newValue = this.implTypesTableViewer.getChecked((Object)entry);
            if (oldValue == null || oldValue == newValue) continue;
            okToSave = false;
            break;
        }
        if (!okToSave) {
            String message = null;
            message = this.project == null ? Messages.SCAPreferencesComposite_7 : Messages.SCAPreferencesComposite_8;
            okToSave = MessageDialog.openConfirm((Shell)this.folderLocation.getShell(), (String)Messages.SCAPreferencesComposite_9, (String)message);
        }
        return okToSave;
    }

    public boolean performCancel() {
        this.preferences.cancelPreferences(this.project);
        return true;
    }

    public void dispose() {
        super.dispose();
    }

    private void callListeners() {
        IProject[] projects = null;
        projects = this.project == null ? ResourcesPlugin.getWorkspace().getRoot().getProjects() : new IProject[]{this.project};
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject projectToUpdate = iProjectArray[n2];
            if (this.project != null || SCAFacetUtils.isSCAProject((IProject)projectToUpdate) && !this.preferences.isProjectEnabled(projectToUpdate)) {
                for (ImplTypeEntry entry : this.allImplTypes) {
                    String id = entry.getID();
                    Boolean oldValue = this.oldSelectedMap.get(id);
                    boolean newValue = this.implTypesTableViewer.getChecked((Object)entry);
                    if (oldValue == null || oldValue == newValue) continue;
                    this.callListener(entry, projectToUpdate, newValue);
                }
            }
            ++n2;
        }
    }

    private void callListener(ImplTypeEntry entry, IProject projectToUpdate, boolean add) {
        try {
            IImplTypeChangeListener listener = entry.getListener();
            if (listener != null) {
                listener.implTypeChanged((IImplTypeChangeEvent)new ImplTypeChangeEvent(projectToUpdate, add));
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private String getPolicyId() {
        return this.project == null ? POLICY_PAGE_ID : PROJECT_POLICY_PAGE_ID;
    }
}

