/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.preferences;

import com.ibm.ccl.sca.internal.ui.preferences.CorePreferences;
import com.ibm.ccl.sca.internal.ui.preferences.UIPreferences;
import com.ibm.ccl.sca.ui.messages.Messages;
import com.ibm.ccl.sca.ui.util.UIUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class ImportExportPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private String INFOPOP_IMPORTEXPORT_PREFERENCES = "IMPORTEXPORT_PREFERENCES";
    protected UIPreferences scaUIPreferences = this.getUIPreferences();
    protected CorePreferences scaCorePreferences;
    protected Button overwriteExistingArchiveFileCheckbox;
    protected Button overwriteExistingResourcesCheckbox;
    protected Button importCompositeDiagramFilesCheckbox;
    protected Button exportCompositeDiagramFilesCheckbox;
    protected Button useArchiveCompressionCheckbox;

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.ccl.sca.ui." + this.INFOPOP_IMPORTEXPORT_PREFERENCES);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(784);
        composite.setLayoutData((Object)data);
        this.createArchiveExportOptionsGroup(composite);
        this.createArchiveImportOptionsGroup(composite);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void createArchiveExportOptionsGroup(Composite parent) {
        UIUtils uiUtils = new UIUtils("com.ibm.ccl.sca.ui");
        Group projectGroup = uiUtils.createGroup(parent, Messages.SCA_ARCHIVE_EXPORT_PREFS_OPTIONS_GROUP_TITLE, null, null);
        Composite optionsComposite = new Composite((Composite)projectGroup, 0);
        GridLayout layout = new GridLayout();
        optionsComposite.setLayout((Layout)layout);
        optionsComposite.setLayoutData((Object)new GridData(768));
        this.createArchiveExportOptionsGroupButtons(optionsComposite);
    }

    protected void createArchiveExportOptionsGroupButtons(Composite parent) {
        Font font = parent.getFont();
        parent.setLayout((Layout)new GridLayout(2, true));
        Composite left = new Composite(parent, 0);
        left.setLayoutData((Object)new GridData(16384, 128, true, false));
        left.setLayout((Layout)new GridLayout(1, true));
        this.useArchiveCompressionCheckbox = new Button(left, 16416);
        this.useArchiveCompressionCheckbox.setText(Messages.SCA_COMPRESS_ARCHIVE_CHECKBOX_TEXT);
        this.useArchiveCompressionCheckbox.setFont(font);
        this.useArchiveCompressionCheckbox.setSelection(this.scaUIPreferences.getCompressArchivePref());
        this.overwriteExistingArchiveFileCheckbox = new Button(left, 16416);
        this.overwriteExistingArchiveFileCheckbox.setText(Messages.SCA_OVERWRITE_FILES_WITHOUT_WARNING_LABEL_TEXT);
        this.overwriteExistingArchiveFileCheckbox.setFont(font);
        this.overwriteExistingArchiveFileCheckbox.setSelection(this.scaUIPreferences.getOverwriteArchiveWithoutWarningPref());
        Composite right = new Composite(parent, 0);
        right.setLayoutData((Object)new GridData(16384, 128, true, false));
        right.setLayout((Layout)new GridLayout(1, true));
        this.createAdditionalExportOptions(right, font);
    }

    protected void createAdditionalExportOptions(Composite optionsGroup, Font font) {
        this.exportCompositeDiagramFilesCheckbox = new Button(optionsGroup, 16416);
        this.exportCompositeDiagramFilesCheckbox.setText(Messages.SCA_EXPORT_COMPOSITE_FILES_MESSAGE);
        this.exportCompositeDiagramFilesCheckbox.setFont(font);
        this.exportCompositeDiagramFilesCheckbox.setSelection(this.scaUIPreferences.getExportDiagramFilesPref());
    }

    protected void createArchiveImportOptionsGroup(Composite parent) {
        UIUtils uiUtils = new UIUtils("com.ibm.ccl.sca.ui");
        Group projectGroup = uiUtils.createGroup(parent, Messages.SCA_ARCHIVE_IMPORT_PREFS_OPTIONS_GROUP_TITLE, null, null);
        Composite optionsComposite = new Composite((Composite)projectGroup, 0);
        GridLayout layout = new GridLayout();
        optionsComposite.setLayout((Layout)layout);
        optionsComposite.setLayoutData((Object)new GridData(768));
        this.createArchiveImportOptionsGroupButtons(optionsComposite);
    }

    protected void createArchiveImportOptionsGroupButtons(Composite optionsGroup) {
        Font font = optionsGroup.getFont();
        optionsGroup.setLayout((Layout)new GridLayout(2, true));
        Composite left = new Composite(optionsGroup, 0);
        left.setLayoutData((Object)new GridData(16384, 128, true, false));
        left.setLayout((Layout)new GridLayout(1, true));
        this.overwriteExistingResourcesCheckbox = new Button(left, 16416);
        this.overwriteExistingResourcesCheckbox.setText(Messages.SCA_OVERWRITE_EXISTING_PROJECT_RESOURCES_WITHOUT_WARNING_LABEL_TEXT);
        this.overwriteExistingResourcesCheckbox.setFont(font);
        this.overwriteExistingResourcesCheckbox.setSelection(this.scaUIPreferences.getOverwriteExistingResourcesWarningPref());
        Composite right = new Composite(optionsGroup, 0);
        right.setLayoutData((Object)new GridData(16384, 128, true, false));
        right.setLayout((Layout)new GridLayout(1, true));
        this.createAdditionalImportOptions(right, font);
    }

    protected void createAdditionalImportOptions(Composite optionsGroup, Font font) {
        this.importCompositeDiagramFilesCheckbox = new Button(optionsGroup, 16416);
        this.importCompositeDiagramFilesCheckbox.setText(Messages.SCA_IMPORT_COMPOSITE_FILES_MESSAGE);
        this.importCompositeDiagramFilesCheckbox.setFont(font);
        this.importCompositeDiagramFilesCheckbox.setSelection(this.scaUIPreferences.getImportDiagramFilesPref());
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.overwriteExistingArchiveFileCheckbox.setSelection(this.scaUIPreferences.getDefaultOverwriteArchiveWithoutWarningPref());
        this.exportCompositeDiagramFilesCheckbox.setSelection(this.scaUIPreferences.getDefaultExportDiagramFilesPref());
        this.importCompositeDiagramFilesCheckbox.setSelection(this.scaUIPreferences.getDefaultImportDiagramFilesPref());
        this.useArchiveCompressionCheckbox.setSelection(this.scaUIPreferences.getDefaultCompressArchivePref());
        this.overwriteExistingResourcesCheckbox.setSelection(this.scaUIPreferences.getDefaultImportDiagramFilesPref());
        super.performDefaults();
    }

    public boolean performOk() {
        this.scaUIPreferences.setOverwriteArchiveWithoutWarningPref(this.overwriteExistingArchiveFileCheckbox.getSelection());
        this.scaUIPreferences.setExportDiagramFilesPref(this.exportCompositeDiagramFilesCheckbox.getSelection());
        this.scaUIPreferences.setImportDiagramFilesPref(this.importCompositeDiagramFilesCheckbox.getSelection());
        this.scaUIPreferences.setCompressArchivePref(this.useArchiveCompressionCheckbox.getSelection());
        this.scaUIPreferences.setOverwriteExistingResourcesWithoutWarningPref(this.overwriteExistingResourcesCheckbox.getSelection());
        return true;
    }

    public CorePreferences getCorePreferences() {
        return CorePreferences.getInstance();
    }

    public UIPreferences getUIPreferences() {
        return new UIPreferences();
    }
}

