/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.navigator.provider;

import com.ibm.ccl.sca.core.model.ISCAArtifact;
import com.ibm.ccl.sca.core.model.ISCAModelChangeListener;
import com.ibm.ccl.sca.core.model.ISCAProject;
import com.ibm.ccl.sca.core.model.SCAModelChangeEvent;
import com.ibm.ccl.sca.core.model.SCAModelManager;
import com.ibm.ccl.sca.core.tracing.SCATrace;
import com.ibm.ccl.sca.internal.ui.navigator.framework.IRefreshHandlerListener;
import com.ibm.ccl.sca.internal.ui.navigator.framework.IRootObjectProvider;
import com.ibm.ccl.sca.internal.ui.navigator.framework.ModelManager;
import com.ibm.ccl.sca.internal.ui.navigator.provider.SCAContentProvider;
import com.ibm.ccl.sca.ui.navigator.IDisposable;
import com.ibm.ccl.sca.ui.navigator.ISCANode;
import com.ibm.ccl.sca.ui.navigator.SCABaseContentProvider;
import com.ibm.ccl.sca.ui.navigator.SCARootNode;
import com.ibm.ccl.sca.ui.plugin.SCAToolsUIPlugin;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;

public class SCARootObjectProvider
implements IRootObjectProvider,
ISCAModelChangeListener {
    private static final String TRACE_COMPONENT = "navigator";
    private static final Object[] EMPTY = new Object[0];
    private SCAContentProvider contentProvider;
    private Map<String, Set<Object>> loadedSets;
    private ListenerList listeners;

    public SCARootObjectProvider(SCAContentProvider contentProvider) {
        this.contentProvider = contentProvider;
        this.loadedSets = new Hashtable<String, Set<Object>>();
        this.listeners = new ListenerList();
        SCAModelManager.addModelChangeListener((ISCAModelChangeListener)this);
    }

    private String getProjectPath(Object context) {
        IProject project = null;
        if (context instanceof IProject) {
            project = (IProject)context;
        } else if (context instanceof ISCANode) {
            project = ((ISCANode)context).getProject();
        } else if (context instanceof ISCAArtifact) {
            project = ((ISCAArtifact)context).getParent();
        }
        if (project == null) {
            return null;
        }
        return project.getFullPath().toString();
    }

    @Override
    public synchronized void setModelLoaded(Object context, boolean modelLoaded) {
        String projectPath = null;
        if (context instanceof ISCAArtifact) {
            ISCAArtifact artifact = (ISCAArtifact)context;
            if (artifact.getResources().isEmpty()) {
                return;
            }
            projectPath = artifact.getParent().getFullPath().toString();
        } else {
            projectPath = this.getProjectPath(context);
            if (projectPath == null) {
                return;
            }
        }
        Set<Object> set = this.loadedSets.get(projectPath);
        if (modelLoaded) {
            if (set == null) {
                set = new HashSet<Object>();
                this.loadedSets.put(projectPath, set);
            }
            SCATrace.trace((Plugin)SCAToolsUIPlugin.getDefault(), (String)TRACE_COMPONENT, (int)2, (String)("Setting loaded state for " + context));
            set.add(context);
        } else if (set != null) {
            SCATrace.trace((Plugin)SCAToolsUIPlugin.getDefault(), (String)TRACE_COMPONENT, (int)2, (String)("Clearing loaded state for " + context));
            set.remove(context);
            if (set.isEmpty()) {
                this.loadedSets.remove(projectPath);
            }
        }
    }

    @Override
    public synchronized boolean hasLoadedModels(Object context) {
        String projectPath = this.getProjectPath(context);
        if (projectPath == null) {
            return false;
        }
        Set<Object> set = this.loadedSets.get(projectPath);
        return set != null && set.contains(context);
    }

    @Override
    public void setModelManager(ModelManager modelManager, Object context) {
    }

    @Override
    public Object[] getModels(Object context) {
        if (context instanceof SCARootNode) {
            Vector<Object> nodes = new Vector<Object>();
            for (SCABaseContentProvider provider : this.contentProvider.getChildProviders()) {
                Object[] objects = provider.getElements(context);
                if (objects == null || objects.length == 0) continue;
                SCATrace.trace((Plugin)SCAToolsUIPlugin.getDefault(), (String)TRACE_COMPONENT, (int)2, (String)("Retrieving top-level elements for " + context + " from " + provider));
                nodes.addAll(Arrays.asList(objects));
            }
            return nodes.toArray();
        }
        for (SCABaseContentProvider provider : this.contentProvider.getChildProviders()) {
            Object[] objects = provider.getChildren(context);
            if (objects == null || objects.length <= 0) continue;
            SCATrace.trace((Plugin)SCAToolsUIPlugin.getDefault(), (String)TRACE_COMPONENT, (int)2, (String)("Retrieving elements for " + context + " from " + provider));
            StructuredViewer viewer = this.contentProvider.getViewer();
            viewer.getSorter().sort((Viewer)viewer, objects);
            return objects;
        }
        return EMPTY;
    }

    @Override
    public void addRefreshHandlerListener(IRefreshHandlerListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeRefreshHandlerListener(IRefreshHandlerListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public void notifyListeners(Object context) {
        Object[] objs;
        Object[] objectArray = objs = this.listeners.getListeners();
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            ((IRefreshHandlerListener)obj).onRefresh(context);
            ++n2;
        }
    }

    private synchronized void resetProjectLoadedState(IProject project) {
        String projectPath = project.getFullPath().toString();
        Set<Object> set = this.loadedSets.get(projectPath);
        if (set != null) {
            SCATrace.trace((Plugin)SCAToolsUIPlugin.getDefault(), (String)TRACE_COMPONENT, (int)2, (String)("Clearing all loaded states for " + project));
            set.clear();
            this.loadedSets.remove(projectPath);
        }
    }

    private synchronized void cleanLoadedState(Object context) {
        String projectPath = this.getProjectPath(context);
        if (projectPath == null) {
            return;
        }
        Set<Object> set = this.loadedSets.get(projectPath);
        if (set == null) {
            return;
        }
        Iterator<Object> iter = set.iterator();
        block0: while (iter.hasNext()) {
            IDisposable disposable;
            Object obj = iter.next();
            if (obj instanceof ISCAArtifact) {
                for (IResource resource : ((ISCAArtifact)obj).getResources()) {
                    if (resource.exists()) continue block0;
                }
                SCATrace.trace((Plugin)SCAToolsUIPlugin.getDefault(), (String)TRACE_COMPONENT, (int)2, (String)("Clearing loaded state for " + obj));
                iter.remove();
                continue;
            }
            if (!(obj instanceof IDisposable) || !(disposable = (IDisposable)obj).isDisposed()) continue;
            SCATrace.trace((Plugin)SCAToolsUIPlugin.getDefault(), (String)TRACE_COMPONENT, (int)2, (String)("Clearing loaded state for " + obj));
            iter.remove();
        }
        if (set.isEmpty()) {
            this.loadedSets.remove(projectPath);
        }
    }

    public void modelChanged(SCAModelChangeEvent event) {
        Object context = null;
        IProject project = null;
        int type = event.getType();
        block0 : switch (type) {
            case 8: 
            case 16: {
                return;
            }
            case 32: {
                project = ((ISCAProject)event.getSource()).getProject();
                this.resetProjectLoadedState(project);
                this.contentProvider.handleDelete(project);
                return;
            }
            case 64: {
                context = event.getSource();
                break;
            }
            case 128: {
                context = event.getSource();
                project = (IProject)context;
                this.resetProjectLoadedState(project);
                this.contentProvider.handleDelete(project);
                break;
            }
            default: {
                for (SCABaseContentProvider provider : this.contentProvider.getChildProviders()) {
                    context = provider.processEvent(event);
                    if (context == null) continue;
                    if ((type & 4) == 0) break block0;
                    this.cleanLoadedState(context);
                    break block0;
                }
            }
        }
        if (context == null) {
            return;
        }
        this.notifyListeners(context);
    }

    @Override
    public void dispose() {
        SCAModelManager.removeModelChangeListener((ISCAModelChangeListener)this);
        for (Set<Object> set : this.loadedSets.values()) {
            set.clear();
        }
        this.loadedSets.clear();
        this.listeners.clear();
    }
}

