/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.navigator.provider;

import com.ibm.ccl.sca.internal.ui.navigator.SCANodeRegistry;
import com.ibm.ccl.sca.internal.ui.navigator.framework.AbstractLabelProvider;
import com.ibm.ccl.sca.ui.navigator.ISCANode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.IDescriptionProvider;

public class SCALabelProvider
extends AbstractLabelProvider {
    private List<ILabelProvider> childProviders = new ArrayList<ILabelProvider>();
    private ListenerList listenerList;

    public SCALabelProvider() {
        this.childProviders.addAll(SCANodeRegistry.getInstance().getLabelProviders());
        this.listenerList = new ListenerList();
    }

    public void init(ICommonContentExtensionSite config) {
    }

    @Override
    public Image getImage(Object element) {
        Image image = super.getImage(element);
        if (image != null) {
            return image;
        }
        if (element instanceof ISCANode) {
            return ((ISCANode)element).getImage();
        }
        for (ILabelProvider provider : this.childProviders) {
            image = provider.getImage(element);
            if (image == null) continue;
            return image;
        }
        return null;
    }

    @Override
    public String getText(Object element) {
        String text = super.getText(element);
        if (text != null) {
            return text;
        }
        if (element instanceof ISCANode) {
            return ((ISCANode)element).getText();
        }
        for (ILabelProvider provider : this.childProviders) {
            text = provider.getText(element);
            if (text == null || text.length() <= 0) continue;
            return text;
        }
        return "???";
    }

    public String getDescription(Object anElement) {
        if (anElement instanceof ISCANode) {
            return ((ISCANode)anElement).getText();
        }
        for (ILabelProvider provider : this.childProviders) {
            String text;
            if (!(provider instanceof IDescriptionProvider) || (text = ((IDescriptionProvider)provider).getDescription(anElement)) == null || text.length() <= 0) continue;
            return text;
        }
        return null;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
        this.listenerList.add((Object)listener);
        for (ILabelProvider provider : this.childProviders) {
            provider.addListener(listener);
        }
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listenerList.remove((Object)listener);
        for (ILabelProvider provider : this.childProviders) {
            provider.removeListener(listener);
        }
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public void dispose() {
        for (ILabelProvider provider : this.childProviders) {
            provider.dispose();
        }
        this.childProviders.clear();
        this.childProviders = null;
        this.listenerList.clear();
        this.listenerList = null;
    }
}

