/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.navigator.provider;

import com.ibm.ccl.sca.core.model.ISCAArtifact;
import com.ibm.ccl.sca.core.model.ISCAContribution;
import com.ibm.ccl.sca.core.model.ISCAFilter;
import com.ibm.ccl.sca.core.model.ISCAProject;
import com.ibm.ccl.sca.core.model.SCAModelChangeEvent;
import com.ibm.ccl.sca.core.model.SCAModelManager;
import com.ibm.ccl.sca.internal.ui.navigator.node.ContributionNode;
import com.ibm.ccl.sca.internal.ui.navigator.provider.IProjectBasedProvider;
import com.ibm.ccl.sca.ui.navigator.ISCANode;
import com.ibm.ccl.sca.ui.navigator.SCABaseContentProvider;
import com.ibm.ccl.sca.ui.navigator.SCARootNode;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class ContributionContentProvider
extends SCABaseContentProvider
implements IProjectBasedProvider {
    private static final ISCAFilter<ISCAContribution> CONTRIBUTION_FILTER = new ISCAFilter<ISCAContribution>(){

        public boolean accept(ISCAContribution t) {
            return !t.isVirtual();
        }
    };
    private Map<String, ContributionNode> nodes = new Hashtable<String, ContributionNode>();

    @Override
    public synchronized void handleDelete(IProject project) {
        this.nodes.remove(project.getFullPath().toString());
    }

    public Object getParent(Object element) {
        if (element instanceof ISCAContribution) {
            ISCAContribution contribution = (ISCAContribution)element;
            return this.createTopLevelNode(this.rootNodeFactory.createRootNode(contribution.getResource().getProject()));
        }
        return null;
    }

    private List<ISCAContribution> getContributions(IProject project) {
        try {
            ISCAProject scaProject = SCAModelManager.createProject((IProject)project);
            return SCAModelManager.getContributions((ISCAProject)scaProject, CONTRIBUTION_FILTER);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ContributionNode) {
            ContributionNode node = (ContributionNode)element;
            List<ISCAContribution> contributions = this.getContributions(node.getProject());
            return contributions != null && contributions.size() > 0;
        }
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ContributionNode) {
            IProject project = ((ContributionNode)parentElement).getProject();
            List<ISCAContribution> contributions = this.getContributions(project);
            return contributions != null ? contributions.toArray() : null;
        }
        return null;
    }

    @Override
    public synchronized ISCANode createTopLevelNode(SCARootNode root) {
        String projectPath = root.getProject().getFullPath().toString();
        ContributionNode contributionNode = this.nodes.get(projectPath);
        if (contributionNode == null) {
            contributionNode = new ContributionNode(root);
            this.nodes.put(projectPath, contributionNode);
        }
        return contributionNode;
    }

    @Override
    public Object processEvent(SCAModelChangeEvent event) {
        Object toRefresh = null;
        switch (event.getType()) {
            case 9: 
            case 12: {
                IProject project = ((IResource)event.getSource()).getProject();
                String projectPath = project.getFullPath().toString();
                toRefresh = this.nodes.get(projectPath);
                break;
            }
            case 10: {
                IResource resource = (IResource)event.getSource();
                toRefresh = resource.getAdapter(ISCAArtifact.class);
            }
        }
        return toRefresh;
    }

    public void dispose() {
        this.nodes.clear();
        this.nodes = null;
    }
}

