/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.navigator.dnd;

import com.ibm.ccl.sca.core.model.ISCAContribution;
import com.ibm.ccl.sca.internal.ui.navigator.node.ContributionNode;
import com.ibm.ccl.sca.ui.navigator.ICopyMoveOperation;
import com.ibm.ccl.sca.ui.navigator.IPasteAssistant;
import com.ibm.ccl.sca.ui.navigator.ISCANode;
import com.ibm.ccl.sca.ui.navigator.SCARootNode;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class ContributionPasteAssistant
implements IPasteAssistant {
    private static final String META_INF = "META-INF";
    private static final String CONTRIBUTION_FILE = "sca-contribution.xml";
    private static final String CONTRIBUTION_GENERATED = "sca-contribution-generated.xml";

    @Override
    public IContainer getContainer(Object target) {
        if (target instanceof IContainer) {
            return (IContainer)target;
        }
        if (target instanceof IResource) {
            return ((IResource)target).getParent();
        }
        if (target instanceof ISCANode) {
            return ((ISCANode)target).getProject().getFolder(META_INF);
        }
        return ((ISCAContribution)target).getResource().getParent();
    }

    @Override
    public boolean accept(IStructuredSelection target, IResource[] resources) {
        return this.accept(target.getFirstElement(), resources);
    }

    @Override
    public boolean accept(Object target, IResource[] resources) {
        if (!(target instanceof IResource || target instanceof SCARootNode || target instanceof ContributionNode || target instanceof ISCAContribution)) {
            return false;
        }
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getType() != 1 || !resource.exists() || !CONTRIBUTION_FILE.equals(resource.getName()) && !CONTRIBUTION_GENERATED.equals(resource.getName())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean accept(IStructuredSelection selection, String[] filenames) {
        return this.accept(selection.getFirstElement(), filenames);
    }

    @Override
    public boolean accept(Object target, String[] filenames) {
        if (!(target instanceof IResource || target instanceof SCARootNode || target instanceof ContributionNode || target instanceof ISCAContribution)) {
            return false;
        }
        String[] stringArray = filenames;
        int n = filenames.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            IPath path = Path.fromOSString((String)filename);
            if (!CONTRIBUTION_FILE.equals(path.lastSegment()) && !CONTRIBUTION_GENERATED.equals(path.lastSegment())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public ICopyMoveOperation newCopyMoveOperation(Shell shell, IResource[] resources) {
        return null;
    }
}

