/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.navigator.action;

import com.ibm.ccl.sca.internal.ui.navigator.SCANodeRegistry;
import com.ibm.ccl.sca.internal.ui.navigator.dnd.SelectionHelper;
import com.ibm.ccl.sca.ui.messages.Messages;
import com.ibm.ccl.sca.ui.navigator.ICopyMoveOperation;
import com.ibm.ccl.sca.ui.navigator.IPasteAssistant;
import com.ibm.ccl.sca.ui.navigator.ISCANode;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.part.ResourceTransfer;

public class PasteAction
extends SelectionListenerAction {
    private Clipboard clipboard;
    private Shell shell;
    private IContainer destination;
    private int index;

    public PasteAction(Clipboard clipboard, Shell shell) {
        super(Messages.PASTE);
        this.clipboard = clipboard;
        this.shell = shell;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        Object target = selection.getFirstElement();
        if (target instanceof ISCANode ? selection.size() > 1 : SelectionHelper.validateAndExtract(selection) == null) {
            return false;
        }
        IResource[] resources = (IResource[])this.clipboard.getContents((Transfer)ResourceTransfer.getInstance());
        String[] filenames = (String[])this.clipboard.getContents((Transfer)FileTransfer.getInstance());
        this.destination = null;
        this.index = 0;
        List<IPasteAssistant> pasteAssistants = SCANodeRegistry.getInstance().getPasteAssistants();
        for (IPasteAssistant pasteAssistant : pasteAssistants) {
            if (resources != null) {
                if (pasteAssistant.accept(selection, resources)) {
                    this.destination = pasteAssistant.getContainer(target);
                    break;
                }
            } else if (filenames != null && pasteAssistant.accept(selection, filenames)) {
                this.destination = pasteAssistant.getContainer(target);
                break;
            }
            ++this.index;
        }
        return this.destination != null;
    }

    public void run() {
        IResource[] resources = (IResource[])this.clipboard.getContents((Transfer)ResourceTransfer.getInstance());
        if (resources != null) {
            List<IPasteAssistant> pasteAssistants = SCANodeRegistry.getInstance().getPasteAssistants();
            IPasteAssistant pasteAssistant = pasteAssistants.get(this.index);
            ICopyMoveOperation customOperation = pasteAssistant.newCopyMoveOperation(this.shell, resources);
            if (customOperation != null) {
                customOperation.copyTo(this.destination);
            } else {
                CopyFilesAndFoldersOperation defaultOeration = new CopyFilesAndFoldersOperation(this.shell);
                defaultOeration.copyResources(resources, this.destination);
            }
            return;
        }
        String[] filenames = (String[])this.clipboard.getContents((Transfer)FileTransfer.getInstance());
        if (filenames != null) {
            CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(this.shell);
            operation.copyFiles(filenames, this.destination);
        }
    }
}

