/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.navigator.action;

import com.ibm.ccl.sca.core.model.ISCAArtifact;
import com.ibm.ccl.sca.internal.ui.navigator.node.ComponentNode;
import com.ibm.ccl.sca.ui.messages.Messages;
import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.OpenFileAction;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class OpenActionProvider
extends CommonActionProvider {
    private OpenFileAction openAction;
    private IMenuManager openWithSubMenu;
    private IWorkbenchPage page;
    private boolean usedInView;

    public void init(ICommonActionExtensionSite site) {
        super.init(site);
        this.usedInView = site.getViewSite() instanceof ICommonViewerWorkbenchSite;
        if (!this.usedInView) {
            return;
        }
        this.page = ((ICommonViewerWorkbenchSite)site.getViewSite()).getPage();
        this.openAction = new OpenFileAction(this.page);
        this.openWithSubMenu = new MenuManager(Messages.OPEN_WITH);
    }

    public void fillActionBars(IActionBars actionBars) {
        if (!this.usedInView) {
            return;
        }
        actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        if (!this.usedInView) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        if (selection.getFirstElement() instanceof ComponentNode) {
            menu.insertAfter("group.open", (IAction)this.openAction);
            if (selection.size() == 1) {
                this.openWithSubMenu.removeAll();
                this.openWithSubMenu.add((IContributionItem)new OpenWithMenu(this.page, (IAdaptable)this.openAction.getStructuredSelection().getFirstElement()));
                menu.appendToGroup("group.openWith", (IContributionItem)this.openWithSubMenu);
            }
        }
    }

    public void updateActionBars() {
        if (!this.usedInView) {
            return;
        }
        ArrayList<Object> artifacts = new ArrayList<Object>();
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        for (Object item : selection) {
            if (item instanceof ISCAArtifact) {
                artifacts.add(item);
                continue;
            }
            Object parent = ((ComponentNode)item).getParent();
            if (artifacts.contains(parent)) continue;
            artifacts.add(parent);
        }
        this.openAction.selectionChanged((IStructuredSelection)new StructuredSelection(artifacts));
    }

    public void dispose() {
        if (this.openWithSubMenu != null) {
            this.openWithSubMenu.dispose();
            this.openWithSubMenu = null;
        }
        super.dispose();
    }
}

