/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.navigator.action;

import com.ibm.ccl.sca.core.model.ISCAArtifact;
import com.ibm.ccl.sca.internal.ui.navigator.action.CopyAction;
import com.ibm.ccl.sca.internal.ui.navigator.action.CutAction;
import com.ibm.ccl.sca.internal.ui.navigator.action.DeleteAction;
import com.ibm.ccl.sca.internal.ui.navigator.action.PasteAction;
import com.ibm.ccl.sca.internal.ui.navigator.node.NamespaceNode;
import com.ibm.ccl.sca.ui.navigator.ISCANode;
import com.ibm.ccl.sca.ui.plugin.SCAToolsUIPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class EditActionProvider
extends CommonActionProvider
implements IWindowListener {
    private CutAction cutAction;
    private CopyAction copyAction;
    private PasteAction pasteAction;
    private DeleteAction deleteAction;
    private boolean usedInView;
    private boolean allArtifacts;
    private boolean allNamespaceNodes;
    private boolean allAllowPasteNodes;
    private Clipboard clipboard;

    public void init(ICommonActionExtensionSite site) {
        super.init(site);
        this.usedInView = site.getViewSite() instanceof ICommonViewerWorkbenchSite;
        if (!this.usedInView) {
            return;
        }
        this.clipboard = new Clipboard(site.getStructuredViewer().getControl().getDisplay());
        this.makeActions(site.getViewSite().getShell());
        SCAToolsUIPlugin.getDefault().getWorkbench().addWindowListener((IWindowListener)this);
    }

    private void makeActions(Shell shell) {
        ISharedImages images = SCAToolsUIPlugin.getDefault().getWorkbench().getSharedImages();
        this.cutAction = new CutAction();
        this.pasteAction = new PasteAction(this.clipboard, shell);
        this.pasteAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_PASTE"));
        this.pasteAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.pasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.copyAction = new CopyAction(this.clipboard, this.pasteAction);
        this.copyAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_COPY"));
        this.copyAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.deleteAction = new DeleteAction(shell);
        this.deleteAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE"));
        this.deleteAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
    }

    public void fillActionBars(IActionBars actionBars) {
        if (!this.usedInView) {
            return;
        }
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutAction);
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        if (!this.usedInView) {
            return;
        }
        if (this.allArtifacts) {
            menu.appendToGroup("group.edit", (IAction)this.copyAction);
            menu.appendToGroup("group.edit", (IAction)this.pasteAction);
            menu.appendToGroup("group.edit", (IAction)this.deleteAction);
        } else if (this.allNamespaceNodes) {
            menu.appendToGroup("group.edit", (IAction)this.deleteAction);
        } else if (this.allAllowPasteNodes) {
            menu.appendToGroup("group.edit", (IAction)this.pasteAction);
        }
    }

    public void updateActionBars() {
        if (!this.usedInView) {
            return;
        }
        this.allArtifacts = true;
        this.allNamespaceNodes = true;
        this.allAllowPasteNodes = true;
        ArrayList<Object> artifacts = new ArrayList<Object>();
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        for (Object item : selection) {
            this.allArtifacts &= item instanceof ISCAArtifact;
            boolean isNamespaceNode = item instanceof NamespaceNode;
            this.allNamespaceNodes &= isNamespaceNode;
            this.allAllowPasteNodes &= item instanceof ISCANode && ((ISCANode)item).allowPaste();
            if (!isNamespaceNode) continue;
            Object[] children = ((NamespaceNode)item).getChildren();
            artifacts.addAll(Arrays.asList(children));
        }
        if (this.allArtifacts) {
            this.copyAction.selectionChanged(selection);
            this.pasteAction.selectionChanged(selection);
            this.deleteAction.selectionChanged(selection);
        } else if (this.allNamespaceNodes) {
            this.copyAction.selectionChanged((IStructuredSelection)StructuredSelection.EMPTY);
            this.pasteAction.selectionChanged((IStructuredSelection)StructuredSelection.EMPTY);
            this.deleteAction.selectionChanged((IStructuredSelection)new StructuredSelection(artifacts));
        } else if (this.allAllowPasteNodes) {
            this.copyAction.selectionChanged((IStructuredSelection)StructuredSelection.EMPTY);
            this.pasteAction.selectionChanged(selection);
            this.deleteAction.selectionChanged((IStructuredSelection)StructuredSelection.EMPTY);
        } else {
            this.copyAction.selectionChanged((IStructuredSelection)StructuredSelection.EMPTY);
            this.pasteAction.selectionChanged((IStructuredSelection)StructuredSelection.EMPTY);
            this.deleteAction.selectionChanged((IStructuredSelection)StructuredSelection.EMPTY);
        }
    }

    public void windowActivated(IWorkbenchWindow window) {
        this.pasteAction.selectionChanged(this.pasteAction.getStructuredSelection());
    }

    public void windowClosed(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowOpened(IWorkbenchWindow window) {
    }

    public void dispose() {
        if (this.clipboard != null) {
            SCAToolsUIPlugin.getDefault().getWorkbench().removeWindowListener((IWindowListener)this);
            this.clipboard.dispose();
        }
        super.dispose();
    }
}

