/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.navigator;

import com.ibm.ccl.sca.core.util.StatusUtil;
import com.ibm.ccl.sca.ui.navigator.IPasteAssistant;
import com.ibm.ccl.sca.ui.navigator.SCABaseContentProvider;
import com.ibm.ccl.sca.ui.plugin.SCAToolsUIPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ILabelProvider;

public class SCANodeRegistry {
    private static final String NODE_EXT_ID = "com.ibm.ccl.sca.ui.scaNode";
    private static SCANodeRegistry instance = null;
    private IConfigurationElement[] configs = null;
    private List<ILabelProvider> labelProviders = null;
    private List<IPasteAssistant> pasteAssistants = null;

    public static synchronized SCANodeRegistry getInstance() {
        if (instance == null) {
            instance = new SCANodeRegistry();
        }
        return instance;
    }

    private SCANodeRegistry() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        this.configs = extensionRegistry.getConfigurationElementsFor(NODE_EXT_ID);
        this.labelProviders = this.newList("labelProvider");
        this.pasteAssistants = this.newList("pasteAssistant");
    }

    private <T> T createExecutableExtension(IConfigurationElement config, String attribute) {
        try {
            return (T)config.createExecutableExtension(attribute);
        }
        catch (ClassCastException e) {
            IStatus status = StatusUtil.errorStatus((Throwable)e);
            SCAToolsUIPlugin.getDefault().getLog().log(status);
        }
        catch (CoreException e) {
            SCAToolsUIPlugin.getDefault().getLog().log(e.getStatus());
        }
        return null;
    }

    private <T> List<T> newList(String name) {
        ArrayList<T> list = new ArrayList<T>();
        IConfigurationElement[] iConfigurationElementArray = this.configs;
        int n = this.configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            T t = this.createExecutableExtension(config, name);
            if (t != null) {
                list.add(t);
            }
            ++n2;
        }
        return list;
    }

    public List<SCABaseContentProvider> getContentProviders() {
        return this.newList("contentProvider");
    }

    public List<ILabelProvider> getLabelProviders() {
        return this.labelProviders;
    }

    public List<IPasteAssistant> getPasteAssistants() {
        return this.pasteAssistants;
    }
}

