/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.datatransfer.wizard;

import com.ibm.ccl.sca.core.model.ISCAProject;
import com.ibm.ccl.sca.core.model.SCAModelManager;
import com.ibm.ccl.sca.core.model.SCAModelUtil;
import com.ibm.ccl.sca.core.tracing.SCATrace;
import com.ibm.ccl.sca.core.util.Logger;
import com.ibm.ccl.sca.internal.core.datatransfer.ArchiveFileLeveledStructureProvider;
import com.ibm.ccl.sca.internal.core.datatransfer.IImportDataStructureProvider;
import com.ibm.ccl.sca.internal.ui.common.controls.AbstractSelectionListener;
import com.ibm.ccl.sca.internal.ui.common.controls.CompositeSelectionControlFactory;
import com.ibm.ccl.sca.internal.ui.common.controls.ICompositeSelectionControl;
import com.ibm.ccl.sca.internal.ui.common.controls.IPackButtonAction;
import com.ibm.ccl.sca.internal.ui.datatransfer.operations.ArchiveFileActions;
import com.ibm.ccl.sca.internal.ui.datatransfer.operations.ImportOperation;
import com.ibm.ccl.sca.internal.ui.datatransfer.wizard.MinimizedFileElement;
import com.ibm.ccl.sca.internal.ui.navigator.node.NamespaceNode;
import com.ibm.ccl.sca.internal.ui.preferences.UIPreferences;
import com.ibm.ccl.sca.tuscany.TuscanyModelHelper;
import com.ibm.ccl.sca.ui.messages.Messages;
import com.ibm.ccl.sca.ui.plugin.SCAToolsUIPlugin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.dialogs.ISelectionValidator;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.WizardResourceImportPage;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class ArchiveFileImportPage1
extends WizardResourceImportPage {
    private String INFOPOP_SCA_IMPORT_WIZARD = "SCA_IMPORT_WIZARD";
    private String initialSourceArchiveFieldValue;
    private ISCAProject[] currentAvailableSCAProjects;
    private IProject currentImportIntoProject;
    private IPath containerPath;
    private ResourceUtil resourceUtil;
    private UIPreferences scaUIPreferences;
    private IStructuredSelection initialSelection;
    private IResource currentResourceSelection;
    private ArchiveFileLeveledStructureProvider archiveCurrentProvider;
    private static final String[] FILE_IMPORT_MASK = new String[]{"*.jar;*.zip", "*.*"};
    private static final String STORE_SOURCE_NAMES_PREFERENCE = "ArchiveFileImportPage1.STORE_SOURCE_NAMES_PREFERENCE";
    protected ArrayList<MinimizedFileElement> allFileSystemElements = new ArrayList();
    protected List<Object> selectedTypes = new ArrayList<Object>();
    protected Text importIntoProjectNameField;
    protected Button importIntoFolderBrowseButton;
    protected Combo sourceArchiveNameField;
    protected Button overwriteExistingFilesCheckbox;
    protected Button importCompositeDiagramFilesCheckbox;
    protected Button sourceArchiveBrowseButton;
    protected ICompositeSelectionControl compositeSelection;
    protected Composite sourceArchiveGroup;
    protected Link preferencePageLink;
    private static final String PREFERENCE_PAGE_ID = "com.ibm.ccl.sca.internal.ui.preferences.importExportPreferencePage";
    private Object[] currentSelections;
    private HashMap<String, Integer> duplicatesMap = new HashMap();
    private ZipFile sourceFileHandle_;

    public ArchiveFileImportPage1(IWorkbench workbench, IStructuredSelection selection) {
        this("archiveFileImportPage1", workbench, selection);
        this.setTitle(Messages.SCA_ARCHIVE_EXPORT_TITLE);
        this.setDescription(Messages.SCA_ARCHIVE_IMPORT_DESCRIPTION_TEXT);
        this.initialSelection = selection;
    }

    protected ArchiveFileImportPage1(String pageName, IWorkbench workbench, IStructuredSelection selection) {
        super(pageName, selection);
        this.scaUIPreferences = this.getUIPreferences();
        this.cacheAllAvailableSCAProjects();
    }

    public UIPreferences getUIPreferences() {
        return new UIPreferences();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.ccl.sca.ui." + this.INFOPOP_SCA_IMPORT_WIZARD);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setSize(composite.computeSize(-1, -1));
        composite.setFont(parent.getFont());
        this.createSourceGroup(composite);
        this.createIntoProjectGroup(composite);
        this.createOptionsGroup(composite);
        this.restoreWidgetValues();
        this.updateWidgetEnablements();
        this.setPageComplete(false);
        this.setErrorMessage(null);
        this.setControl((Control)composite);
        this.sourceArchiveGroup.setFocus();
    }

    protected void createSourceGroup(Composite parent) {
        this.createSourceArchiveGroup(parent);
        this.createCompositesSelectionGroup(parent);
        this.createSelectionButtonsGroup(parent);
    }

    protected void createSourceArchiveGroup(Composite parent) {
        this.sourceArchiveGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.sourceArchiveGroup.setLayout((Layout)layout);
        this.sourceArchiveGroup.setFont(parent.getFont());
        this.sourceArchiveGroup.setLayoutData((Object)new GridData(768));
        Label groupLabel = new Label(this.sourceArchiveGroup, 0);
        groupLabel.setText(Messages.SCA_IMPORT_FROM_ARCHIVE_LABEL_TEXT);
        groupLabel.setFont(parent.getFont());
        this.sourceArchiveNameField = new Combo(this.sourceArchiveGroup, 2052);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.sourceArchiveNameField.setLayoutData((Object)data);
        this.sourceArchiveNameField.setFont(parent.getFont());
        this.sourceArchiveNameField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArchiveFileImportPage1.this.updateFromSourceField();
            }
        });
        this.sourceArchiveNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ArchiveFileImportPage1.this.handleArchiveNameFieldModified();
            }
        });
        this.sourceArchiveBrowseButton = new Button(this.sourceArchiveGroup, 8);
        this.sourceArchiveBrowseButton.setText(Messages.SCA_BROWSE_BUTTON_TEXT);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArchiveFileImportPage1.this.handleArchiveSourceBrowseButtonPressed();
            }
        };
        this.sourceArchiveBrowseButton.addSelectionListener((SelectionListener)listener);
        this.sourceArchiveBrowseButton.setLayoutData((Object)new GridData(256));
        this.sourceArchiveBrowseButton.setFont(parent.getFont());
        this.setButtonLayoutData(this.sourceArchiveBrowseButton);
    }

    protected void createCompositesSelectionGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        composite.setSize(composite.computeSize(-1, -1));
        composite.setFont(parent.getFont());
        this.compositeSelection = CompositeSelectionControlFactory.createCompositeSelectionControlAsCheckedTree(composite);
        this.compositeSelection.setTreeContentProvider(this.getFileProvider());
        this.compositeSelection.setTreeLabelProvider((IBaseLabelProvider)new DecoratorLabelProvider());
        this.compositeSelection.setSelectionListener(new ExportTreeSelectionListener());
        this.compositeSelection.setRootObject(null);
        this.compositeSelection.setSearchScope(ICompositeSelectionControl.SCOPE.HIDE_ALL_SCOPE, true);
        this.compositeSelection.initialize();
        ICheckStateListener listener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ArchiveFileImportPage1.this.updateWidgetEnablements();
                if (ArchiveFileImportPage1.this.compositeSelection.isNothingSelected()) {
                    ArchiveFileImportPage1.this.setErrorMessage(Messages.SCA_IMPORT_WIZARD_NO_COMPOSITES_CHECKED_MESSAGE);
                    ArchiveFileImportPage1.this.setPageComplete(false);
                } else if (ArchiveFileImportPage1.this.importIntoProjectNameField == null || ArchiveFileImportPage1.this.importIntoProjectNameField.getText().equals("") || !ArchiveFileImportPage1.this.isImportProjectValidSCA()) {
                    ArchiveFileImportPage1.this.setErrorMessage(Messages.SCA_WORKSPACE_PROJECT_TEXT_ENTRY_ERROR_MESSAGE);
                    ArchiveFileImportPage1.this.setPageComplete(false);
                } else {
                    ArchiveFileImportPage1.this.setErrorMessage(null);
                }
            }
        };
        this.compositeSelection.addListenerObject(listener);
    }

    protected final void createSelectionButtonsGroup(Composite parent) {
        this.compositeSelection.packButtons(new IPackButtonAction(){

            @Override
            public void pack(Button b) {
                ArchiveFileImportPage1.this.setButtonLayoutData(b);
            }
        });
        this.compositeSelection.addSelectionListener2SelectAll(new AbstractSelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ArchiveFileImportPage1.this.updateWidgetEnablements();
            }
        });
        this.compositeSelection.addSelectionListener2DeselectAll(new AbstractSelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ArchiveFileImportPage1.this.setErrorMessage(Messages.SCA_IMPORT_WIZARD_NO_COMPOSITES_CHECKED_MESSAGE);
                ArchiveFileImportPage1.this.updateWidgetEnablements();
            }
        });
        this.enableSelectButtonGroup(false);
    }

    protected void createIntoProjectGroup(Composite parent) {
        Composite containerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        containerGroup.setLayout((Layout)layout);
        containerGroup.setLayoutData((Object)new GridData(768));
        containerGroup.setFont(parent.getFont());
        Label resourcesLabel = new Label(containerGroup, 0);
        resourcesLabel.setText(Messages.SCA_IMPORT_INTO_FOLDER);
        resourcesLabel.setFont(parent.getFont());
        this.importIntoProjectNameField = new Text(containerGroup, 2052);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.importIntoProjectNameField.setLayoutData((Object)data);
        this.importIntoProjectNameField.setFont(parent.getFont());
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ArchiveFileImportPage1.this.handleProjectNameManualEntry();
            }
        };
        this.importIntoProjectNameField.addModifyListener(modifyListener);
        if (this.initialSelection != null && this.initialSelection.getFirstElement() instanceof IProject) {
            IProject selectedProject;
            this.currentImportIntoProject = selectedProject = (IProject)this.initialSelection.getFirstElement();
            if (this.currentAvailableSCAProjects != null && this.currentAvailableSCAProjects.length != 0) {
                ISCAProject[] iSCAProjectArray = this.currentAvailableSCAProjects;
                int n = this.currentAvailableSCAProjects.length;
                int n2 = 0;
                while (n2 < n) {
                    ISCAProject scaProject = iSCAProjectArray[n2];
                    IProject project = scaProject.getProject();
                    if (project.getFullPath().equals((Object)selectedProject.getFullPath())) {
                        this.currentImportIntoProject = scaProject.getProject();
                        this.containerPath = project.getFullPath();
                        this.setErrorMessage(null);
                        this.importIntoProjectNameField.setText(this.containerPath.makeRelative().toString());
                        break;
                    }
                    ++n2;
                }
            }
        }
        this.importIntoFolderBrowseButton = new Button(containerGroup, 8);
        this.importIntoFolderBrowseButton.setText(Messages.SCA_BROWSE_BUTTON_TEXT);
        this.importIntoFolderBrowseButton.setLayoutData((Object)new GridData(256));
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArchiveFileImportPage1.this.handleContainerBrowseButtonPressed();
            }
        };
        this.importIntoFolderBrowseButton.addSelectionListener((SelectionListener)listener);
        this.importIntoFolderBrowseButton.setFont(parent.getFont());
        this.setButtonLayoutData(this.importIntoFolderBrowseButton);
        this.initialPopulateArchiveLocationField();
    }

    protected void createOptionsGroup(Composite parent) {
        this.overwriteExistingFilesCheckbox = new Button(parent, 32);
        this.overwriteExistingFilesCheckbox.setText(Messages.SCA_OVERWRITE_EXISTING_RESOURCES_WITHOUT_WARNING_LABEL_TEXT);
        this.overwriteExistingFilesCheckbox.setFont(parent.getFont());
        this.overwriteExistingFilesCheckbox.setSelection(this.scaUIPreferences.getOverwriteExistingResourcesWarningPref());
        this.importCompositeDiagramFilesCheckbox = new Button(parent, 32);
        this.importCompositeDiagramFilesCheckbox.setText(Messages.SCA_IMPORT_COMPOSITE_FILES_MESSAGE);
        this.importCompositeDiagramFilesCheckbox.setFont(parent.getFont());
        this.importCompositeDiagramFilesCheckbox.setSelection(this.scaUIPreferences.getImportDiagramFilesPref());
        this.preferencePageLink = new Link(parent, 0);
        this.preferencePageLink.setText(Messages.SCA_IMPORT_ARCHIVE_WIZARD_PREF_PAGE_LINK);
        this.preferencePageLink.setEnabled(true);
        this.preferencePageLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArchiveFileImportPage1.this.openImportExportPreferencePage();
            }
        });
    }

    private void openImportExportPreferencePage() {
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)PREFERENCE_PAGE_ID, (String[])new String[]{PREFERENCE_PAGE_ID}, null);
        dialog.open();
    }

    public boolean finish() {
        if (!this.ensureSourceIsValid()) {
            return false;
        }
        this.saveWidgetValues();
        boolean importCompositesSuccess = false;
        boolean importBinariesSuccess = false;
        boolean importSourcesSuccess = false;
        boolean importOtherSuccess = false;
        boolean importDiagramFilesSuccess = false;
        IPath projectPath = this.containerPath;
        IProject project = this.currentImportIntoProject;
        IPath binariesPath = ImportOperation.getJavaBinariesPath((IResource)project);
        if (binariesPath == null || binariesPath.isEmpty()) {
            binariesPath = projectPath;
        }
        this.initializeZipFileSystem();
        Iterator<Object> selectedResources = this.getAllFileSystemJavaBinaryFileElements().iterator();
        ArrayList<Object> fileSystemObjects = new ArrayList<Object>();
        while (selectedResources.hasNext()) {
            fileSystemObjects.add(((FileSystemElement)selectedResources.next()).getFileSystemObject());
        }
        importBinariesSuccess = fileSystemObjects != null && fileSystemObjects.size() > 0 ? this.importResources(fileSystemObjects, binariesPath) : true;
        IPath sourcePath = ImportOperation.getJavaSourcesPathSegment((IResource)project);
        if (sourcePath == null || sourcePath.isEmpty()) {
            sourcePath = projectPath;
        }
        selectedResources = this.getAllFileSystemJavaSourceFileElements().iterator();
        fileSystemObjects = new ArrayList();
        while (selectedResources.hasNext()) {
            fileSystemObjects.add(((FileSystemElement)selectedResources.next()).getFileSystemObject());
        }
        importSourcesSuccess = fileSystemObjects != null && fileSystemObjects.size() > 0 ? this.importResources(fileSystemObjects, sourcePath) : true;
        selectedResources = this.getAllOtherFileSystemFileElements().iterator();
        fileSystemObjects = new ArrayList();
        while (selectedResources.hasNext()) {
            fileSystemObjects.add(((FileSystemElement)selectedResources.next()).getFileSystemObject());
        }
        importOtherSuccess = fileSystemObjects != null && fileSystemObjects.size() > 0 ? this.importResources(fileSystemObjects, this.containerPath) : true;
        selectedResources = this.getCheckedComposites().iterator();
        fileSystemObjects = new ArrayList();
        while (selectedResources.hasNext()) {
            Object object = selectedResources.next();
            if (!(object instanceof FileSystemElement)) continue;
            fileSystemObjects.add(((FileSystemElement)object).getFileSystemObject());
        }
        if (fileSystemObjects != null && fileSystemObjects.size() > 0) {
            importCompositesSuccess = this.importResources(fileSystemObjects, this.containerPath);
        }
        if (this.importCompositeDiagramFilesCheckbox.getSelection()) {
            selectedResources = this.getAllFileSystemCompositesDiagramFileElements().iterator();
            fileSystemObjects = new ArrayList();
            while (selectedResources.hasNext()) {
                fileSystemObjects.add(((FileSystemElement)selectedResources.next()).getFileSystemObject());
            }
            importDiagramFilesSuccess = fileSystemObjects != null && fileSystemObjects.size() > 0 ? this.importResources(fileSystemObjects, this.containerPath) : true;
        } else {
            importDiagramFilesSuccess = true;
        }
        ArchiveFileActions.clearCache(this.getContainer().getShell());
        if (this.sourceFileHandle_ != null) {
            try {
                this.sourceFileHandle_.close();
            }
            catch (IOException e) {
                SCATrace.trace((Plugin)SCAToolsUIPlugin.getDefault(), (int)0, (Throwable)e);
            }
        }
        Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
        if (importCompositesSuccess && importBinariesSuccess && importSourcesSuccess && importOtherSuccess && importDiagramFilesSuccess) {
            if (this.resourceUtil != null) {
                this.resourceUtil.shutdown();
                this.resourceUtil = null;
            }
            return true;
        }
        MessageDialog.openInformation((Shell)this.getContainer().getShell(), (String)Messages.SCA_INFORMATION_MESSAGE, (String)Messages.SCA_NO_RESOURCES_SELECTED_FOR_IMPORT_ERROR_MESSAGE);
        return false;
    }

    protected void setArchiveFileNameValue(String value) {
        this.sourceArchiveNameField.setText(value);
    }

    protected void enableSelectButtonGroup(boolean enabled) {
        this.compositeSelection.enableExpansionButtons(enabled);
        this.compositeSelection.enableSelectionButtons(enabled);
    }

    protected void updateFromSourceField() {
        this.setSourceName(this.sourceArchiveNameField.getText());
        this.updateWidgetEnablements();
    }

    public void displayRootLevelCompositesFromArchive() {
        this.compositeSelection.updateRootObject(this.getAllFileSystemCompositesFileElements());
        this.enableSelectButtonGroup(true);
        this.setPageComplete(false);
    }

    protected String getArchiveFilePathToImport() {
        FileDialog dialog = new FileDialog(this.sourceArchiveNameField.getShell(), 4096);
        dialog.setFilterExtensions(FILE_IMPORT_MASK);
        dialog.setText(Messages.SCA_IMPORT_FROM_ARCHIVE_FILE_DIALOG_TITLE);
        String currentSourceString = this.sourceArchiveNameField.getText();
        int lastSeparatorIndex = currentSourceString.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
            dialog.setFilterPath(currentSourceString.substring(0, lastSeparatorIndex));
        }
        return dialog.open();
    }

    protected ITreeContentProvider getFolderProvider() {
        return null;
    }

    protected ITreeContentProvider getFileProvider() {
        return new WorkbenchContentProvider(){
            private Map<String, NamespaceNode> namespaceNodes = new Hashtable<String, NamespaceNode>();

            private QName readQName(Object object) {
                QName qName;
                if (!$assertionsDisabled && ArchiveFileImportPage1.this.archiveCurrentProvider == null) {
                    throw new AssertionError();
                }
                InputStream stream = ArchiveFileImportPage1.this.archiveCurrentProvider.getContents(object);
                if (stream == null) {
                    return new QName("");
                }
                try {
                    qName = TuscanyModelHelper.getInstance().peekQName(stream);
                }
                catch (Throwable throwable) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
                return qName;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput instanceof List) {
                    ArchiveFileImportPage1.this.duplicatesMap.clear();
                    this.namespaceNodes.clear();
                    for (Object item : (List)newInput) {
                        MinimizedFileElement element;
                        if (!(item instanceof MinimizedFileElement) || !(element = (MinimizedFileElement)((Object)item)).getFileNameExtension().equalsIgnoreCase("composite")) continue;
                        QName qName = this.readQName(element.getFileSystemObject());
                        element.setQName(qName);
                        String namespace = qName.getNamespaceURI();
                        NamespaceNode namespaceNode = this.namespaceNodes.get(namespace);
                        if (namespaceNode == null) {
                            namespaceNode = new NamespaceNode(null, namespace);
                            this.namespaceNodes.put(namespace, namespaceNode);
                        }
                        String key = qName.toString();
                        Integer integer = (Integer)ArchiveFileImportPage1.this.duplicatesMap.get(key);
                        integer = integer == null ? new Integer(1) : new Integer(integer + 1);
                        ArchiveFileImportPage1.this.duplicatesMap.put(key, integer);
                        namespaceNode.addChild((Object)element);
                    }
                }
            }

            public Object getParent(Object element) {
                QName name;
                if (element instanceof MinimizedFileElement && (name = ((MinimizedFileElement)((Object)element)).getQName()) != null) {
                    return this.namespaceNodes.get(name.getNamespaceURI());
                }
                return super.getParent(element);
            }

            public Object[] getChildren(Object o) {
                if (o instanceof ArrayList) {
                    return this.namespaceNodes.values().toArray();
                }
                if (o instanceof NamespaceNode) {
                    return ((NamespaceNode)o).getChildren();
                }
                return new Object[0];
            }
        };
    }

    protected void handleArchiveSourceBrowseButtonPressed() {
        String selectedFile = this.getArchiveFilePathToImport();
        if (selectedFile != null && !selectedFile.equals(this.sourceArchiveNameField.getText()) && this.validateSourceFile(selectedFile)) {
            this.setArchiveFileNameValue(selectedFile);
        }
    }

    protected void handleArchiveNameFieldModified() {
        String archiveFilePath = this.sourceArchiveNameField.getText();
        if (archiveFilePath != null) {
            if (this.validateSourceFileManualEntry(archiveFilePath)) {
                this.initializeZipFileSystem();
                if (this.getAllFileSystemCompositesFileElements().isEmpty()) {
                    this.setMessage(Messages.SCA_IMPORT_ARCHIVE_NO_COMPOSITES_IN_ARCHIVE);
                    this.compositeSelection.updateRootObject(null);
                    return;
                }
                this.displayRootLevelCompositesFromArchive();
                this.allFileSystemElements.clear();
                this.setErrorMessage(null);
                this.setMessage(Messages.SCA_IMPORT_ARCHIVE_SELECT_COMPOSITES_MESSAGE);
                this.enableSelectButtonGroup(true);
                if (this.compositeSelection.getSelectedComposites().isEmpty()) {
                    this.setErrorMessage(Messages.SCA_IMPORT_WIZARD_NO_COMPOSITES_CHECKED_MESSAGE);
                    return;
                }
            } else {
                boolean pathOK;
                if (this.allFileSystemElements != null) {
                    this.allFileSystemElements.clear();
                }
                boolean validArchive = this.validateSourceFileSilent(archiveFilePath);
                File file = new File(archiveFilePath);
                boolean bl = pathOK = file.exists() && file.isFile();
                if (pathOK && !validArchive) {
                    this.setErrorMessage(Messages.SCA_SOURCE_FILE_NOT_VALID_ARCHIVE_FILE_MESSAGE);
                } else {
                    this.setErrorMessage(Messages.SCA_SOURCE_ARCHIVE_PATH);
                }
                this.setPageComplete(false);
                this.enableSelectButtonGroup(false);
                this.compositeSelection.updateRootObject(null);
            }
        }
    }

    protected void handleContainerBrowseButtonPressed() {
        IPath folderPath;
        this.containerPath = folderPath = this.getWorkspaceProjectPath();
        if (folderPath != null) {
            this.setErrorMessage(null);
            this.importIntoProjectNameField.setText(folderPath.makeRelative().toString());
        }
    }

    protected final void initialPopulateArchiveLocationField() {
        if (this.initialSourceArchiveFieldValue != null) {
            this.sourceArchiveNameField.setText(this.initialSourceArchiveFieldValue);
        } else if (this.currentResourceSelection != null) {
            this.sourceArchiveNameField.setText(this.currentResourceSelection.getFullPath().makeRelative().toString());
        }
    }

    private void initializeZipFileSystem() {
        MinimizedFileElement element = this.getRootFileSytemElement();
        this.getFileSystemRootFileElements(element);
        this.getFileSystemFolderElements(element);
        this.getAllFileSystemCompositesFileElements();
    }

    protected MinimizedFileElement getRootFileSytemElement() {
        Object[] children;
        MinimizedFileElement fileElement = this.getFileSystemTree();
        AdaptableList adaptableFoldersList = fileElement.getFolders((IImportDataStructureProvider)this.archiveCurrentProvider);
        MinimizedFileElement minimizedFileElement = null;
        if (adaptableFoldersList != null && adaptableFoldersList.size() > 0 && (children = adaptableFoldersList.getChildren())[0] instanceof MinimizedFileElement) {
            minimizedFileElement = (MinimizedFileElement)((Object)children[0]);
        }
        return minimizedFileElement;
    }

    protected void getFileSystemFileElements(MinimizedFileElement fileElement) {
        AdaptableList fileList = fileElement.getFiles((IImportDataStructureProvider)this.archiveCurrentProvider);
        if (fileList != null) {
            Object[] fileElements = fileList.getChildren((Object)fileElement);
            int i = 0;
            while (i < fileElements.length) {
                MinimizedFileElement file = (MinimizedFileElement)((Object)fileElements[i]);
                this.allFileSystemElements.add(file);
                ++i;
            }
        }
    }

    protected void getFileSystemRootFileElements(MinimizedFileElement fileElement) {
        this.getFileSystemFileElements(fileElement);
    }

    protected void getFileSystemFolderElements(MinimizedFileElement fileElement) {
        AdaptableList foldersList = fileElement.getFolders((IImportDataStructureProvider)this.archiveCurrentProvider);
        Object[] folderElements = foldersList.getChildren((Object)fileElement);
        int i = 0;
        while (i < folderElements.length) {
            MinimizedFileElement folder = (MinimizedFileElement)((Object)folderElements[i]);
            if (folder != null) {
                this.getFileSystemFileElements(folder);
            }
            this.getFileSystemFolderElements(folder);
            ++i;
        }
    }

    protected List<MinimizedFileElement> getAllFileSystemCompositesFileElements() {
        ArrayList<MinimizedFileElement> compositesList = new ArrayList<MinimizedFileElement>();
        for (MinimizedFileElement fileElement : this.allFileSystemElements) {
            if (!fileElement.getFileNameExtension().equals("composite")) continue;
            compositesList.add(fileElement);
        }
        return compositesList;
    }

    protected List<MinimizedFileElement> getAllFileSystemCompositesDiagramFileElements() {
        ArrayList<MinimizedFileElement> compositeDiagramsList = new ArrayList<MinimizedFileElement>();
        for (MinimizedFileElement fileElement : this.allFileSystemElements) {
            if (!fileElement.getFileNameExtension().equals("composite_diagram")) continue;
            compositeDiagramsList.add(fileElement);
        }
        return compositeDiagramsList;
    }

    protected List<MinimizedFileElement> getAllFileSystemJavaBinaryFileElements() {
        ArrayList<MinimizedFileElement> javaBinariesList = new ArrayList<MinimizedFileElement>();
        for (MinimizedFileElement fileElement : this.allFileSystemElements) {
            if (!fileElement.getFileNameExtension().equals("properties") && !fileElement.getFileNameExtension().equals("class") && !fileElement.getFileNameExtension().equals("jar")) continue;
            javaBinariesList.add(fileElement);
        }
        return javaBinariesList;
    }

    protected List<MinimizedFileElement> getAllFileSystemJavaSourceFileElements() {
        ArrayList<MinimizedFileElement> javaSourcesList = new ArrayList<MinimizedFileElement>();
        for (MinimizedFileElement fileElement : this.allFileSystemElements) {
            if (!fileElement.getFileNameExtension().equals("properties") && !fileElement.getFileNameExtension().equals("java")) continue;
            javaSourcesList.add(fileElement);
        }
        return javaSourcesList;
    }

    protected List<MinimizedFileElement> getAllOtherFileSystemFileElements() {
        ArrayList<MinimizedFileElement> allOtherFilesList = new ArrayList<MinimizedFileElement>();
        for (MinimizedFileElement fileElement : this.allFileSystemElements) {
            if (fileElement.getFileNameExtension().equals("properties") || fileElement.getFileNameExtension().equals("java") || fileElement.getFileNameExtension().equals("class") || fileElement.getFileNameExtension().equals("composite") || fileElement.getFileNameExtension().equals("composite_diagram") || fileElement.getFileElementName().startsWith(".") || fileElement.getFileSystemObject().toString().startsWith(".")) continue;
            allOtherFilesList.add(fileElement);
        }
        return allOtherFilesList;
    }

    protected boolean isImportProjectValidSCA() {
        if (this.currentAvailableSCAProjects == null || this.currentAvailableSCAProjects.length == 0) {
            return false;
        }
        ISCAProject[] iSCAProjectArray = this.currentAvailableSCAProjects;
        int n = this.currentAvailableSCAProjects.length;
        int n2 = 0;
        while (n2 < n) {
            String importIntoValue;
            ISCAProject scaProject = iSCAProjectArray[n2];
            String projectPath = scaProject.getProject().getName();
            if (projectPath.equals(importIntoValue = this.importIntoProjectNameField.getText())) {
                this.containerPath = scaProject.getProject().getFullPath();
                this.currentImportIntoProject = scaProject.getProject();
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void handleProjectNameManualEntry() {
        if (this.currentAvailableSCAProjects == null || this.currentAvailableSCAProjects.length == 0) {
            this.setErrorMessage(Messages.SCA_WORKSPACE_PROJECT_SELECTION_ERROR_MESSAGE);
            this.setPageComplete(false);
            return;
        }
        String importIntoValue = this.importIntoProjectNameField.getText();
        ISCAProject[] iSCAProjectArray = this.currentAvailableSCAProjects;
        int n = this.currentAvailableSCAProjects.length;
        int n2 = 0;
        while (n2 < n) {
            ISCAProject scaProject = iSCAProjectArray[n2];
            String projectPath = scaProject.getProject().getName();
            if (projectPath.equals(importIntoValue)) {
                this.containerPath = scaProject.getProject().getFullPath();
                this.currentImportIntoProject = scaProject.getProject();
                this.setErrorMessage(null);
                this.setPageComplete(this.determinePageCompletion());
                return;
            }
            ++n2;
        }
        this.containerPath = null;
        this.currentImportIntoProject = null;
        this.setPageComplete(false);
        this.setErrorMessage(Messages.SCA_WORKSPACE_PROJECT_SELECTION_ERROR_MESSAGE);
    }

    public IPath getWorkspaceProjectPath() {
        Object[] dialogFileSelectionObjects;
        Object firstSelectedElement;
        IProject selectedProject = null;
        if (this.initialSelection != null && (firstSelectedElement = this.initialSelection.getFirstElement()) instanceof IProject && SCAModelManager.hasSCAFacet((IProject)((IProject)firstSelectedElement))) {
            selectedProject = (IProject)firstSelectedElement;
        }
        boolean allowNewContainer = false;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getControl().getShell(), selectedProject, allowNewContainer, "");
        dialog.setTitle(Messages.SCA_WORKSPACE_DIALOG_TITLE);
        dialog.setMessage(Messages.SCA_WORKSPACE_DIALOG_TITLE);
        dialog.setValidator(new ISelectionValidator(){

            public String isValid(Object selection) {
                if (selection instanceof IPath) {
                    IPath containerPath = (IPath)selection;
                    if (ArchiveFileImportPage1.this.currentAvailableSCAProjects == null || ArchiveFileImportPage1.this.currentAvailableSCAProjects.length == 0) {
                        return Messages.SCA_WORKSPACE_PROJECT_SELECTION_ERROR_MESSAGE;
                    }
                    ISCAProject[] iSCAProjectArray = ArchiveFileImportPage1.this.currentAvailableSCAProjects;
                    int n = iSCAProjectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ISCAProject scaProject = iSCAProjectArray[n2];
                        IPath projectPath = scaProject.getProject().getFullPath();
                        if (containerPath.toOSString().equals(projectPath.toOSString())) {
                            ArchiveFileImportPage1.this.currentImportIntoProject = scaProject.getProject();
                            return null;
                        }
                        ++n2;
                    }
                }
                return Messages.SCA_WORKSPACE_PROJECT_SELECTION_ERROR_MESSAGE;
            }
        });
        if (dialog.open() == 0 && (dialogFileSelectionObjects = dialog.getResult()) != null && dialogFileSelectionObjects.length >= 0 && dialogFileSelectionObjects[0] instanceof IPath) {
            IPath path = (IPath)dialogFileSelectionObjects[0];
            return path;
        }
        return null;
    }

    protected List<Object> getCheckedComposites() {
        return this.compositeSelection.getSelected();
    }

    protected MinimizedFileElement getFileSystemTree() {
        ArchiveFileLeveledStructureProvider provider;
        if (this.sourceFileHandle_ != null) {
            try {
                this.sourceFileHandle_.close();
            }
            catch (IOException e) {
                SCATrace.trace((Plugin)SCAToolsUIPlugin.getDefault(), (int)0, (Throwable)e);
            }
        }
        this.sourceFileHandle_ = this.getSpecifiedArchiveSourceFile();
        if (this.sourceFileHandle_ == null) {
            this.archiveCurrentProvider = null;
            return null;
        }
        this.archiveCurrentProvider = provider = ArchiveFileActions.getZipStructureProvider(this.sourceFileHandle_, this.getContainer().getShell());
        return this.selectFiles(provider.getRoot(), (IImportDataStructureProvider)provider);
    }

    protected MinimizedFileElement selectFiles(Object rootFileSystemObject, IImportDataStructureProvider structureProvider) {
        MinimizedFileElement[] results = new MinimizedFileElement[]{this.createRootElement(rootFileSystemObject, structureProvider)};
        return results[0];
    }

    protected MinimizedFileElement createRootElement(Object fileSystemObject, IImportDataStructureProvider provider) {
        boolean isContainer = provider.isFolder(fileSystemObject);
        String elementLabel = provider.getLabel(fileSystemObject);
        MinimizedFileElement dummyParent = new MinimizedFileElement("", null, true);
        dummyParent.setPopulated();
        MinimizedFileElement result = new MinimizedFileElement(elementLabel, dummyParent, isContainer);
        result.setFileSystemObject(fileSystemObject);
        result.getFiles(provider);
        return dummyParent;
    }

    protected void setSourceName(String path) {
        if (path.length() > 0) {
            String[] currentItems = this.sourceArchiveNameField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(path)) {
                    selectionIndex = i;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = path;
                this.sourceArchiveNameField.setItems(newItems);
                selectionIndex = oldLength;
            }
            this.sourceArchiveNameField.select(selectionIndex);
        }
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_PREFERENCE);
            if (sourceNames == null) {
                Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
                return;
            }
            int i = 0;
            while (i < sourceNames.length) {
                Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
                this.sourceArchiveNameField.add(sourceNames[i]);
                ++i;
            }
        }
    }

    protected void setSourceArchiveValue(String value) {
        this.sourceArchiveNameField.setText(value);
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_PREFERENCE);
            if (sourceNames == null) {
                Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
                sourceNames = new String[]{};
            }
            sourceNames = this.addToHistory(sourceNames, this.sourceArchiveNameField.getText());
            settings.put(STORE_SOURCE_NAMES_PREFERENCE, sourceNames);
            Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
        }
    }

    protected void updateWidgetEnablements() {
        boolean pageComplete = this.determinePageCompletion();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            this.setErrorMessage(null);
        }
    }

    public boolean determinePageCompletion() {
        if (this.currentAvailableSCAProjects == null || this.currentAvailableSCAProjects.length == 0) {
            return false;
        }
        if (this.currentImportIntoProject == null || !SCAModelManager.hasSCAFacet((IProject)this.currentImportIntoProject)) {
            this.setErrorMessage(Messages.SCA_WORKSPACE_PROJECT_TEXT_ENTRY_ERROR_MESSAGE);
            return false;
        }
        if (this.compositeSelection.isNothingSelected()) {
            this.setErrorMessage(Messages.SCA_NO_RESOURCES_SELECTED_FOR_IMPORT_ERROR_MESSAGE);
            return false;
        }
        return true;
    }

    public boolean cancel() {
        this.clearProviderCache();
        return true;
    }

    protected void clearProviderCache() {
        ArchiveFileActions.clearCache(this.getContainer().getShell());
    }

    protected boolean closeArchiveFile(ZipFile archiveFile) {
        try {
            archiveFile.close();
        }
        catch (IOException iOException) {
            this.displayErrorDialog(NLS.bind((String)Messages.SCA_COULD_NOT_CLOSE_EXPORTED_ARCHIVE_FILE_MESSAGE, (Object)archiveFile.getName()));
            return false;
        }
        return true;
    }

    private boolean validateSourceFile(String fileName) {
        ZipFile archiveFile = this.getSpecifiedArchiveSourceFile(fileName);
        if (archiveFile != null) {
            ArchiveFileActions.closeArchiveFile(archiveFile, this.getContainer().getShell());
            return true;
        }
        return false;
    }

    private boolean validateSourceFileSilent(String fileName) {
        ZipFile archiveFile = this.getSpecifiedArchiveSourceFileSilent(fileName);
        if (archiveFile != null) {
            ArchiveFileActions.closeArchiveFile(archiveFile, this.getContainer().getShell());
            return true;
        }
        return false;
    }

    private ZipFile getSpecifiedArchiveSourceFileSilent(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        try {
            return new ZipFile(fileName);
        }
        catch (ZipException zipException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private boolean validateSourceFileManualEntry(String fileName) {
        ZipFile archiveFile = this.getManuallyEnteredSourceArchive(fileName);
        if (archiveFile != null) {
            ArchiveFileActions.closeArchiveFile(archiveFile, this.getContainer().getShell());
            return true;
        }
        return false;
    }

    private ZipFile getManuallyEnteredSourceArchive(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        try {
            return new ZipFile(fileName);
        }
        catch (ZipException zipException) {
        }
        catch (IOException iOException) {}
        this.sourceArchiveNameField.setFocus();
        return null;
    }

    private boolean ensureZipSourceIsValid() {
        ZipFile specifiedFile = this.getSpecifiedArchiveSourceFile();
        if (specifiedFile == null) {
            return false;
        }
        return ArchiveFileActions.closeArchiveFile(specifiedFile, this.getContainer().getShell());
    }

    protected boolean ensureSourceIsValid() {
        return this.ensureZipSourceIsValid();
    }

    protected ZipFile getSpecifiedArchiveSourceFile() {
        return this.getSpecifiedArchiveSourceFile(this.sourceArchiveNameField.getText());
    }

    private ZipFile getSpecifiedArchiveSourceFile(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        try {
            return new ZipFile(fileName);
        }
        catch (ZipException zipException) {
            this.displayErrorDialog(Messages.SCA_SOURCE_FILE_NOT_VALID_ARCHIVE_FILE_MESSAGE);
        }
        catch (IOException iOException) {
            this.displayErrorDialog(Messages.SCA_ERROR_READING_SOURCE_FILE_MESSAGE);
        }
        this.sourceArchiveNameField.setFocus();
        return null;
    }

    protected boolean importResources(List<Object> fileSystemObjects, IPath targetFolderPath) {
        boolean iSuccessfulImport = false;
        if (this.ensureZipSourceIsValid()) {
            ZipFile archiveFile = this.getSpecifiedArchiveSourceFile();
            Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
            ArchiveFileLeveledStructureProvider structureProvider = ArchiveFileActions.getZipStructureProvider(archiveFile, this.getContainer().getShell());
            Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
            ImportOperation operation = new ImportOperation(targetFolderPath, structureProvider.getRoot(), (IImportDataStructureProvider)structureProvider, (IOverwriteQuery)this, fileSystemObjects);
            Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
            operation.setContext(this.getShell());
            iSuccessfulImport = this.executeImportOperation(operation);
            this.closeArchiveFile(archiveFile);
            Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
        }
        Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
        return iSuccessfulImport;
    }

    protected boolean executeImportOperation(ImportOperation importContributionOperation) {
        this.initializeOperation(importContributionOperation);
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)importContributionOperation);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            this.displayErrorDialog(e.getTargetException());
            return false;
        }
        IStatus status = importContributionOperation.getStatus();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.SCA_UNSPECIFIED_IMPORTING_ERRORS_MESSAGE, null, (IStatus)status);
            return false;
        }
        return true;
    }

    protected void initializeOperation(ImportOperation importOperation) {
        Logger.println((int)2, (Object)((Object)this), (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
        importOperation.setOverwriteResources(this.overwriteExistingFilesCheckbox.getSelection());
    }

    protected void cacheAllAvailableSCAProjects() {
        try {
            List currentSCAProjectsList = SCAModelUtil.getSCAProjectsList();
            this.currentAvailableSCAProjects = SCAModelUtil.convertSCAProjectsListToArray((List)currentSCAProjectsList);
        }
        catch (CoreException coreException) {
            Logger.println((int)0, (Object)((Object)this), (String)"cacheAllSCAProjects()", (String)"Error occuring trying to get the current list of SCA Projects");
        }
    }

    private class DecoratorLabelProvider
    extends StyledCellLabelProvider
    implements IColorProvider,
    IFontProvider,
    DelegatingStyledCellLabelProvider.IStyledLabelProvider,
    ILabelProvider {
        private String pathSeparator = "-";
        private IPropertyListener editorRegistryListener = new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                if (propId == 1) {
                    DecoratorLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)DecoratorLabelProvider.this));
                }
            }
        };

        private DecoratorLabelProvider() {
            PlatformUI.getWorkbench().getEditorRegistry().addPropertyListener(this.editorRegistryListener);
        }

        private String decorateText(String input, Object element) {
            if (element instanceof MinimizedFileElement) {
                MinimizedFileElement file = (MinimizedFileElement)((Object)element);
                return String.valueOf(input) + " " + this.pathSeparator + " " + file.getFilePathString();
            }
            return input;
        }

        private ImageDescriptor decorateImage(ImageDescriptor input, Object element) {
            return input;
        }

        public final Image getImage(Object element) {
            Image image;
            IWorkbenchAdapter adapter = this.getAdapter(element);
            if (adapter == null) {
                return null;
            }
            ImageDescriptor descriptor = adapter.getImageDescriptor(element);
            if (descriptor == null) {
                return null;
            }
            descriptor = this.decorateImage(descriptor, element);
            if (ArchiveFileImportPage1.this.resourceUtil == null) {
                ArchiveFileImportPage1.this.resourceUtil = new ResourceUtil();
            }
            if ((image = (Image)ArchiveFileImportPage1.this.resourceUtil.getImageTable().get(descriptor)) == null) {
                image = descriptor.createImage();
                ArchiveFileImportPage1.this.resourceUtil.getImageTable().put(descriptor, image);
            }
            return image;
        }

        private final IWorkbenchAdapter getAdapter(Object o) {
            return (IWorkbenchAdapter)this.getAdapter(o, IWorkbenchAdapter.class);
        }

        public void update(ViewerCell cell) {
            Object theElement = cell.getElement();
            StyledString styledString = this.getStyledText(theElement);
            cell.setText(styledString.getString());
            cell.setStyleRanges(styledString.getStyleRanges());
            cell.setImage(this.getImage(theElement));
            cell.setFont(this.getFont(theElement));
            cell.setForeground(this.getForeground(theElement));
            cell.setBackground(this.getBackground(theElement));
            super.update(cell);
        }

        public StyledString getStyledText(Object element) {
            StyledString styledString;
            String string = this.getText(element);
            if (this.isDuplicate(element) || this.isSelected(element)) {
                string = this.decorateText(string, element);
                styledString = new StyledString(string);
                int i = string.indexOf(this.pathSeparator);
                if (i != -1) {
                    styledString.setStyle(i, string.length() - i, StyledString.QUALIFIER_STYLER);
                }
            } else {
                styledString = new StyledString(string);
            }
            return styledString;
        }

        private boolean isSelected(Object element) {
            if (ArchiveFileImportPage1.this.currentSelections != null && element != null) {
                int index = 0;
                while (index < ArchiveFileImportPage1.this.currentSelections.length) {
                    if (element.equals(ArchiveFileImportPage1.this.currentSelections[index])) {
                        return true;
                    }
                    ++index;
                }
            }
            return false;
        }

        private boolean isDuplicate(Object element) {
            MinimizedFileElement theElement;
            if (element instanceof MinimizedFileElement && (theElement = (MinimizedFileElement)((Object)element)).getFileNameExtension().equalsIgnoreCase("composite")) {
                assert (ArchiveFileImportPage1.this.archiveCurrentProvider != null);
                InputStream stream = ArchiveFileImportPage1.this.archiveCurrentProvider.getContents(theElement.getFileSystemObject());
                QName qName = null;
                if (stream == null) {
                    return false;
                }
                try {
                    qName = TuscanyModelHelper.getInstance().peekQName(stream);
                }
                catch (Throwable throwable) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
                if (qName != null) {
                    String key = qName.toString();
                    Integer integer = (Integer)ArchiveFileImportPage1.this.duplicatesMap.get(key);
                    if (integer > 1) {
                        return true;
                    }
                }
            }
            return false;
        }

        public final String getText(Object treeItem) {
            String label = null;
            if (treeItem instanceof NamespaceNode) {
                label = ((NamespaceNode)treeItem).getText();
            } else if (treeItem instanceof MinimizedFileElement) {
                MinimizedFileElement element = (MinimizedFileElement)((Object)treeItem);
                QName name = element.getQName();
                if (name != null) {
                    label = URI.decode((String)name.getLocalPart());
                    if (label.length() == 0) {
                        label = Messages.LABEL_UNNAMED;
                    }
                } else {
                    label = element.getFileElementName();
                }
            } else {
                label = treeItem.toString();
            }
            return label;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Font getFont(Object element) {
            return null;
        }

        public Object getAdapter(Object sourceObject, Class<IWorkbenchAdapter> adapterType) {
            Object result;
            IAdaptable adaptable;
            Object result2;
            Assert.isNotNull(adapterType);
            if (sourceObject == null) {
                return null;
            }
            if (adapterType.isInstance(sourceObject)) {
                return sourceObject;
            }
            if (sourceObject instanceof IAdaptable && (result2 = (adaptable = (IAdaptable)sourceObject).getAdapter(adapterType)) != null) {
                Assert.isTrue((boolean)adapterType.isInstance(result2));
                return result2;
            }
            if (!(sourceObject instanceof PlatformObject) && (result = Platform.getAdapterManager().getAdapter(sourceObject, adapterType)) != null) {
                return result;
            }
            return null;
        }
    }

    private class ExportTreeSelectionListener
    implements ISelectionChangedListener {
        private ExportTreeSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object[] oldSelections = ArchiveFileImportPage1.this.currentSelections;
            if (event.getSelection() instanceof StructuredSelection) {
                ArchiveFileImportPage1.this.currentSelections = ((StructuredSelection)event.getSelection()).toArray();
            }
            if (oldSelections != null && oldSelections.length > 0) {
                ArchiveFileImportPage1.this.compositeSelection.updateTreeViewer(oldSelections, null);
            }
            if (ArchiveFileImportPage1.this.currentSelections != null && ArchiveFileImportPage1.this.currentSelections.length > 0) {
                ArchiveFileImportPage1.this.compositeSelection.updateTreeViewer(ArchiveFileImportPage1.this.currentSelections, null);
            }
        }
    }

    private class ResourceUtil {
        private Map<Object, Object> imageTable = new Hashtable<Object, Object>(40);

        private ResourceUtil() {
        }

        private final void shutdown() {
            if (this.imageTable != null) {
                Iterator<Object> i = this.imageTable.values().iterator();
                while (i.hasNext()) {
                    ((Image)i.next()).dispose();
                }
                this.imageTable = null;
            }
        }

        private Map<Object, Object> getImageTable() {
            return this.imageTable;
        }
    }
}

