/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.datatransfer.wizard;

import com.ibm.ccl.sca.core.datatransfer.ArchiveExportOperation;
import com.ibm.ccl.sca.core.datatransfer.ArchiveExportOperationHelper;
import com.ibm.ccl.sca.core.model.ISCAArtifact;
import com.ibm.ccl.sca.core.model.ISCAComposite;
import com.ibm.ccl.sca.core.model.ISCAContribution;
import com.ibm.ccl.sca.core.model.ISCAProject;
import com.ibm.ccl.sca.core.model.SCAModelManager;
import com.ibm.ccl.sca.core.model.SCAModelUtil;
import com.ibm.ccl.sca.core.util.Logger;
import com.ibm.ccl.sca.internal.ui.common.controls.AbstractSelectionListener;
import com.ibm.ccl.sca.internal.ui.common.controls.CompositeAndContributionSelControl;
import com.ibm.ccl.sca.internal.ui.common.controls.ICompositeSelectionControl;
import com.ibm.ccl.sca.internal.ui.common.controls.IPackButtonAction;
import com.ibm.ccl.sca.internal.ui.preferences.UIPreferences;
import com.ibm.ccl.sca.ui.messages.Messages;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.WizardExportResourcesPage;

public class ArchiveExportPage1
extends WizardExportResourcesPage {
    private String INFOPOP_SCA_EXPORT_WIZARD = "SCA_EXPORT_WIZARD";
    protected CompositeAndContributionSelControl compositeAndContributionSelControl;
    protected Combo destinationNameField;
    protected Button destinationBrowseButton;
    protected Button exportCompositeDiagramFilesCheckbox;
    protected Button overwriteExistingFilesCheckbox;
    protected Button useArchiveCompressionCheckbox;
    protected Link preferencePageLink;
    private ISCAProject[] currentSCAProjectsArray = null;
    private ArrayList<ISCAComposite> currentAllSCACompositesList = new ArrayList();
    private ArrayList<ISCAContribution> currentAllSCAContributionsList = new ArrayList();
    private ArrayList<ISCAContribution> currentNonVirtualSCAContributionsList = new ArrayList();
    private ArrayList<ISCAContribution> currentVirtualSCAContributionsList = new ArrayList();
    private ArrayList<List<ISCAArtifact<?>>> currentContributionsAndArtifactsList = new ArrayList();
    private IStructuredSelection initialResourceSelection;
    private static boolean CLEAR_CACHE_FIRST = true;
    private UIPreferences scaUIPreferences = this.getUIPreferences();
    private static final String STORE_DESTINATIONS_PREFERENCE = "ArchiveExportPage1.STORE_DESTINATIONS_PREFERENCE";
    private static final String PREFERENCE_PAGE_ID = "com.ibm.ccl.sca.internal.ui.preferences.importExportPreferencePage";
    protected Button exportCompositesRadioButton;
    protected Button exportContributionsRadioButton;

    protected ArchiveExportPage1(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
    }

    public ArchiveExportPage1(IStructuredSelection selection) {
        this("archiveFileExportPage1", selection);
        this.setTitle(Messages.SCA_ARCHIVE_EXPORT_TITLE);
        this.setDescription(Messages.SCA_ARCHIVE_EXPORT_DESCRIPTION_TEXT);
        this.initialResourceSelection = selection;
        this.cacheAllSCAProjects();
        this.cacheAllSCAComposites(CLEAR_CACHE_FIRST);
        this.cacheAllSCAContributions(CLEAR_CACHE_FIRST);
        this.cacheVirtualSCAContributions(CLEAR_CACHE_FIRST);
        this.cacheNonVirtualSCAContributions(CLEAR_CACHE_FIRST);
        this.cacheContributionsAndCompositesArtifacts(CLEAR_CACHE_FIRST);
    }

    public UIPreferences getUIPreferences() {
        return new UIPreferences();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.ccl.sca.ui." + this.INFOPOP_SCA_EXPORT_WIZARD);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setSize(composite.computeSize(-1, -1));
        composite.setFont(parent.getFont());
        this.createSCAResourcesGroup(composite);
        this.createNavigationControlButtonsGroup(composite);
        this.createDestinationGroup(composite);
        this.createArchiveExportOptionsGroup(composite);
        this.restoreWidgetValues();
        if (this.initialResourceSelection != null) {
            this.setupBasedOnInitialSelections();
        }
        this.updateWidgetEnablements();
        if (this.compositeAndContributionSelControl.isEmpty()) {
            this.disableAllUIConrols(true);
        } else if (this.compositeAndContributionSelControl.getSelectedComposites().isEmpty()) {
            this.setPageComplete(false);
            this.updateDestinationFieldFromSelection();
        } else {
            this.updateDestinationFieldFromSelection();
            this.setPageComplete(this.determinePageCompletion());
        }
        this.setControl((Control)composite);
        this.setErrorMessage(null);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.arhive_file_export_wizard_page");
    }

    protected void disableAllUIConrols(boolean disable) {
        this.destinationNameField.setEnabled(!disable);
        this.destinationBrowseButton.setEnabled(!disable);
        this.exportCompositeDiagramFilesCheckbox.setEnabled(!disable);
        this.overwriteExistingFilesCheckbox.setEnabled(!disable);
        this.useArchiveCompressionCheckbox.setEnabled(!disable);
        this.updatePageCompletion();
    }

    protected void createSCAResourcesGroup(Composite parent) {
        this.createContributionsAndCompositesChoices(parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        composite.setSize(composite.computeSize(-1, -1));
        composite.setFont(parent.getFont());
        this.compositeAndContributionSelControl = CompositeAndContributionSelControl.createCompositeSelectionControlAsCheckedTree(composite);
        this.compositeAndContributionSelControl.setSearchScope(ICompositeSelectionControl.SCOPE.ENCLOSING_PROJECT, false);
        this.compositeAndContributionSelControl.setSearchScope(ICompositeSelectionControl.SCOPE.ENCLOSING_PROJECT_PLUS_DEPENDENCIES, false);
        boolean isInitializeViewByContributions = this.exportContributionsRadioButton.getSelection();
        this.compositeAndContributionSelControl.setExportByContributions(isInitializeViewByContributions);
        this.compositeAndContributionSelControl.initializeTreeView(isInitializeViewByContributions);
        ICheckStateListener listener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ArchiveExportPage1.this.updateWidgetEnablements();
            }
        };
        this.compositeAndContributionSelControl.addListenerObject(listener);
    }

    protected final void createNavigationControlButtonsGroup(Composite parent) {
        this.compositeAndContributionSelControl.packButtons(new IPackButtonAction(){

            @Override
            public void pack(Button b) {
                ArchiveExportPage1.this.setButtonLayoutData(b);
            }
        });
        this.compositeAndContributionSelControl.addSelectionListener2SelectAll(new AbstractSelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ArchiveExportPage1.this.setErrorMessage(null);
                ArchiveExportPage1.this.setPageComplete(ArchiveExportPage1.this.determinePageCompletion());
            }
        });
        this.compositeAndContributionSelControl.addSelectionListener2DeselectAll(new AbstractSelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ArchiveExportPage1.this.setErrorMessage(Messages.SCA_NO_RESOURCES_ARE_SELECTED_FOR_EXPORT_MESSAGE);
                ArchiveExportPage1.this.setPageComplete(false);
            }
        });
    }

    protected void createDestinationGroup(Composite parent) {
        Font font = parent.getFont();
        Composite destinationSelectionGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        destinationSelectionGroup.setLayout((Layout)layout);
        destinationSelectionGroup.setLayoutData((Object)new GridData(272));
        destinationSelectionGroup.setFont(font);
        Label destinationLabel = new Label(destinationSelectionGroup, 0);
        destinationLabel.setText(this.getDestinationLabel());
        destinationLabel.setFont(font);
        this.destinationNameField = new Combo(destinationSelectionGroup, 2052);
        this.destinationNameField.addListener(24, (Listener)this);
        this.destinationNameField.addListener(13, (Listener)this);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.destinationNameField.setLayoutData((Object)data);
        this.destinationNameField.setFont(font);
        this.destinationNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ArchiveExportPage1.this.handleDestinationTextfieldModified();
            }
        });
        this.destinationBrowseButton = new Button(destinationSelectionGroup, 8);
        this.destinationBrowseButton.setText(Messages.SCA_BROWSE_BUTTON_TEXT);
        this.destinationBrowseButton.addListener(13, (Listener)this);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArchiveExportPage1.this.handleDestinationBrowseButtonPressed();
            }
        };
        this.destinationBrowseButton.addSelectionListener((SelectionListener)listener);
        this.destinationBrowseButton.setFont(font);
        this.setButtonLayoutData(this.destinationBrowseButton);
        new Label(parent, 0);
    }

    protected void createArchiveExportOptionsGroup(Composite parent) {
        Group optionsGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        optionsGroup.setLayout((Layout)layout);
        optionsGroup.setLayoutData((Object)new GridData(768));
        optionsGroup.setText(Messages.SCA_ARCHIVE_OPTIONS_GROUP_TITLE);
        optionsGroup.setFont(parent.getFont());
        this.createArchiveExportOptionsGroupButtons(optionsGroup);
    }

    protected void createArchiveExportOptionsGroupButtons(Group optionsGroup) {
        Font font = optionsGroup.getFont();
        optionsGroup.setLayout((Layout)new GridLayout(2, true));
        Composite left = new Composite((Composite)optionsGroup, 0);
        left.setLayoutData((Object)new GridData(16384, 128, true, false));
        left.setLayout((Layout)new GridLayout(1, true));
        this.useArchiveCompressionCheckbox = new Button(left, 16416);
        this.useArchiveCompressionCheckbox.setText(Messages.SCA_COMPRESS_ARCHIVE_CHECKBOX_TEXT);
        this.useArchiveCompressionCheckbox.setFont(font);
        this.useArchiveCompressionCheckbox.setSelection(this.scaUIPreferences.getCompressArchivePref());
        this.overwriteExistingFilesCheckbox = new Button(left, 16416);
        this.overwriteExistingFilesCheckbox.setText(Messages.SCA_OVERWRITE_FILES_WITHOUT_WARNING_LABEL_TEXT);
        this.overwriteExistingFilesCheckbox.setFont(font);
        this.overwriteExistingFilesCheckbox.setSelection(this.scaUIPreferences.getOverwriteArchiveWithoutWarningPref());
        Composite right = new Composite((Composite)optionsGroup, 0);
        right.setLayoutData((Object)new GridData(16384, 128, true, false));
        right.setLayout((Layout)new GridLayout(1, true));
        this.createAdditionalExportOptions(right, font);
    }

    protected void createAdditionalExportOptions(Composite optionsGroup, Font font) {
        this.exportCompositeDiagramFilesCheckbox = new Button(optionsGroup, 16416);
        this.exportCompositeDiagramFilesCheckbox.setText(Messages.SCA_EXPORT_COMPOSITE_FILES_MESSAGE);
        this.exportCompositeDiagramFilesCheckbox.setFont(font);
        this.exportCompositeDiagramFilesCheckbox.setSelection(this.scaUIPreferences.getExportDiagramFilesPref());
        this.preferencePageLink = new Link(optionsGroup, 0);
        this.preferencePageLink.setText(Messages.SCA_EXPORT_ARCHIVE_WIZARD_PREF_PAGE_LINK);
        this.preferencePageLink.setEnabled(true);
        this.preferencePageLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArchiveExportPage1.this.openImportExportPreferencePage();
            }
        });
    }

    private void openImportExportPreferencePage() {
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)PREFERENCE_PAGE_ID, (String[])new String[]{PREFERENCE_PAGE_ID}, null);
        dialog.open();
    }

    private void updateDestinationFieldFromSelection() {
        int itemCount = this.destinationNameField.getItemCount();
        String lastDestinationPath = null;
        if (itemCount > 0) {
            lastDestinationPath = this.destinationNameField.getItem(0);
        }
        if (this.initialResourceSelection.getFirstElement() instanceof IResource) {
            IResource resource = (IResource)this.initialResourceSelection.getFirstElement();
            if (resource.getType() == 1 && lastDestinationPath != null && !lastDestinationPath.equals("")) {
                this.destinationNameField.setText(lastDestinationPath);
            }
            if (resource.getType() == 4 && lastDestinationPath != null && !lastDestinationPath.equals("")) {
                this.destinationNameField.setText(lastDestinationPath);
            }
        } else if (lastDestinationPath != null && !lastDestinationPath.equals("")) {
            this.destinationNameField.setText(lastDestinationPath);
        }
    }

    protected void setupBasedOnInitialSelections() {
        ArrayList<IResource> potentialComposites = new ArrayList<IResource>();
        for (IResource currentResource : this.initialResourceSelection) {
            if (currentResource.getType() == 4) {
                this.compositeAndContributionSelControl.select(currentResource);
                return;
            }
            if (currentResource.getType() != 1) continue;
            if (currentResource.getName().equals("sca-contribution.xml")) {
                this.compositeAndContributionSelControl.select(currentResource.getProject());
                return;
            }
            potentialComposites.add(currentResource);
        }
        if (!potentialComposites.isEmpty()) {
            this.exportCompositesRadioButton.setSelection(true);
            this.handleExportCompositesSelected(null);
            for (IResource potentialComposite : potentialComposites) {
                this.compositeAndContributionSelControl.select(potentialComposite);
            }
        }
    }

    protected boolean determinePageCompletion() {
        boolean complete;
        boolean bl = complete = this.validateSourceGroup() && this.validateDestinationGroup();
        if (complete) {
            this.setErrorMessage(null);
        }
        return complete;
    }

    public boolean finish() {
        if (!this.ensureTargetIsValid()) {
            return false;
        }
        if (this.exportCompositesRadioButton.getSelection()) {
            return this.finishExportComposites();
        }
        if (this.exportContributionsRadioButton.getSelection()) {
            return this.finishExportContributions();
        }
        return false;
    }

    private boolean finishExportComposites() {
        List<?> compositeResourcesToExport = this.getWhiteCheckedResources();
        boolean exportDiagrams = this.exportCompositeDiagramFilesCheckbox.getSelection();
        ArchiveExportOperationHelper exportHelper = new ArchiveExportOperationHelper(exportDiagrams);
        List allExportableResources = exportHelper.getAllExportableResources(compositeResourcesToExport);
        this.saveDirtyEditors();
        this.saveWidgetValues();
        return this.canExecuteExportOperation(new ArchiveExportOperation(null, allExportableResources, this.getDestinationValue()));
    }

    private boolean finishExportContributions() {
        List<?> projectsForContributionsList = this.getWhiteCheckedResources();
        boolean exportDiagrams = this.exportCompositeDiagramFilesCheckbox.getSelection();
        ArchiveExportOperationHelper exportHelper = new ArchiveExportOperationHelper(exportDiagrams);
        List fullList = exportHelper.getAllExportableResourcesFromProjects(projectsForContributionsList);
        this.saveDirtyEditors();
        this.saveWidgetValues();
        return this.canExecuteExportOperation(new ArchiveExportOperation(null, fullList, this.getDestinationValue()));
    }

    protected List<?> getWhiteCheckedResources() {
        ArrayList<Object> selected = new ArrayList<Object>();
        for (Object obj : this.compositeAndContributionSelControl.getSelected()) {
            if (this.exportCompositesRadioButton.getSelection() && obj instanceof IFile) {
                selected.add(obj);
            }
            if (!this.exportContributionsRadioButton.getSelection() || !(obj instanceof IProject)) continue;
            selected.add(obj);
        }
        return selected;
    }

    protected boolean validateSourceGroup() {
        boolean isValid = true;
        List<?> resourcesToExport = this.getWhiteCheckedResources();
        if (resourcesToExport.size() == 0) {
            this.setErrorMessage(Messages.SCA_NO_RESOURCES_ARE_SELECTED_FOR_EXPORT_MESSAGE);
            isValid = false;
        } else {
            this.setErrorMessage(null);
        }
        return super.validateSourceGroup() && isValid;
    }

    protected void updatePageCompletion() {
        boolean pageComplete = this.determinePageCompletion();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            this.setErrorMessage(null);
        }
        if (this.compositeAndContributionSelControl.isEmpty()) {
            this.setErrorMessage(Messages.SCA_NO_RESOURCES_ARE_SELECTED_FOR_EXPORT_MESSAGE);
            this.setPageComplete(false);
        }
    }

    protected void handleDestinationBrowseButtonPressed() {
        String selectedFileName;
        FileDialog dialog = new FileDialog(this.getContainer().getShell(), 8192);
        dialog.setFilterExtensions(new String[]{"*.jar;*.zip", "*.*"});
        dialog.setText(Messages.SCA_EXPORT_TO_ARCHIVE_FILE_MESSAGE);
        String currentSourceString = this.getDestinationValue();
        int lastSeparatorIndex = currentSourceString.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(currentSourceString.substring(0, lastSeparatorIndex));
        }
        if ((selectedFileName = dialog.open()) != null) {
            this.setErrorMessage(null);
            this.setDestinationValue(selectedFileName);
        }
    }

    protected void handleDestinationTextfieldModified() {
        String archiveFilePath = this.destinationNameField.getText();
        if (archiveFilePath == null || archiveFilePath.equals("")) {
            this.setErrorMessage(Messages.SCA_DESTINATION_ARCHIVE_NAME_REQUIRED_MESSAGE);
            this.setPageComplete(false);
            this.destinationNameField.setFocus();
        } else if (this.exportCompositesRadioButton.getSelection()) {
            if (this.compositeAndContributionSelControl.getSelectedComposites().isEmpty()) {
                this.setPageComplete(false);
                this.setErrorMessage(Messages.SCA_ARCHIVE_EXPORT_COMPOSITES_OR_COMPOSITES_DESCRIPTION_TEXT);
            } else {
                this.setErrorMessage(null);
                this.setPageComplete(true);
            }
        } else if (this.exportContributionsRadioButton.getSelection()) {
            if (this.getWhiteCheckedResources().isEmpty()) {
                this.setPageComplete(false);
                this.setErrorMessage(Messages.SCA_ARCHIVE_EXPORT_COMPOSITES_OR_COMPOSITES_DESCRIPTION_TEXT);
            } else {
                this.setErrorMessage(null);
                this.setPageComplete(true);
            }
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    protected boolean ensureTargetIsValid(File targetFile) {
        if (targetFile.exists() && targetFile.isDirectory()) {
            this.displayErrorDialog(Messages.SCA_FILE_NOT_DIRECTORY_REQUIRED_MESSAGE);
            this.giveFocusToDestination();
            return false;
        }
        if (targetFile.exists() && targetFile.canWrite()) {
            if (this.overwriteExistingFilesCheckbox.getSelection()) {
                return true;
            }
            if (!this.queryYesNoQuestion(Messages.SCA_TARGET_FILE_ALREADY_EXISTS_WARNING_MESSAGE)) {
                return false;
            }
        }
        return true;
    }

    protected boolean canExecuteExportOperation(ArchiveExportOperation archiveFileExportOperation) {
        archiveFileExportOperation.setUseCompression(this.useArchiveCompressionCheckbox.getSelection());
        ExportRunnable runnable = new ExportRunnable(archiveFileExportOperation);
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)runnable);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            this.displayErrorDialog(e.getTargetException());
            return false;
        }
        IStatus status = archiveFileExportOperation.getStatus();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.SCA_PROBLEMS_EXPORTING_MESSAGE, null, (IStatus)status);
            return false;
        }
        return true;
    }

    protected boolean ensureTargetIsValid() {
        String targetPath = this.getDestinationValue();
        return this.ensureTargetIsValid(new File(targetPath));
    }

    protected String getDestinationLabel() {
        return Messages.SCA_TO_ARCHIVE_NAME_LABEL_TEXT;
    }

    protected String getDestinationValue() {
        String fileSuffix = ".jar";
        String destinationText = this.destinationNameField.getText().trim();
        if (destinationText.length() != 0 && !destinationText.endsWith(File.separator)) {
            int dotIndex = destinationText.lastIndexOf(46);
            if (dotIndex != -1) {
                int pathSepIndex = destinationText.lastIndexOf(File.separator);
                if (pathSepIndex != -1 && dotIndex < pathSepIndex) {
                    destinationText = String.valueOf(destinationText) + fileSuffix;
                }
            } else {
                destinationText = String.valueOf(destinationText) + fileSuffix;
            }
        }
        return destinationText;
    }

    protected void setDestinationValue(String value) {
        this.destinationNameField.setText(value);
    }

    protected void internalSaveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] fullPathsToAchiveFilesnames = settings.getArray(STORE_DESTINATIONS_PREFERENCE);
            if (fullPathsToAchiveFilesnames == null) {
                fullPathsToAchiveFilesnames = new String[]{};
            }
            fullPathsToAchiveFilesnames = this.addToHistory(fullPathsToAchiveFilesnames, this.getDestinationValue());
            settings.put(STORE_DESTINATIONS_PREFERENCE, fullPathsToAchiveFilesnames);
        }
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] fullPathsToAchiveFilesnames = settings.getArray(STORE_DESTINATIONS_PREFERENCE);
            if (fullPathsToAchiveFilesnames == null || fullPathsToAchiveFilesnames.length == 0) {
                return;
            }
            this.setDestinationValue(fullPathsToAchiveFilesnames[0]);
            int i = 0;
            while (i < fullPathsToAchiveFilesnames.length) {
                this.addDestinationItem(fullPathsToAchiveFilesnames[i]);
                ++i;
            }
        }
    }

    protected void addDestinationItem(String value) {
        this.destinationNameField.add(value);
    }

    protected boolean validateDestinationGroup() {
        String archiveFilePath = this.destinationNameField.getText();
        if (archiveFilePath == null || archiveFilePath.equals("")) {
            this.setErrorMessage(Messages.SCA_DESTINATION_ARCHIVE_NAME_REQUIRED_MESSAGE);
            this.destinationNameField.setFocus();
            return false;
        }
        return true;
    }

    private void cacheAllSCAProjects() {
        try {
            List currentSCAProjectsList = SCAModelUtil.getSCAProjectsList();
            this.currentSCAProjectsArray = SCAModelUtil.convertSCAProjectsListToArray((List)currentSCAProjectsList);
        }
        catch (CoreException coreException) {
            Logger.println((int)0, (Object)((Object)this), (String)"cacheAllSCAProjects()", (String)"Error occuring trying to get the current list of SCA Projects");
        }
    }

    private void cacheAllSCAComposites(boolean clearCacheFirst) {
        if (this.currentSCAProjectsArray == null || this.currentSCAProjectsArray.length == 0) {
            return;
        }
        if (clearCacheFirst) {
            this.currentAllSCACompositesList.clear();
        }
        int i = 0;
        while (i < this.currentSCAProjectsArray.length) {
            List projectCompositesList = SCAModelManager.getComposites((ISCAProject)this.currentSCAProjectsArray[i]);
            if (projectCompositesList != null && !projectCompositesList.isEmpty()) {
                this.currentAllSCACompositesList.addAll(projectCompositesList);
            }
            ++i;
        }
    }

    private void cacheAllSCAContributions(boolean clearCacheFirst) {
        if (this.currentSCAProjectsArray == null || this.currentSCAProjectsArray.length == 0) {
            return;
        }
        if (clearCacheFirst) {
            this.currentAllSCAContributionsList.clear();
        }
        int i = 0;
        while (i < this.currentSCAProjectsArray.length) {
            List projectContributionsList = SCAModelManager.getContributions((ISCAProject)this.currentSCAProjectsArray[i]);
            if (projectContributionsList != null && !projectContributionsList.isEmpty()) {
                this.currentAllSCAContributionsList.addAll(projectContributionsList);
            }
            ++i;
        }
    }

    private void cacheVirtualSCAContributions(boolean clearCacheFirst) {
        if (this.currentSCAProjectsArray == null || this.currentSCAProjectsArray.length == 0) {
            return;
        }
        if (clearCacheFirst) {
            this.currentVirtualSCAContributionsList.clear();
        }
        int i = 0;
        while (i < this.currentSCAProjectsArray.length) {
            List projectContributionsList = SCAModelManager.getContributions((ISCAProject)this.currentSCAProjectsArray[i]);
            if (projectContributionsList != null && !projectContributionsList.isEmpty()) {
                for (ISCAContribution contribution : projectContributionsList) {
                    if (!contribution.isVirtual()) continue;
                    this.currentVirtualSCAContributionsList.addAll(projectContributionsList);
                }
            }
            ++i;
        }
    }

    private void cacheNonVirtualSCAContributions(boolean clearCacheFirst) {
        if (this.currentSCAProjectsArray == null || this.currentSCAProjectsArray.length == 0) {
            return;
        }
        if (clearCacheFirst) {
            this.currentNonVirtualSCAContributionsList.clear();
        }
        int i = 0;
        while (i < this.currentSCAProjectsArray.length) {
            List projectContributionsList = SCAModelManager.getContributions((ISCAProject)this.currentSCAProjectsArray[i]);
            if (projectContributionsList != null && !projectContributionsList.isEmpty()) {
                for (ISCAContribution contribution : projectContributionsList) {
                    if (contribution.isVirtual()) continue;
                    this.currentNonVirtualSCAContributionsList.addAll(projectContributionsList);
                }
            }
            ++i;
        }
    }

    private List<ISCAArtifact<?>> getContributionsAndCompositeArtifacts(ISCAContribution scaContribution) {
        return SCAModelUtil.getSCAArtifactsListFromContribution((ISCAContribution)scaContribution);
    }

    private void cacheContributionsAndCompositesArtifacts(boolean clearCacheFirst) {
        if (this.currentSCAProjectsArray == null || this.currentSCAProjectsArray.length == 0) {
            return;
        }
        if (clearCacheFirst) {
            this.currentContributionsAndArtifactsList.clear();
        }
        for (ISCAContribution scaContribution : this.currentNonVirtualSCAContributionsList) {
            List<ISCAArtifact<?>> scaContributionsAndCompositeArtifactsList = this.getContributionsAndCompositeArtifacts(scaContribution);
            if (scaContributionsAndCompositeArtifactsList == null || scaContributionsAndCompositeArtifactsList.isEmpty()) continue;
            this.currentContributionsAndArtifactsList.add(scaContributionsAndCompositeArtifactsList);
        }
    }

    protected boolean allowNewContainerName() {
        return super.allowNewContainerName();
    }

    public void handleEvent(Event event) {
    }

    protected void giveFocusToDestination() {
        this.destinationNameField.setFocus();
    }

    protected final void createContributionsAndCompositesChoices(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        composite.setFont(parent.getFont());
        this.createCompositeAndContributionButtons(composite);
    }

    protected void createCompositeAndContributionButtons(Composite composite) {
        Font font = composite.getFont();
        composite.setLayout((Layout)new GridLayout(2, true));
        Composite left = new Composite(composite, 0);
        left.setLayoutData((Object)new GridData(16384, 128, true, false));
        left.setLayout((Layout)new GridLayout(1, true));
        this.exportContributionsRadioButton = new Button(left, 16400);
        this.exportContributionsRadioButton.setText(Messages.SCA_EXPORT_ARCHIVE_CONTRIBUTIONS_BUTTON_TEXT);
        this.exportContributionsRadioButton.setFont(font);
        SelectionAdapter listener1 = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArchiveExportPage1.this.handleExportContributionsSelected(e);
            }
        };
        this.exportContributionsRadioButton.addSelectionListener((SelectionListener)listener1);
        this.exportContributionsRadioButton.setSelection(true);
        Composite right = new Composite(composite, 0);
        right.setLayoutData((Object)new GridData(16384, 128, true, false));
        right.setLayout((Layout)new GridLayout(1, true));
        this.exportCompositesRadioButton = new Button(right, 16400);
        this.exportCompositesRadioButton.setText(Messages.SCA_EXPORT_ARCHIVE_COMPOSITES_BUTTON_TEXT);
        this.exportCompositesRadioButton.setFont(font);
        SelectionAdapter listener2 = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArchiveExportPage1.this.handleExportCompositesSelected(e);
            }
        };
        this.exportCompositesRadioButton.addSelectionListener((SelectionListener)listener2);
    }

    protected void handleExportCompositesSelected(SelectionEvent e) {
        this.exportContributionsRadioButton.setSelection(false);
        this.compositeAndContributionSelControl.reInitializeTreeView(false);
        this.setMessage(Messages.SCA_ARCHIVE_EXPORT_COMPOSITES_DESCRIPTION_TEXT);
        this.compositeAndContributionSelControl.handleExportCompositesChoice(e);
        this.disableAllUIConrols(this.compositeAndContributionSelControl.isEmpty());
    }

    protected void handleExportContributionsSelected(SelectionEvent e) {
        this.exportCompositesRadioButton.setSelection(false);
        this.compositeAndContributionSelControl.reInitializeTreeView(true);
        this.setMessage(Messages.SCA_ARCHIVE_EXPORT_CONTRIBUTIONS_DESCRIPTION_TEXT);
        this.compositeAndContributionSelControl.handleExportContributionChoice(e);
        this.disableAllUIConrols(this.compositeAndContributionSelControl.isEmpty());
    }

    private class ExportRunnable
    implements IRunnableWithProgress {
        private ArchiveExportOperation operation;

        public ExportRunnable(ArchiveExportOperation exportOperation) {
            this.operation = exportOperation;
        }

        public void run(IProgressMonitor arg0) throws InvocationTargetException, InterruptedException {
            this.operation.run(arg0);
        }
    }
}

