/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.datatransfer.operations;

import com.ibm.ccl.sca.core.util.Logger;
import com.ibm.ccl.sca.internal.core.datatransfer.IImportDataStructureProvider;
import com.ibm.ccl.sca.ui.messages.Messages;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.ui.dialogs.FileSystemElement;

public class ResourceSelectionOperation
implements IRunnableWithProgress {
    IProgressMonitor monitor;
    Object root;
    IImportDataStructureProvider provider;
    String[] fileExtensions;
    FileSystemElement result;

    public ResourceSelectionOperation(Object rootObject, IImportDataStructureProvider structureProvider) {
        this.root = rootObject;
        this.provider = structureProvider;
    }

    protected FileSystemElement createElement(FileSystemElement parent, Object fileSystemObject) throws InterruptedException {
        String elementLabel;
        ModalContext.checkCanceled((IProgressMonitor)this.monitor);
        boolean isContainer = this.provider.isFolder(fileSystemObject);
        String string = elementLabel = parent == null ? this.provider.getFullPath(fileSystemObject) : this.provider.getLabel(fileSystemObject);
        if (!isContainer && !this.hasArchiveTypeFileExtension(elementLabel)) {
            Logger.println((int)2, (Object)this, (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
            return null;
        }
        FileSystemElement result = new FileSystemElement(elementLabel, parent, isContainer);
        result.setFileSystemObject(fileSystemObject);
        Logger.println((int)2, (Object)this, (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
        if (isContainer) {
            boolean haveChildOrFile = false;
            ArrayList children = this.provider.getChildren(fileSystemObject);
            if (children == null) {
                children = new ArrayList(1);
            }
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                if (this.createElement(result, iterator.next()) == null) continue;
                haveChildOrFile = true;
            }
            if (!haveChildOrFile && parent != null) {
                Logger.println((int)2, (Object)this, (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
                parent.removeFolder(result);
                result = null;
            }
        }
        Logger.println((int)2, (Object)this, (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
        return result;
    }

    protected String getExtensionFor(String filename) {
        int nIndex = filename.lastIndexOf(46);
        if (nIndex >= 0) {
            Logger.println((int)2, (Object)this, (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
            return filename.substring(nIndex + 1);
        }
        Logger.println((int)2, (Object)this, (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
        return "";
    }

    public FileSystemElement getResult() {
        return this.result;
    }

    protected boolean hasArchiveTypeFileExtension(String filename) {
        if (this.fileExtensions == null) {
            Logger.println((int)2, (Object)this, (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
            return true;
        }
        int extensionsSize = this.fileExtensions.length;
        int i = 0;
        while (i < extensionsSize) {
            if (this.getExtensionFor(filename).equalsIgnoreCase(this.fileExtensions[i])) {
                Logger.println((int)2, (Object)this, (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
                return true;
            }
            ++i;
        }
        Logger.println((int)2, (Object)this, (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
        return false;
    }

    public void run(IProgressMonitor monitor) throws InterruptedException {
        try {
            this.monitor = monitor;
            monitor.beginTask(Messages.SCA_SCANNING_FOR_MATCHING_FILES_MESSAGE, -1);
            this.result = this.createElement(null, this.root);
            Logger.println((int)2, (Object)this, (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
            if (this.result == null) {
                this.result = new FileSystemElement(this.provider.getLabel(this.root), null, this.provider.isFolder(this.root));
                Logger.println((int)2, (Object)this, (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
                this.result.setFileSystemObject(this.root);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void setFileExtensions(String[] extensions) {
        this.fileExtensions = extensions;
    }
}

