/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.datatransfer.operations;

import com.ibm.ccl.sca.core.util.Logger;
import com.ibm.ccl.sca.internal.core.datatransfer.ArchiveFileLeveledStructureProvider;
import com.ibm.ccl.sca.ui.messages.Messages;
import java.io.IOException;
import java.util.zip.ZipFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ArchiveFileActions {
    private static ArchiveFileLeveledStructureProvider archiveProviderCache;

    public static boolean isZipFile(String fileName) {
        if (fileName.length() == 0) {
            return false;
        }
        try {
            new ZipFile(fileName);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public static void clearCache(Shell shell) {
        if (archiveProviderCache != null) {
            Logger.println((int)2, ArchiveFileActions.class, (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
            ArchiveFileActions.closeArchiveFile(archiveProviderCache.getArchiveFile(), shell);
            archiveProviderCache = null;
        }
    }

    public static ArchiveFileLeveledStructureProvider getZipStructureProvider(ZipFile targetArchiveFile, Shell shell) {
        if (archiveProviderCache == null) {
            Logger.println((int)2, ArchiveFileActions.class, (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
            archiveProviderCache = new ArchiveFileLeveledStructureProvider(targetArchiveFile);
        } else if (!archiveProviderCache.getArchiveFile().getName().equals(targetArchiveFile.getName())) {
            Logger.println((int)2, ArchiveFileActions.class, (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
            ArchiveFileActions.clearCache(shell);
            archiveProviderCache = new ArchiveFileLeveledStructureProvider(targetArchiveFile);
        } else if (!archiveProviderCache.getArchiveFile().equals(targetArchiveFile)) {
            Logger.println((int)2, ArchiveFileActions.class, (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
            archiveProviderCache = new ArchiveFileLeveledStructureProvider(targetArchiveFile);
        }
        return archiveProviderCache;
    }

    public static boolean closeZipFile(ZipFile archiveFile, Shell shell) {
        return ArchiveFileActions.closeArchiveFile(archiveFile, shell);
    }

    public static boolean closeArchiveFile(ZipFile archiveFile, Shell shell) {
        try {
            Logger.println((int)2, ArchiveFileActions.class, (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
            archiveFile.close();
        }
        catch (IOException iOException) {
            Logger.println((int)0, ArchiveFileActions.class, (String)"someMethodTBD()", (String)"this is a placeholder for a logging message");
            ArchiveFileActions.displayErrorDialog(Messages.SCA_COULD_NOT_CLOSE_EXPORTED_ARCHIVE_FILE_MESSAGE, shell);
            return false;
        }
        return true;
    }

    protected static void displayErrorDialog(String errorMessage, Shell shell) {
        MessageDialog.openError((Shell)shell, (String)ArchiveFileActions.getErrorDialogTitle(), (String)errorMessage);
    }

    protected static String getErrorDialogTitle() {
        return "Error Dialog Title tbd";
    }
}

