/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.contribution.editor;

import com.ibm.ccl.sca.internal.ui.contribution.editor.ContributionEditor;
import com.ibm.ccl.sca.internal.ui.contribution.editor.ContributionEditorExtension;
import com.ibm.ccl.sca.internal.ui.contribution.editor.ContributionEditorExtensionRegistry;
import com.ibm.ccl.sca.internal.ui.contribution.editor.ContributionEditorHelper;
import com.ibm.ccl.sca.internal.ui.contribution.editor.ImportExportContentProvider;
import com.ibm.ccl.sca.internal.ui.contribution.editor.ImportExportEditDialog;
import com.ibm.ccl.sca.internal.ui.contribution.editor.ImportExportLabelProvider;
import com.ibm.ccl.sca.internal.ui.contribution.editor.ImportExportListDialog;
import com.ibm.ccl.sca.ui.contribution.editor.ImportExportWrapper;
import com.ibm.ccl.sca.ui.messages.Messages;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ImportExportSection {
    private Map<String, ContributionEditorExtension> extensions = ContributionEditorExtensionRegistry.INSTANCE.getExtensions();
    private FormToolkit toolkit;
    private ContributionEditor parentEditor;
    private boolean isImport;
    private TreeViewer viewer;
    private List<ImportExportWrapper> data;
    private Button editButton;
    private Button removeButton;
    private Button expandButton;
    private Button collapseButton;

    public ImportExportSection(FormToolkit toolkit, ContributionEditor parentEditor, boolean isImport) {
        this.toolkit = toolkit;
        this.parentEditor = parentEditor;
        this.isImport = isImport;
    }

    private void performAdd() {
        ImportExportListDialog dialog = new ImportExportListDialog(this.parentEditor.getSite().getShell(), this.isImport);
        dialog.setInput(this.extensions.values());
        if (dialog.open() == 1) {
            return;
        }
        Object[] result = dialog.getResult();
        ContributionEditorExtension extension = (ContributionEditorExtension)result[0];
        Object obj = extension.getObjectFactory().newObject();
        ImportExportWrapper wrapper = new ImportExportWrapper(obj.getClass().getName(), obj);
        wrapper.setProject(this.parentEditor.getEnclosingProject());
        ImportExportEditDialog editDialog = new ImportExportEditDialog(this.parentEditor.getSite().getShell(), wrapper);
        editDialog.setIsAdd();
        if (editDialog.open() == 0) {
            if (editDialog.isMultiAdd()) {
                this.data.addAll(editDialog.getData());
            } else {
                this.data.add(wrapper);
            }
            this.viewer.refresh();
            this.parentEditor.setDirty();
            this.checkContents();
        }
    }

    private void performEdit(ImportExportWrapper wrapper) {
        while (wrapper.getParent() != null) {
            wrapper = wrapper.getParent();
        }
        wrapper.setProject(this.parentEditor.getEnclosingProject());
        ImportExportEditDialog editDialog = new ImportExportEditDialog(this.parentEditor.getSite().getShell(), wrapper);
        if (editDialog.open() == 0) {
            this.viewer.refresh((Object)wrapper);
            this.parentEditor.setDirty();
        }
    }

    public void createPartControl(Composite parent) {
        String title = this.isImport ? Messages.LABEL_CONTRIB_EDITOR_IMPORTS : Messages.LABEL_CONTRIB_EDITOR_EXPORTS;
        Section section = ContributionEditorHelper.createSection(this.toolkit, parent, title);
        this.viewer = ContributionEditorHelper.createTreeViewer(this.toolkit, section);
        this.viewer.setContentProvider((IContentProvider)new ImportExportContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ImportExportLabelProvider());
        this.viewer.setSorter((ViewerSorter)new ImportExportSorter());
        ImportExportListener listener = new ImportExportListener();
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)listener);
        this.viewer.getTree().addFocusListener((FocusListener)listener);
        Composite buttonComposite = ContributionEditorHelper.createButtonComposite(this.toolkit, this.viewer);
        Button addButton = this.toolkit.createButton(buttonComposite, Messages.LABEL_CONTRIB_EDITOR_IMPORTEXPORT_ADD, 8);
        addButton.setLayoutData((Object)new GridData(258));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExportSection.this.performAdd();
            }
        });
        this.editButton = this.toolkit.createButton(buttonComposite, Messages.LABEL_CONTRIB_EDITOR_IMPORTEXPORT_EDIT, 8);
        this.editButton.setLayoutData((Object)new GridData(258));
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selection = ((IStructuredSelection)ImportExportSection.this.viewer.getSelection()).getFirstElement();
                if (selection instanceof ImportExportWrapper) {
                    ImportExportSection.this.performEdit((ImportExportWrapper)selection);
                }
            }
        });
        this.removeButton = this.toolkit.createButton(buttonComposite, Messages.LABEL_CONTRIB_EDITOR_IMPORTEXPORT_REMOVE, 8);
        this.removeButton.setLayoutData((Object)new GridData(258));
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List toRemove = ((IStructuredSelection)ImportExportSection.this.viewer.getSelection()).toList();
                if (ImportExportSection.this.data.removeAll(toRemove)) {
                    ImportExportSection.this.viewer.refresh();
                    ImportExportSection.this.parentEditor.setDirty();
                    ImportExportSection.this.checkContents();
                }
            }
        });
        this.expandButton = this.toolkit.createButton(buttonComposite, Messages.LABEL_CONTRIB_EDITOR_IMPORTEXPORT_EXPAND, 8);
        this.expandButton.setLayoutData((Object)new GridData(258));
        this.expandButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExportSection.this.viewer.expandAll();
            }
        });
        this.collapseButton = this.toolkit.createButton(buttonComposite, Messages.LABEL_CONTRIB_EDITOR_IMPORTEXPORT_COLLAPSE, 8);
        this.collapseButton.setLayoutData((Object)new GridData(258));
        this.collapseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExportSection.this.viewer.collapseAll();
            }
        });
        if (!ContributionEditorExtensionRegistry.INSTANCE.hasNestedElements(this.isImport)) {
            this.expandButton.setVisible(false);
            this.collapseButton.setVisible(false);
        }
    }

    private void checkContents() {
        boolean enabled = !this.data.isEmpty();
        this.editButton.setEnabled(enabled);
        this.removeButton.setEnabled(enabled);
        this.expandButton.setEnabled(enabled);
        this.collapseButton.setEnabled(enabled);
    }

    public void setData(List<ImportExportWrapper> data) {
        this.data = data;
        this.viewer.setInput(data);
        this.checkContents();
    }

    public List<ImportExportWrapper> getData() {
        return this.data;
    }

    private void setEditable(boolean editable) {
        boolean enabled = editable && !this.data.isEmpty();
        this.editButton.setEnabled(enabled);
        this.removeButton.setEnabled(enabled);
        if (editable) {
            this.parentEditor.setMessage(null, 0);
        } else {
            this.parentEditor.setMessage(Messages.WARNING_SELECTED_ITEM_READ_ONLY, 2);
        }
    }

    private class ImportExportListener
    extends FocusAdapter
    implements ISelectionChangedListener {
        private ImportExportListener() {
        }

        private void checkSelection(ISelection selection) {
            for (ImportExportWrapper wrapper : (IStructuredSelection)selection) {
                if (!wrapper.isGenerated()) continue;
                ImportExportSection.this.setEditable(false);
                return;
            }
            ImportExportSection.this.setEditable(true);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.checkSelection(event.getSelection());
        }

        public void focusGained(FocusEvent e) {
            this.checkSelection(ImportExportSection.this.viewer.getSelection());
        }
    }

    private class ImportExportSorter
    extends ViewerSorter {
        private ImportExportSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            ImportExportWrapper wrapper1 = (ImportExportWrapper)e1;
            ImportExportWrapper wrapper2 = (ImportExportWrapper)e2;
            ContributionEditorExtension extension1 = (ContributionEditorExtension)ImportExportSection.this.extensions.get(wrapper1.getClassName());
            ContributionEditorExtension extension2 = (ContributionEditorExtension)ImportExportSection.this.extensions.get(wrapper2.getClassName());
            if (extension1 != null && extension2 != null && !extension1.equals(extension2)) {
                return extension1.compareTo(extension2);
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

