/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.contribution.editor;

import com.ibm.ccl.sca.internal.ui.contribution.editor.ContributionEditorExtension;
import com.ibm.ccl.sca.ui.messages.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;

public class ImportExportListDialog
extends ListDialog {
    private boolean isImport;

    public ImportExportListDialog(Shell shell, boolean isImport) {
        super(shell);
        this.isImport = isImport;
        this.setContentProvider(new ExtensionListContentProvider());
        this.setLabelProvider((ILabelProvider)new ExtensionListLabelProvider());
        if (isImport) {
            this.setMessage(Messages.LABEL_CONTRIB_EDITOR_SELECT_IMPORT);
        } else {
            this.setMessage(Messages.LABEL_CONTRIB_EDITOR_SELECT_EXPORT);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        String title = this.isImport ? Messages.LABEL_CONTRIB_EDITOR_ADD_IMPORT : Messages.LABEL_CONTRIB_EDITOR_ADD_EXPORT;
        shell.setText(title);
    }

    private class ExtensionListContentProvider
    implements IStructuredContentProvider {
        private ExtensionListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Collection collection = (Collection)inputElement;
            ArrayList<ContributionEditorExtension> extensions = new ArrayList<ContributionEditorExtension>();
            for (Object obj : collection) {
                ContributionEditorExtension extension = (ContributionEditorExtension)obj;
                if (extension.isImport() != ImportExportListDialog.this.isImport) continue;
                extensions.add(extension);
            }
            if (!extensions.isEmpty()) {
                Collections.sort(extensions);
                ImportExportListDialog.this.setInitialSelections(new Object[]{extensions.get(0)});
            }
            return extensions.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private class ExtensionListLabelProvider
    extends LabelProvider {
        private ExtensionListLabelProvider() {
        }

        public Image getImage(Object element) {
            return ((ContributionEditorExtension)element).getImage();
        }

        public String getText(Object element) {
            return ((ContributionEditorExtension)element).getTagName();
        }
    }
}

