/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.contribution.editor;

import com.ibm.ccl.sca.internal.ui.contribution.editor.ContributionEditorExtension;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class ContributionEditorExtensionRegistry {
    private static final String EXT_ID = "com.ibm.ccl.sca.ui.contributionImportExport";
    private static final String IMPORT_TAG = "import";
    private static final String CLASSNAME_ATTR = "className";
    private static final String NESTED_ATTR = "hasNestedElements";
    public static final ContributionEditorExtensionRegistry INSTANCE = new ContributionEditorExtensionRegistry();
    private Map<String, ContributionEditorExtension> extensions = new Hashtable<String, ContributionEditorExtension>();
    private boolean hasNestedImports = false;
    private boolean hasNestedExports = false;

    private ContributionEditorExtensionRegistry() {
        IConfigurationElement[] configs;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = configs = extensionRegistry.getConfigurationElementsFor(EXT_ID);
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            String name = config.getName();
            String className = config.getAttribute(CLASSNAME_ATTR);
            boolean hasNestedElements = Boolean.parseBoolean(config.getAttribute(NESTED_ATTR));
            if (name.equals(IMPORT_TAG)) {
                this.extensions.put(className, new ContributionEditorExtension(config, true));
                this.hasNestedImports |= hasNestedElements;
            } else {
                this.extensions.put(className, new ContributionEditorExtension(config, false));
                this.hasNestedExports |= hasNestedElements;
            }
            ++n2;
        }
    }

    public Map<String, ContributionEditorExtension> getExtensions() {
        return this.extensions;
    }

    public boolean hasNestedElements(boolean isImport) {
        return isImport ? this.hasNestedImports : this.hasNestedExports;
    }
}

