/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.common.controls.emf.data;

import com.ibm.ccl.sca.internal.ui.common.controls.emf.data.EMFContainer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class EMFReferenceContainer
implements EMFContainer {
    private EMFContainer parentContainer;
    private EReference reference;
    private EObject containerObject;
    private List<EMFContainer> children;
    private TransactionalEditingDomain domain;

    public EMFReferenceContainer(EMFContainer parentContainer, EReference reference, TransactionalEditingDomain domain) {
        this.parentContainer = parentContainer;
        this.reference = reference;
        this.children = new ArrayList<EMFContainer>();
        this.domain = domain;
        if (parentContainer != null) {
            parentContainer.addChild(this);
        }
    }

    protected EClass getEClass() {
        return this.reference.getEReferenceType();
    }

    @Override
    public void setParentObject(Object parentNode, boolean isRoot) {
        this.containerObject = isRoot ? (EObject)parentNode : (parentNode != null ? (EObject)((EObject)parentNode).eGet((EStructuralFeature)this.reference) : null);
        for (EMFContainer container : this.children) {
            container.setParentObject(this.containerObject, false);
        }
    }

    @Override
    public Object getContainerObject(boolean create) {
        if (this.containerObject == null && create) {
            EClass eClass = this.getEClass();
            EFactory factory = eClass.getEPackage().getEFactoryInstance();
            this.containerObject = factory.create(eClass);
            this.parentContainer.setReference(this.reference, this.containerObject, this);
        }
        return this.containerObject;
    }

    @Override
    public void setReference(EReference childReference, Object value, EMFContainer childContainer) {
        EObject container = (EObject)this.getContainerObject(true);
        container.eSet((EStructuralFeature)childReference, value);
    }

    public Object getAttribute(EAttribute attribute) {
        return this.getAttribute(attribute, false);
    }

    public Object getAttribute(EAttribute attribute, boolean returnNullForDefault) {
        Object result = null;
        if (this.containerObject == null) {
            if (!returnNullForDefault) {
                result = attribute.getDefaultValue();
            }
        } else if (!returnNullForDefault || this.containerObject.eIsSet((EStructuralFeature)attribute)) {
            result = this.containerObject.eGet((EStructuralFeature)attribute);
        }
        return result;
    }

    public void setAttribute(EAttribute attribute, Object value) {
        this.setAttribute(attribute, value, true);
    }

    public void setAttribute(EAttribute attribute, Object value, boolean deleteSetAttr) {
        String defaultLiteral = attribute.getDefaultValueLiteral();
        String literal = value == null ? null : value.toString();
        boolean deleteAttr = literal == null || literal.isEmpty() || literal.equals(defaultLiteral) && deleteSetAttr;
        EObject container = (EObject)this.getContainerObject(true);
        if (deleteAttr) {
            container.eUnset((EStructuralFeature)attribute);
            if (this.parentContainer != null) {
                this.parentContainer.deleteContainerIfNecessary(this, this.reference);
            }
        } else {
            container.eSet((EStructuralFeature)attribute, value);
        }
    }

    @Override
    public boolean isDeleteAble() {
        boolean canDelete;
        if (this.containerObject == null) {
            return true;
        }
        boolean foundNonDefault = false;
        EClass eClass = this.getEClass();
        EList attributes = eClass.getEAllAttributes();
        for (EAttribute attribute : attributes) {
            Object defaultObject = attribute.getDefaultValue();
            String defaultValue = defaultObject == null ? null : defaultObject.toString();
            Object value = this.containerObject.eGet((EStructuralFeature)attribute);
            if (value == null || value.toString().equals(defaultValue)) continue;
            foundNonDefault = true;
            break;
        }
        boolean bl = canDelete = !foundNonDefault;
        if (canDelete) {
            for (EMFContainer child : this.children) {
                if (child.isDeleteAble()) continue;
                canDelete = false;
                break;
            }
        }
        return canDelete;
    }

    @Override
    public void addChild(EMFContainer childContainer) {
        this.children.add(childContainer);
    }

    @Override
    public void deleteContainerIfNecessary(EMFContainer containerToDelete, EReference deleteReference) {
        EObject container = (EObject)this.getContainerObject(false);
        if (container != null && containerToDelete.isDeleteAble()) {
            container.eUnset((EStructuralFeature)deleteReference);
            containerToDelete.setParentObject(null, true);
            if (this.parentContainer != null) {
                this.parentContainer.deleteContainerIfNecessary(this, this.reference);
            }
        }
    }

    @Override
    public TransactionalEditingDomain getDomain() {
        return this.domain;
    }
}

