/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.common.controls.emf.data;

import com.ibm.ccl.sca.internal.ui.common.controls.emf.data.EMFContainer;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.data.EMFReferenceContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class EMFCollectionContainer
implements EMFContainer {
    EMFContainer parentContainer;
    EReference reference;
    EList<EObject> containerObject;
    List<EMFContainer> children;
    Map<Object, EMFContainer> childMap;
    TransactionalEditingDomain domain;
    boolean canDeleteChildren;

    public EMFCollectionContainer(EMFContainer parentContainer, EReference reference, TransactionalEditingDomain domain) {
        this.parentContainer = parentContainer;
        this.reference = reference;
        this.children = new ArrayList<EMFContainer>();
        this.domain = domain;
        this.canDeleteChildren = true;
        this.childMap = new HashMap<Object, EMFContainer>();
        if (parentContainer != null) {
            parentContainer.addChild(this);
        }
    }

    public void setCanDeleteChildren(boolean canDeleteChildren) {
        this.canDeleteChildren = canDeleteChildren;
    }

    public EMFReferenceContainer findContainer(EObject eObject) {
        return (EMFReferenceContainer)this.childMap.get(eObject);
    }

    @Override
    public void addChild(EMFContainer childContainer) {
        this.children.add(childContainer);
    }

    public EMFContainer createEmptyChild() {
        return new EMFReferenceContainer(this, this.reference, this.domain);
    }

    public List<EObject> getChildren() {
        return this.containerObject == null ? new ArrayList<EObject>() : new ArrayList<EObject>((Collection<EObject>)this.containerObject);
    }

    public List<EMFContainer> getChildList() {
        return this.children;
    }

    public void removeChild(EObject objectToRemove) {
        EMFContainer childContainer = this.childMap.get(objectToRemove);
        this.children.remove(childContainer);
        this.containerObject.remove((Object)objectToRemove);
        this.childMap.remove(objectToRemove);
        if (this.children.size() == 0 && this.parentContainer != null) {
            this.parentContainer.deleteContainerIfNecessary(this, this.reference);
        }
    }

    @Override
    public void setParentObject(Object parentNode, boolean isRoot) {
        EObject parentObject = (EObject)parentNode;
        this.containerObject = parentNode == null ? null : (EList)parentObject.eGet((EStructuralFeature)this.reference);
        this.children.clear();
        this.childMap.clear();
        if (this.containerObject != null) {
            for (EObject childObject : this.containerObject) {
                EMFContainer newContainer = this.createEmptyChild();
                this.childMap.put(childObject, newContainer);
            }
        }
    }

    public void setParentForChildObjects() {
        for (Object childObject : this.childMap.keySet()) {
            EMFContainer childContainer = this.childMap.get(childObject);
            childContainer.setParentObject(childObject, true);
        }
    }

    @Override
    public Object getContainerObject(boolean create) {
        if (this.containerObject == null && create) {
            EClass eClass = (EClass)this.reference.getEType();
            Object parentObject = this.parentContainer.getContainerObject(true);
            EObjectContainmentEList newList = new EObjectContainmentEList(eClass.getInstanceClass(), (InternalEObject)parentObject, this.reference.getFeatureID());
            this.parentContainer.setReference(this.reference, newList, this);
            this.containerObject = (EList)((EObject)parentObject).eGet((EStructuralFeature)this.reference);
        }
        return this.containerObject;
    }

    @Override
    public void setReference(EReference childReference, Object value, EMFContainer childContainer) {
        EList childList = (EList)this.getContainerObject(true);
        childList.add(value);
        this.childMap.put(value, childContainer);
        if (!this.children.contains(childContainer)) {
            this.children.add(childContainer);
        }
    }

    @Override
    public boolean isDeleteAble() {
        return this.containerObject == null || this.containerObject.size() == 0;
    }

    @Override
    public void deleteContainerIfNecessary(EMFContainer containerToDelete, EReference deleteReference) {
        if (!this.canDeleteChildren) {
            return;
        }
        EList container = (EList)this.getContainerObject(false);
        if (this.reference == null || container == null) {
            return;
        }
        if (containerToDelete.isDeleteAble()) {
            this.removeChild((EObject)containerToDelete.getContainerObject(false));
            if (this.parentContainer != null) {
                this.parentContainer.deleteContainerIfNecessary(this, this.reference);
            }
        }
    }

    @Override
    public TransactionalEditingDomain getDomain() {
        return this.domain;
    }
}

