/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.common.controls.emf.data;

import com.ibm.ccl.sca.internal.ui.common.controls.emf.data.DataObject;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.data.EMFReferenceContainer;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.data.EMFUtil;
import com.ibm.ccl.sca.ui.plugin.SCAToolsUIPlugin;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.swt.events.ModifyListener;

public class EMFAttributeDataObject
implements DataObject {
    protected EMFReferenceContainer container;
    protected EAttribute attribute;
    private EDataType dataType;
    private EFactory factory;
    private List<ModifyListener> listeners;
    private boolean deleteSetAttr;

    public EMFAttributeDataObject(EMFReferenceContainer container, EAttribute attribute) {
        this(container, attribute, true);
    }

    public EMFAttributeDataObject(EMFReferenceContainer container, EAttribute attribute, boolean deleteSetAttr) {
        this.container = container;
        this.attribute = attribute;
        this.dataType = attribute.getEAttributeType();
        this.factory = this.dataType.getEPackage().getEFactoryInstance();
        this.deleteSetAttr = deleteSetAttr;
    }

    protected String convertObjectToString(Object object) {
        QName qname;
        String result = null;
        result = object instanceof QName ? ("http://www.osoa.org/xmlns/sca/1.0".equals((qname = (QName)object).getNamespaceURI()) ? qname.getLocalPart() : qname.toString()) : this.factory.convertToString(this.dataType, object);
        return result;
    }

    protected Object convertStringToObject(String stringValue) {
        Object value = null;
        try {
            value = this.factory.createFromString(this.dataType, stringValue);
        }
        catch (Exception exception) {
            value = null;
        }
        return value;
    }

    @Override
    public String getData() {
        Object object = this.container.getAttribute(this.attribute);
        String result = "";
        if (object != null) {
            result = this.convertObjectToString(object);
        }
        return result;
    }

    protected void setDataValue(String stringValue) {
        Object value = this.convertStringToObject(stringValue);
        this.container.setAttribute(this.attribute, value, this.deleteSetAttr);
        if (this.listeners != null) {
            for (ModifyListener listener : this.listeners) {
                listener.modifyText(null);
            }
        }
    }

    @Override
    public void setData(String stringValue) {
        try {
            this.getSetDataCommand(stringValue).execute(null, null);
        }
        catch (Exception exc) {
            SCAToolsUIPlugin.traceError(exc);
        }
    }

    private EditElementCommand getSetDataCommand(final String stringValue) {
        return new EditElementCommand("", null, (IEditCommandRequest)EMFUtil.createRequest(this.container)){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                EMFAttributeDataObject.this.setDataValue(stringValue);
                return CommandResult.newOKCommandResult();
            }
        };
    }

    @Override
    public void addModifyListener(ModifyListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ModifyListener>();
        }
        this.listeners.add(listener);
    }
}

