/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.common.controls.emf;

import com.ibm.ccl.sca.internal.ui.common.controls.emf.ControlWidget;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.DelayedModifyListener;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.EMFSection;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.data.DataObject;
import com.ibm.ccl.sca.ui.messages.Messages;
import com.ibm.ccl.sca.ui.util.EventTimer;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class TextFieldsWithBrowseControlWidget
implements ControlWidget {
    private DataObject data;
    private String[] names;
    private Text[] textFields;
    private EMFSection containingSection;
    private EventTimer timer;
    private Label label;
    private Button browseButton;
    private DelayedModifyListener listener;

    public TextFieldsWithBrowseControlWidget(String[] names, DataObject data, EventTimer timer) {
        this.names = names;
        this.data = data;
        this.timer = timer;
    }

    public Text[] getFields() {
        return this.textFields;
    }

    public EMFSection getContainingSection() {
        return this.containingSection;
    }

    @Override
    public void createControls(Composite parent, FormToolkit toolkit, EMFSection section) {
        this.containingSection = section;
        this.listener = new DelayedModifyListener(this.timer, this);
        this.textFields = new Text[this.names.length];
        int index = 0;
        while (index < this.names.length) {
            String name = this.names[index];
            this.label = toolkit.createLabel(parent, name);
            GridData griddata = new GridData(768);
            this.textFields[index] = toolkit.createText(parent, "");
            this.textFields[index].setLayoutData((Object)griddata);
            if (index == 0) {
                this.browseButton = toolkit.createButton(parent, Messages.TextFiedlsWithBrowseControlWidget_0, 8);
                this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TextFieldsWithBrowseControlWidget.this.handleBrowseButton();
                    }
                });
                griddata = new GridData();
                griddata.verticalSpan = this.names.length;
                this.browseButton.setLayoutData((Object)griddata);
            } else {
                toolkit.createLabel(parent, " ");
            }
            ++index;
        }
    }

    @Override
    public void dispose() {
        if (this.label != null) {
            this.label.dispose();
            this.label = null;
        }
        if (this.browseButton != null) {
            this.browseButton.dispose();
            this.browseButton = null;
        }
        if (this.textFields != null) {
            Text[] textArray = this.textFields;
            int n = this.textFields.length;
            int n2 = 0;
            while (n2 < n) {
                Text text = textArray[n2];
                text.dispose();
                ++n2;
            }
            this.textFields = null;
        }
    }

    protected abstract String combine(String[] var1);

    protected abstract String[] split(String var1);

    protected abstract void handleBrowseButton();

    @Override
    public void populateControl() {
        this.removeListeners();
        String[] values = this.split(this.data.getData());
        this.setValues(values);
        this.addListeners();
    }

    private void removeListeners() {
        Text[] textArray = this.textFields;
        int n = this.textFields.length;
        int n2 = 0;
        while (n2 < n) {
            Text field = textArray[n2];
            field.removeModifyListener((ModifyListener)this.listener);
            ++n2;
        }
    }

    private void addListeners() {
        Text[] textArray = this.textFields;
        int n = this.textFields.length;
        int n2 = 0;
        while (n2 < n) {
            Text field = textArray[n2];
            field.addModifyListener((ModifyListener)this.listener);
            ++n2;
        }
    }

    private String[] getValues() {
        String[] result = new String[this.textFields.length];
        int index = 0;
        while (index < this.textFields.length) {
            result[index] = this.textFields[index].getText();
            ++index;
        }
        return result;
    }

    private void setValues(String[] values) {
        int index = 0;
        while (index < this.textFields.length) {
            this.textFields[index].setText(values[index]);
            ++index;
        }
    }

    public void setText(String[] values) {
        this.removeListeners();
        this.setValues(values);
        this.update();
        this.addListeners();
    }

    @Override
    public void update() {
        this.data.setData(this.combine(this.getValues()));
    }
}

