/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.common.controls.emf;

import com.ibm.ccl.sca.internal.ui.common.controls.emf.ControlWidget;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.DelayedModifyListener;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.EMFSection;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.data.DataObject;
import com.ibm.ccl.sca.ui.util.EventTimer;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TextControlWidget
implements ControlWidget {
    private String name;
    private Text text;
    private Label label;
    protected EMFSection containingSection;
    private EventTimer timer;
    private DataObject data;
    private int colspan;
    private DelayedModifyListener listener;

    public TextControlWidget(String name, DataObject data, EventTimer timer) {
        this(name, data, timer, 1);
    }

    public TextControlWidget(String name, DataObject data, EventTimer timer, int colspan) {
        this.name = name;
        this.timer = timer;
        this.data = data;
        this.colspan = colspan;
    }

    @Override
    public void createControls(Composite parent, FormToolkit toolkit, EMFSection section) {
        this.containingSection = section;
        this.label = toolkit.createLabel(parent, this.name);
        GridData griddata = new GridData(768);
        griddata.horizontalSpan = this.colspan;
        this.text = toolkit.createText(parent, "");
        this.text.setLayoutData((Object)griddata);
        this.listener = new DelayedModifyListener(this.timer, this);
    }

    @Override
    public void dispose() {
        if (this.label != null) {
            this.label.dispose();
            this.label = null;
        }
        if (this.text != null) {
            this.text.dispose();
            this.text = null;
        }
    }

    @Override
    public void populateControl() {
        this.text.removeModifyListener((ModifyListener)this.listener);
        this.text.setText(this.data.getData());
        this.text.addModifyListener((ModifyListener)this.listener);
    }

    public void setText(String value) {
        this.text.removeModifyListener((ModifyListener)this.listener);
        this.text.setText(value);
        this.update();
        this.text.addModifyListener((ModifyListener)this.listener);
    }

    @Override
    public void update() {
        this.data.setData(this.text.getText());
    }
}

