/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.common.controls.emf;

import com.ibm.ccl.sca.internal.ui.common.controls.emf.AddItemToTableCommand;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.CellEditorsFactory;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.ControlWidget;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.EMFSection;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.EditTableCellCommand;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.RemoveItemFromTableCommand;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.StringTransform;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.data.ContainerListener;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.data.EMFAttributeDataObject;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.data.EMFCollectionContainer;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.data.EMFContainer;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.data.EMFReferenceContainer;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.data.EMFUtil;
import com.ibm.ccl.sca.ui.messages.Messages;
import com.ibm.ccl.sca.ui.plugin.SCAToolsUIPlugin;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TableControlWidget
implements ControlWidget {
    private EMFCollectionContainer listContainer;
    private String[] columnNames;
    private EAttribute[] columnAttrs;
    private int[] widths;
    private TableViewer tableViewer;
    private CellEditor[] cellEditors;
    private CellEditorsFactory cellFactory;
    private ContainerListener containerListener;

    public TableControlWidget(EMFCollectionContainer container, String[] columnNames, EAttribute[] columnAttrs, int[] widths) {
        this.listContainer = container;
        this.columnNames = columnNames;
        this.columnAttrs = columnAttrs;
        this.widths = widths;
        if (columnNames == null || columnAttrs == null || widths == null || columnNames.length != columnAttrs.length || columnNames.length != widths.length) {
            this.traceInvalidInput();
        }
    }

    @Override
    public void createControls(Composite parent, FormToolkit toolkit, EMFSection section) {
        Table table = this.createTable(parent, toolkit);
        this.createViewer(table);
        this.createButtons(parent, toolkit);
    }

    private Table createTable(Composite parent, FormToolkit toolkit) {
        int style = 68356;
        Table table = toolkit.createTable(parent, style);
        int cols = this.columnNames.length;
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gridData);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        int index = 0;
        while (index < cols) {
            TableColumn column = new TableColumn(table, 16384, index);
            column.setText(this.columnNames[index]);
            column.setWidth(this.widths[index]);
            ++index;
        }
        return table;
    }

    public void setNewContainerListener(ContainerListener containerListener) {
        this.containerListener = containerListener;
    }

    public void setCellEditorsFactory(CellEditorsFactory cellFactory) {
        this.cellFactory = cellFactory;
    }

    private void createCellEditors(Composite parent) {
        if (this.cellFactory != null) {
            this.cellEditors = this.cellFactory.createCellEditors(parent);
        } else {
            this.cellEditors = new CellEditor[this.columnNames.length];
            int index = 0;
            while (index < this.cellEditors.length) {
                this.cellEditors[index] = new TextCellEditor(parent);
                ++index;
            }
        }
    }

    private void createViewer(Table table) {
        this.createCellEditors((Composite)table);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setColumnProperties(this.getProperties());
        this.tableViewer.setCellEditors(this.cellEditors);
        this.tableViewer.setCellModifier((ICellModifier)new TextCellModifier());
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        TableViewerFocusCellManager cellManager = new TableViewerFocusCellManager(this.tableViewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.tableViewer));
        InternalColumnViewerEditorActivationStrategy strategy = new InternalColumnViewerEditorActivationStrategy((ColumnViewer)this.tableViewer);
        strategy.setEnableEditorActivationWithKeyboard(true);
        TableViewerEditor.create((TableViewer)this.tableViewer, (SWTFocusCellManager)cellManager, (ColumnViewerEditorActivationStrategy)strategy, (int)32);
    }

    private void createButtons(Composite parent, FormToolkit toolkit) {
        Composite buttonComposite = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        GridData griddata = new GridData();
        layout.numColumns = 1;
        layout.marginHeight = 20;
        layout.marginLeft = 0;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)griddata);
        Button addButton = toolkit.createButton(buttonComposite, Messages.TableControlWidget_0, 8);
        Button removeButton = toolkit.createButton(buttonComposite, Messages.TableControlWidget_1, 8);
        griddata = new GridData();
        griddata.horizontalAlignment = 4;
        griddata.grabExcessHorizontalSpace = true;
        addButton.setLayoutData((Object)griddata);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableControlWidget.this.handleAddButton();
            }
        });
        griddata = new GridData();
        griddata.horizontalAlignment = 0x1000000;
        removeButton.setLayoutData((Object)griddata);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableControlWidget.this.handleRemoveButton();
            }
        });
    }

    private void handleAddButton() {
        AddItemToTableCommand addCommand = new AddItemToTableCommand(this.listContainer, this.containerListener);
        try {
            addCommand.execute(null, null);
            List<EMFContainer> parentList = this.listContainer.getChildList();
            EMFContainer newItem = parentList.get(parentList.size() - 1);
            this.tableViewer.add((Object)newItem);
        }
        catch (Exception exc) {
            SCAToolsUIPlugin.traceError(exc);
        }
    }

    private void handleRemoveButton() {
        int removeIndex = this.tableViewer.getTable().getSelectionIndex();
        if (removeIndex != -1) {
            List<EMFContainer> parent = this.listContainer.getChildList();
            EMFContainer itemToRemove = parent.get(removeIndex);
            EObject objectToRemove = (EObject)itemToRemove.getContainerObject(false);
            RemoveItemFromTableCommand command = new RemoveItemFromTableCommand(this.listContainer, objectToRemove);
            command.run();
            this.tableViewer.remove((Object)itemToRemove);
        }
    }

    private String[] getProperties() {
        String[] props = new String[this.columnNames.length];
        int index = 0;
        while (index < props.length) {
            props[index] = "" + index;
            ++index;
        }
        return props;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void update() {
    }

    @Override
    public void populateControl() {
        this.listContainer.setParentForChildObjects();
        this.tableViewer.setInput(this.listContainer.getChildList());
    }

    private void traceInvalidInput() {
        try {
            throw new IllegalArgumentException("Invalid EMF table arguments specified.");
        }
        catch (IllegalArgumentException exc) {
            SCAToolsUIPlugin.traceError(exc);
            return;
        }
    }

    private String getCellValue(EMFReferenceContainer rowObject, int index) {
        EAttribute attr = this.columnAttrs[index];
        EMFAttributeDataObject attrObject = new EMFAttributeDataObject(rowObject, attr);
        return attrObject.getData();
    }

    private class InternalColumnViewerEditorActivationStrategy
    extends ColumnViewerEditorActivationStrategy {
        public InternalColumnViewerEditorActivationStrategy(ColumnViewer viewer) {
            super(viewer);
        }

        protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
            char ch = event.character;
            return super.isEditorActivationEvent(event) || ch == ' ' || ch == '\r';
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                List parent = (List)inputElement;
                return parent.toArray(new EMFReferenceContainer[0]);
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            if (element instanceof EMFReferenceContainer) {
                result = TableControlWidget.this.getCellValue((EMFReferenceContainer)element, columnIndex);
            }
            return result;
        }
    }

    private class TextCellModifier
    implements ICellModifier {
        private TextCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            Object result = null;
            if (element != null && element instanceof EMFReferenceContainer) {
                int colIndex = this.getIndex(property);
                String stringValue = TableControlWidget.this.getCellValue((EMFReferenceContainer)element, colIndex);
                result = TableControlWidget.this.cellEditors[colIndex] instanceof StringTransform ? ((StringTransform)TableControlWidget.this.cellEditors[colIndex]).ObjectFromString(stringValue) : stringValue;
            }
            return result == null ? "" : result;
        }

        public void modify(Object element, String property, Object value) {
            EMFReferenceContainer rowObject = (EMFReferenceContainer)((TableItem)element).getData();
            int index = this.getIndex(property);
            EAttribute attr = TableControlWidget.this.columnAttrs[index];
            EditTableCellCommand command = new EditTableCellCommand(EMFUtil.createRequest(TableControlWidget.this.listContainer), TableControlWidget.this.tableViewer, rowObject);
            CellEditor editor = TableControlWidget.this.cellEditors[index];
            if (editor instanceof StringTransform) {
                value = ((StringTransform)editor).StringFromObject(value);
            }
            command.init(attr, (String)value);
            command.run();
        }

        private int getIndex(String property) {
            int result = 0;
            try {
                result = Integer.parseInt(property);
            }
            catch (NumberFormatException exc) {
                SCAToolsUIPlugin.traceError(exc);
            }
            return result;
        }
    }
}

