/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.common.controls.emf;

import com.ibm.ccl.sca.internal.ui.common.controls.emf.ControlWidget;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.EMFSection;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.data.EMFContainer;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.data.EMFUtil;
import com.ibm.ccl.sca.ui.plugin.SCAToolsUIPlugin;
import com.ibm.ccl.sca.ui.util.UIUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class ElementComboControlWidget
implements ControlWidget {
    protected EReference[] refs;
    private String[] itemNames;
    private EMFContainer container;
    private String name;
    private CCombo combo;
    private EMFSection containingSection;
    private List<SelectionListener> listeners;
    private int colspan;
    private ElementSelectionListener listener;

    public ElementComboControlWidget(String name, String[] itemNames, EReference[] refs, EMFContainer container) {
        this.name = name;
        this.refs = refs;
        this.itemNames = itemNames;
        this.listeners = new ArrayList<SelectionListener>();
        this.colspan = 1;
        this.container = container;
    }

    public void setColspan(int colspan) {
        this.colspan = colspan;
    }

    public void setEnabled(boolean enabled) {
        this.combo.setEnabled(enabled);
    }

    @Override
    public void createControls(Composite parent, FormToolkit toolkit, EMFSection section) {
        int comboStyle = 0x800000;
        this.containingSection = section;
        toolkit.createLabel(parent, this.name);
        GridData griddata = new GridData(770);
        griddata.horizontalSpan = this.colspan;
        this.combo = UIUtils.createCCombo(toolkit, parent, comboStyle);
        this.combo.setEditable(false);
        this.combo.setLayoutData((Object)griddata);
        this.listener = new ElementSelectionListener();
        String[] stringArray = this.itemNames;
        int n = this.itemNames.length;
        int n2 = 0;
        while (n2 < n) {
            String itemName = stringArray[n2];
            this.combo.add(itemName == null ? "" : itemName);
            ++n2;
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.listeners.add(listener);
    }

    public int getSelectionIndex() {
        return this.combo.getSelectionIndex();
    }

    @Override
    public void dispose() {
        if (this.combo != null) {
            this.combo.dispose();
            this.combo = null;
        }
    }

    private Object getParentObject() {
        return this.container.getContainerObject(false);
    }

    @Override
    public void populateControl() {
        int itemIndex = -1;
        Object thisObject = this.getParentObject();
        if (thisObject != null) {
            int index = 0;
            while (index < this.refs.length) {
                if (this.refs[index] != null) {
                    Object objRef = null;
                    int size = 1;
                    if (thisObject instanceof BasicFeatureMap) {
                        if (((BasicFeatureMap)thisObject).size((EStructuralFeature)this.refs[index]) == 1) {
                            itemIndex = index;
                            break;
                        }
                    } else if (thisObject instanceof EObject) {
                        objRef = ((EObject)thisObject).eGet((EStructuralFeature)this.refs[index]);
                    }
                    if (objRef instanceof Collection) {
                        size = ((Collection)objRef).size();
                    }
                    if (objRef != null && size == 1) {
                        itemIndex = index;
                        break;
                    }
                }
                ++index;
            }
        }
        this.combo.removeSelectionListener((SelectionListener)this.listener);
        this.combo.setText(itemIndex == -1 ? "" : this.itemNames[itemIndex]);
        this.combo.addSelectionListener((SelectionListener)this.listener);
    }

    public String getText() {
        return this.combo.getText();
    }

    public abstract void updateModel(EMFSection var1, int var2);

    private EditElementCommand getUpdateCommand() {
        return new UpdateModelCommand(EMFUtil.createRequest(this.container));
    }

    @Override
    public void update() {
        try {
            this.getUpdateCommand().execute(null, null);
            for (SelectionListener anotherListener : this.listeners) {
                anotherListener.widgetSelected(null);
            }
        }
        catch (Exception e) {
            SCAToolsUIPlugin.traceError(e);
        }
    }

    private class ElementSelectionListener
    extends SelectionAdapter {
        private ElementSelectionListener() {
        }

        public void widgetSelected(SelectionEvent evt) {
            ElementComboControlWidget.this.update();
        }
    }

    private class UpdateModelCommand
    extends EditElementCommand {
        public UpdateModelCommand(SetRequest request) {
            super("", null, (IEditCommandRequest)request);
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            int index = ElementComboControlWidget.this.combo.getSelectionIndex();
            ElementComboControlWidget.this.updateModel(ElementComboControlWidget.this.containingSection, index);
            return CommandResult.newOKCommandResult();
        }
    }
}

