/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.common.controls.emf;

import com.ibm.ccl.sca.internal.ui.common.controls.emf.ControlWidget;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;

public class EMFSection {
    protected FormToolkit toolkit;
    protected String sectionName;
    protected List<ButtonInfo> buttonList;
    protected List<ControlWidget> fieldList;
    protected List<EMFSection> sectionList;
    protected EMFSection parentSection;
    protected Section section;
    protected ButtonInfo rightButton;
    protected int columns;

    public EMFSection(FormToolkit toolkit) {
        this.toolkit = toolkit;
        this.buttonList = new ArrayList<ButtonInfo>();
        this.fieldList = new ArrayList<ControlWidget>();
        this.sectionList = new ArrayList<EMFSection>();
        this.columns = 2;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public Section getSection() {
        return this.section;
    }

    public void setParentSection(EMFSection parentSection) {
        this.parentSection = parentSection;
    }

    public void setSectionName(String sectionName) {
        this.sectionName = sectionName;
    }

    public void addWidget(ControlWidget widget) {
        this.fieldList.add(widget);
    }

    public void addSection(EMFSection section, String buttonName, SelectionListener listener) {
        section.setParentSection(this);
        if (buttonName != null && listener != null) {
            section.rightButton = new ButtonInfo(buttonName, listener);
        }
        this.sectionList.add(section);
    }

    public void addSection(EMFSection section) {
        this.addSection(section, null, null);
    }

    public void addButton(String name, SelectionListener listener) {
        this.buttonList.add(new ButtonInfo(name, listener));
    }

    public void disposeChildren() {
        for (ControlWidget field : this.fieldList) {
            field.dispose();
        }
        for (ButtonInfo button : this.buttonList) {
            if (button.button == null) continue;
            button.button.dispose();
            button.button = null;
        }
        if (this.rightButton != null && this.rightButton.button != null) {
            this.rightButton.button.dispose();
            this.rightButton.button = null;
        }
        for (EMFSection section : this.sectionList) {
            section.disposeChildren();
            if (section.section == null) continue;
            section.section.dispose();
            section.section = null;
        }
    }

    protected Composite createHeaderSection(Composite parent) {
        Composite mainComp = parent;
        GridData griddata = null;
        if (this.sectionName != null) {
            this.section = this.toolkit.createSection(parent, 18);
            GridLayout layout = new GridLayout();
            layout.numColumns = this.columns;
            griddata = new GridData(4, 4, true, false);
            griddata.horizontalSpan = this.rightButton == null ? 2 : 1;
            this.section.setText(this.sectionName);
            this.section.setLayoutData((Object)griddata);
            if (this.rightButton != null) {
                this.createButton(this.rightButton, parent);
                griddata = new GridData();
                griddata.verticalAlignment = 1;
                this.rightButton.button.setLayoutData((Object)griddata);
            }
            mainComp = this.toolkit.createComposite((Composite)this.section);
            this.toolkit.paintBordersFor(mainComp);
            layout.numColumns = this.columns;
            mainComp.setLayout((Layout)layout);
            this.section.setClient((Control)mainComp);
        }
        return mainComp;
    }

    protected void createChildSections(Composite sectionClient) {
        for (ControlWidget field : this.fieldList) {
            field.createControls(sectionClient, this.toolkit, this);
        }
        for (EMFSection section : this.sectionList) {
            section.createControls(sectionClient);
        }
        for (ButtonInfo buttonInfo : this.buttonList) {
            this.createButton(buttonInfo, sectionClient);
        }
    }

    public void createControls(Composite parent) {
        Composite sectionClient = this.createHeaderSection(parent);
        this.createChildSections(sectionClient);
    }

    public void populateControls() {
        for (ControlWidget field : this.fieldList) {
            field.populateControl();
        }
        for (EMFSection section : this.sectionList) {
            section.populateControls();
        }
    }

    public int getColumns() {
        return this.columns;
    }

    public void reflow() {
        Section comp = this.section;
        while (comp != null) {
            comp.setRedraw(false);
            comp = comp.getParent();
            if (comp instanceof SharedScrolledComposite) break;
        }
        for (comp = this.section; comp != null; comp = comp.getParent()) {
            comp.layout(true);
            if (!(comp instanceof SharedScrolledComposite)) continue;
            ((SharedScrolledComposite)comp).reflow(true);
            break;
        }
        comp = this.section;
        while (comp != null) {
            comp.setRedraw(true);
            comp = comp.getParent();
            if (comp instanceof SharedScrolledComposite) break;
        }
    }

    private void createButton(ButtonInfo buttonInfo, Composite parent) {
        Button newButton = this.toolkit.createButton(parent, buttonInfo.name, 8);
        newButton.addSelectionListener(buttonInfo.listener);
        buttonInfo.button = newButton;
    }

    private class ButtonInfo {
        public String name;
        public SelectionListener listener;
        public Button button;

        public ButtonInfo(String name, SelectionListener listener) {
            this.name = name;
            this.listener = listener;
        }
    }
}

