/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.common.controls.emf;

import com.ibm.ccl.sca.internal.ui.common.controls.emf.EMFContainerSection;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.EMFSection;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.SectionFactory;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.UpdateElementFromListCommand;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.data.EMFCollectionContainer;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class EMFListSection
extends EMFSection {
    private SectionFactory sectionFactory;
    private boolean creatingSection;
    private EMFCollectionContainer container;

    public EMFListSection(FormToolkit toolkit, SectionFactory sectionFactory, EMFCollectionContainer container, String sectionName) {
        super(toolkit);
        this.sectionFactory = sectionFactory;
        this.sectionName = sectionName;
        this.creatingSection = false;
        this.container = container;
        container.setCanDeleteChildren(false);
    }

    @Override
    public void createControls(Composite parent) {
        this.createHeaderSection(parent);
    }

    @Override
    public void populateControls() {
        this.disposeChildren();
        List<EObject> childList = this.container.getChildren();
        if (!this.creatingSection) {
            this.sectionList.clear();
        }
        if (childList != null && !this.creatingSection && this.sectionList.size() != childList.size()) {
            for (EObject child : childList) {
                this.createSection(child);
            }
            this.container.setParentForChildObjects();
        }
        if (this.buttonList.size() == 0) {
            this.addButton(" + ", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EMFListSection.this.addSection();
                }
            });
        }
        super.createChildSections((Composite)this.section.getClient());
        super.populateControls();
        this.reflow();
    }

    private void createSection(EObject emfObject) {
        final EMFContainerSection newSection = this.sectionFactory.create(emfObject);
        this.addSection(newSection, " - ", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EMFListSection.this.removeSection(newSection);
            }
        });
    }

    private void addSection() {
        this.createSection(null);
        this.creatingSection = true;
        this.populateControls();
        this.creatingSection = false;
    }

    private void removeSection(EMFContainerSection section) {
        section.disposeChildren();
        section.section.dispose();
        this.sectionList.remove(section);
        this.reflow();
        UpdateElementFromListCommand command = new UpdateElementFromListCommand((EObject)section.getContainer().getContainerObject(false), this.container);
        try {
            command.execute(null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

