/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.common.controls.emf;

import com.ibm.ccl.sca.core.model.ISCAComposite;
import com.ibm.ccl.sca.internal.ui.common.controls.CompositeSelectionControlFactory;
import com.ibm.ccl.sca.internal.ui.common.controls.ICompositeSelectionDialog;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.TextFieldsWithBrowseControlWidget;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.data.DataObject;
import com.ibm.ccl.sca.ui.messages.Messages;
import com.ibm.ccl.sca.ui.util.EventTimer;
import javax.xml.namespace.QName;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CompositeSelectionControlWidget
extends TextFieldsWithBrowseControlWidget {
    public CompositeSelectionControlWidget(DataObject data, EventTimer timer) {
        super(new String[]{Messages.CompositeSelectionControlWidget_0, Messages.CompositeSelectionControlWidget_1}, data, timer);
    }

    @Override
    protected String combine(String[] values) {
        QName qname = new QName(values[0], values[1]);
        return qname.toString();
    }

    public void configureDialog(ICompositeSelectionDialog dialog) {
        dialog.initialize();
    }

    @Override
    protected void handleBrowseButton() {
        Shell topShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ICompositeSelectionDialog selectDialog = CompositeSelectionControlFactory.createCompositeSelectionDialogWithSingleSelectTree(topShell);
        this.configureDialog(selectDialog);
        int result = selectDialog.open();
        if (result == 0) {
            ISCAComposite compositeSelected = selectDialog.getSelectedComposites().get(0);
            QName qname = compositeSelected.getName();
            String namespace = qname.getNamespaceURI();
            String localpart = qname.getLocalPart();
            this.setText(new String[]{namespace == null ? "" : namespace, localpart == null ? "" : localpart});
        }
    }

    @Override
    protected String[] split(String value) {
        if (value == null || value.trim().equals("")) {
            return new String[]{"", ""};
        }
        EDataType datatype = CompositeSelectionControlWidget.getQnameType();
        EFactory factory = datatype.getEPackage().getEFactoryInstance();
        QName qname = (QName)factory.createFromString(datatype, value);
        String namespace = qname.getNamespaceURI();
        String localpart = qname.getLocalPart();
        return new String[]{namespace == null ? "" : namespace, localpart == null ? "" : localpart};
    }

    private static EDataType getQnameType() {
        return ((XMLTypePackage)EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/emf/2003/XMLType")).getQName();
    }
}

