/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.common.controls.emf;

import com.ibm.ccl.sca.internal.ui.common.controls.emf.ControlWidget;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.DelayedModifyListener;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.EMFSection;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.data.DataObject;
import com.ibm.ccl.sca.ui.util.EventTimer;
import com.ibm.ccl.sca.ui.util.UIUtils;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AbstractComboControlWidget
implements ControlWidget {
    private DataObject data;
    private String name;
    private CCombo combo;
    private boolean readOnly;
    private EventTimer timer;
    private Label label;
    private int colSpan;
    private DelayedModifyListener textListener;

    public AbstractComboControlWidget(String name, DataObject data, boolean readOnly, EventTimer timer) {
        this.name = name;
        this.data = data;
        this.readOnly = readOnly;
        this.timer = timer;
        this.colSpan = 1;
    }

    protected abstract String[] getComboItems();

    public void setColspan(int span) {
        this.colSpan = span;
    }

    @Override
    public void createControls(Composite parent, FormToolkit toolkit, EMFSection section) {
        this.label = toolkit.createLabel(parent, this.name);
        GridData griddata = new GridData(770);
        griddata.horizontalSpan = this.colSpan;
        this.combo = UIUtils.createCCombo(toolkit, parent, 0x800000);
        this.combo.setEditable(!this.readOnly);
        this.combo.setLayoutData((Object)griddata);
        this.textListener = new DelayedModifyListener(this.timer, this);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractComboControlWidget.this.update();
            }
        });
    }

    public CCombo getCombo() {
        return this.combo;
    }

    @Override
    public void dispose() {
        if (this.label != null) {
            this.label.dispose();
            this.label = null;
        }
        if (this.combo != null) {
            this.combo.dispose();
            this.combo = null;
        }
    }

    @Override
    public void populateControl() {
        this.combo.removeModifyListener((ModifyListener)this.textListener);
        this.combo.removeAll();
        this.combo.setText(this.data.getData());
        String[] stringArray = this.getComboItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String comboItem = stringArray[n2];
            this.combo.add(comboItem);
            ++n2;
        }
        this.combo.addModifyListener((ModifyListener)this.textListener);
    }

    public int getSelectionIndex() {
        return this.combo.getSelectionIndex();
    }

    @Override
    public void update() {
        this.data.setData(this.combo.getText());
    }
}

