/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.common.controls;

import com.ibm.ccl.sca.core.model.ISCAArtifact;
import com.ibm.ccl.sca.core.model.ISCAComposite;
import com.ibm.ccl.sca.core.model.ISCAFilter;
import com.ibm.ccl.sca.core.model.ISCAProject;
import com.ibm.ccl.sca.core.model.SCAModelManager;
import com.ibm.ccl.sca.internal.ui.navigator.node.NamespaceNode;
import com.ibm.ccl.sca.ui.messages.Messages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class CompositeTreeGroup
extends EventManager
implements ITreeViewerListener {
    protected Object root;
    protected ITreeContentProvider treeContentProvider;
    protected IBaseLabelProvider treeLabelProvider;
    protected ISelectionChangedListener selectionListener;
    protected TreeViewer treeViewer;
    protected static int PREFERRED_HEIGHT = 160;
    protected Object[] currentSelections;
    protected HashMap<String, Integer> duplicatesMap = new HashMap();
    private Composite parent;
    private int treeStyle;
    private boolean useHeightHint;
    private List<QName> allQnames = new ArrayList<QName>();
    private List<QName> qNamesToIgnore = null;

    protected CompositeTreeGroup(Composite parent, Object rootObject, int treeStyle, boolean useHeightHint) {
        this.parent = parent;
        this.root = rootObject;
        this.treeStyle = treeStyle;
        this.useHeightHint = useHeightHint;
    }

    protected void createContents(Composite parent, int treeStyle, boolean useHeightHint) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createTreeViewer(composite, treeStyle, useHeightHint);
    }

    public void initialize() {
        if (this.treeContentProvider == null) {
            this.treeContentProvider = this.getResourceProvider();
        }
        if (this.treeLabelProvider == null) {
            this.treeLabelProvider = new DecoratorLabelProvider();
        }
        if (this.selectionListener == null) {
            this.selectionListener = new TreeSelectionListener();
        }
        this.createContents(this.parent, this.treeStyle, this.useHeightHint);
        this.treeViewer.setInput(this.root);
    }

    public int getItemsCount() {
        if (this.qNamesToIgnore != null) {
            this.allQnames.removeAll(this.qNamesToIgnore);
        }
        return this.allQnames.size();
    }

    protected void setIgnoredQNames(List<QName> qnames) {
        this.qNamesToIgnore = qnames;
    }

    protected void createTreeViewer(Composite parent, int treeStyle, boolean useHeightHint) {
        Tree tree = new Tree(parent, treeStyle);
        GridData data = new GridData(1808);
        if (useHeightHint) {
            data.heightHint = PREFERRED_HEIGHT;
        }
        tree.setLayoutData((Object)data);
        tree.setFont(parent.getFont());
        this.treeViewer = new TreeViewer(tree);
        this.treeViewer.setContentProvider((IContentProvider)this.treeContentProvider);
        this.treeViewer.setLabelProvider(this.treeLabelProvider);
        this.treeViewer.setComparator(new ViewerComparator());
        this.treeViewer.addTreeListener((ITreeViewerListener)this);
        if (this.selectionListener != null) {
            this.treeViewer.addSelectionChangedListener(this.selectionListener);
        }
    }

    public void setTreeProviders(ITreeContentProvider contentProvider, ILabelProvider labelProvider) {
        this.treeViewer.setContentProvider((IContentProvider)contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    public void addListener(Object listener) {
        this.addListenerObject(listener);
        if (listener instanceof ISelectionChangedListener) {
            ISelectionChangedListener selectionChangedListener = (ISelectionChangedListener)listener;
            this.treeViewer.addSelectionChangedListener(selectionChangedListener);
        }
    }

    public void removeListener(Object listener) {
        this.removeListenerObject(listener);
    }

    protected void notifyCheckStateChangeListeners(final CheckStateChangedEvent event) {
        Object[] array = this.getListeners();
        int i = 0;
        while (i < array.length) {
            final ICheckStateListener l = (ICheckStateListener)array[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.checkStateChanged(event);
                }
            });
            ++i;
        }
    }

    public void collapseAll() {
        this.treeViewer.collapseAll();
    }

    public void treeCollapsed(TreeExpansionEvent event) {
    }

    public void treeExpanded(TreeExpansionEvent event) {
    }

    public void setFocus() {
        this.treeViewer.getTree().setFocus();
    }

    public void setRoot(Object newRoot) {
        this.root = newRoot;
        this.treeViewer.setInput(this.root);
    }

    public void expandAll() {
        this.treeViewer.expandAll();
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public List<ISCAComposite> getSelectedComposites() {
        ArrayList<ISCAComposite> composites = new ArrayList<ISCAComposite>();
        if (this.currentSelections == null) {
            return composites;
        }
        Object[] objectArray = this.currentSelections;
        int n = this.currentSelections.length;
        int n2 = 0;
        while (n2 < n) {
            Object compositeFile = objectArray[n2];
            ISCAComposite composite = null;
            if (compositeFile instanceof IFile) {
                composite = (ISCAComposite)((IFile)compositeFile).getAdapter(ISCAArtifact.class);
            }
            if (composite != null) {
                composites.add(composite);
            }
            ++n2;
        }
        return composites;
    }

    public List<Object> getSelected() {
        if (this.currentSelections == null) {
            return ((IStructuredSelection)this.treeViewer.getSelection()).toList();
        }
        ArrayList<Object> results = new ArrayList<Object>();
        Object[] objectArray = this.currentSelections;
        int n = this.currentSelections.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            results.add(obj);
            ++n2;
        }
        return results;
    }

    public boolean isNothingSelected() {
        return this.getSelectedComposites().isEmpty();
    }

    public void initialSelection(Object element) {
    }

    protected ITreeContentProvider getResourceProvider() {
        return new WorkbenchContentProvider(){
            private Map<IProject, Map<String, NamespaceNode>> allNamespaceNodes = new Hashtable<IProject, Map<String, NamespaceNode>>();

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput instanceof List) {
                    for (Object item : (List)newInput) {
                        if (!(item instanceof IProject)) continue;
                        Hashtable<String, NamespaceNode> namespaceNodes = new Hashtable<String, NamespaceNode>();
                        String projectName = ((IProject)item).getName();
                        ISCAProject currentSCAProject = SCAModelManager.getLoadedProject((IProject)((IProject)item));
                        for (ISCAComposite scaComposite : SCAModelManager.getComposites((ISCAProject)currentSCAProject)) {
                            String key;
                            Integer integer;
                            String compositeName = scaComposite.getResource().getName();
                            if (scaComposite.getName() != null) {
                                compositeName = scaComposite.getLogicalName();
                            }
                            integer = (integer = CompositeTreeGroup.this.duplicatesMap.get(key = String.valueOf(projectName) + "-" + compositeName)) == null ? new Integer(1) : new Integer(integer + 1);
                            CompositeTreeGroup.this.duplicatesMap.put(key, integer);
                            String namespace = scaComposite.getName().getNamespaceURI();
                            NamespaceNode namespaceNode = (NamespaceNode)namespaceNodes.get(namespace);
                            if (namespaceNode == null) {
                                namespaceNode = new NamespaceNode(item, namespace);
                                namespaceNodes.put(namespace, namespaceNode);
                            }
                            namespaceNode.addChild(scaComposite.getResource());
                            CompositeTreeGroup.this.allQnames.add(scaComposite.getName());
                        }
                        this.allNamespaceNodes.put((IProject)item, namespaceNodes);
                    }
                }
            }

            public Object getParent(Object element) {
                Object adapted;
                Map<String, NamespaceNode> namespaceNodes;
                if (element instanceof IFile && (namespaceNodes = this.allNamespaceNodes.get(((IFile)element).getProject())) != null && (adapted = ((IFile)element).getAdapter(ISCAArtifact.class)) instanceof ISCAComposite) {
                    ISCAComposite composite = (ISCAComposite)adapted;
                    QName qName = composite.getName();
                    String namespace = qName.getNamespaceURI();
                    return namespaceNodes.get(namespace);
                }
                return super.getParent(element);
            }

            public Object[] getChildren(Object o) {
                Map<String, NamespaceNode> namespaceNodes;
                if (o instanceof IProject && (namespaceNodes = this.allNamespaceNodes.get((IProject)o)) != null) {
                    return namespaceNodes.values().toArray();
                }
                if (o instanceof NamespaceNode) {
                    return ((NamespaceNode)o).getChildren();
                }
                if (o instanceof ArrayList) {
                    return ((ArrayList)o).toArray();
                }
                return new Object[0];
            }
        };
    }

    public final void shutdown() {
        if (this.treeViewer.getLabelProvider() instanceof DecoratorLabelProvider) {
            ((DecoratorLabelProvider)this.treeViewer.getLabelProvider()).shutdown();
        }
    }

    public void setTreeContentProvider(ITreeContentProvider treeContentProvider) {
        this.treeContentProvider = treeContentProvider;
        if (this.treeViewer != null) {
            this.treeViewer.setContentProvider((IContentProvider)treeContentProvider);
        }
    }

    public void setTreeLabelProvider(IBaseLabelProvider treeLabelProvider) {
        this.treeLabelProvider = treeLabelProvider;
        if (this.treeViewer != null) {
            this.treeViewer.setLabelProvider(treeLabelProvider);
        }
    }

    public void setSelectionListener(ISelectionChangedListener selectionListener) {
        ISelectionChangedListener oldListener = this.selectionListener;
        this.selectionListener = selectionListener;
        if (this.treeViewer != null) {
            if (oldListener != null) {
                this.treeViewer.removeSelectionChangedListener(oldListener);
            }
            this.treeViewer.addSelectionChangedListener(selectionListener);
        }
    }

    public void setRootObject(Object root) {
        this.root = root;
    }

    protected class DecoratorLabelProvider
    extends StyledCellLabelProvider
    implements IColorProvider,
    IFontProvider,
    DelegatingStyledCellLabelProvider.IStyledLabelProvider,
    ILabelProvider {
        private String pathSeparator = "-";
        private ResourceUtil resourceUtil;

        protected DecoratorLabelProvider() {
        }

        private String decorateText(String input, Object element) {
            if (element instanceof IFile) {
                IFile file = (IFile)element;
                return String.valueOf(input) + " " + this.pathSeparator + " " + file.getFullPath().toString();
            }
            return input;
        }

        private ImageDescriptor decorateImage(ImageDescriptor input, Object element) {
            return input;
        }

        public final Image getImage(Object element) {
            Image image;
            IWorkbenchAdapter adapter = this.getAdapter(element);
            if (adapter == null) {
                return null;
            }
            ImageDescriptor descriptor = adapter.getImageDescriptor(element);
            if (descriptor == null) {
                return null;
            }
            descriptor = this.decorateImage(descriptor, element);
            if (this.resourceUtil == null) {
                this.resourceUtil = new ResourceUtil();
            }
            if ((image = (Image)this.resourceUtil.getImageTable().get(descriptor)) == null) {
                image = descriptor.createImage();
                this.resourceUtil.getImageTable().put(descriptor, image);
            }
            return image;
        }

        private final IWorkbenchAdapter getAdapter(Object o) {
            return (IWorkbenchAdapter)this.getAdapter(o, IWorkbenchAdapter.class);
        }

        public void update(ViewerCell cell) {
            Object theElement = cell.getElement();
            StyledString styledString = this.getStyledText(theElement);
            cell.setText(styledString.getString());
            cell.setStyleRanges(styledString.getStyleRanges());
            cell.setImage(this.getImage(theElement));
            cell.setFont(this.getFont(theElement));
            cell.setForeground(this.getForeground(theElement));
            cell.setBackground(this.getBackground(theElement));
            super.update(cell);
        }

        public StyledString getStyledText(Object element) {
            StyledString styledString;
            String string = this.getText(element);
            if (this.isDuplicate(element) || this.isSelected(element)) {
                string = this.decorateText(string, element);
                styledString = new StyledString(string);
                int i = string.indexOf(this.pathSeparator);
                if (i != -1) {
                    styledString.setStyle(i, string.length() - i, StyledString.QUALIFIER_STYLER);
                }
            } else {
                styledString = new StyledString(string);
            }
            return styledString;
        }

        private boolean isSelected(Object element) {
            if (CompositeTreeGroup.this.currentSelections != null && element != null) {
                int index = 0;
                while (index < CompositeTreeGroup.this.currentSelections.length) {
                    if (element.equals(CompositeTreeGroup.this.currentSelections[index])) {
                        return true;
                    }
                    ++index;
                }
            }
            return false;
        }

        private boolean isDuplicate(Object element) {
            if (element instanceof IFile) {
                IFile file = (IFile)element;
                IProject project = file.getProject();
                ISCAProject currentSCAProject = SCAModelManager.getLoadedProject((IProject)project);
                for (ISCAComposite scaComposite : SCAModelManager.getComposites((ISCAProject)currentSCAProject)) {
                    String key;
                    Integer integer;
                    ISCAComposite theComposite = (ISCAComposite)file.getAdapter(ISCAArtifact.class);
                    if (!theComposite.getLogicalName().equals(scaComposite.getLogicalName())) continue;
                    String compositeName = null;
                    if (scaComposite != null && scaComposite.getName() != null) {
                        compositeName = scaComposite.getLogicalName();
                    }
                    if ((integer = CompositeTreeGroup.this.duplicatesMap.get(key = String.valueOf(file.getProject().getName()) + "-" + compositeName)) <= 1) continue;
                    return true;
                }
            }
            return false;
        }

        public final String getText(Object element) {
            ISCAComposite scaComposite;
            IFile theFile;
            ISCAProject scaProject;
            List composites;
            IWorkbenchAdapter adapter = this.getAdapter(element);
            if (adapter == null) {
                return "";
            }
            String label = adapter.getLabel(element);
            if (label.endsWith(".composite") && element instanceof IFile && (composites = SCAModelManager.getComposites((ISCAProject)(scaProject = SCAModelManager.getLoadedProject((IProject)(theFile = (IFile)element).getProject())), (ISCAFilter)new ISCAFilter<ISCAComposite>(){

                public boolean accept(ISCAComposite composite) {
                    return composite.getResource().equals((Object)theFile);
                }
            })).size() > 0 && (scaComposite = (ISCAComposite)composites.get(0)).getName() != null && (label = URI.decode((String)scaComposite.getName().getLocalPart())).length() == 0) {
                label = Messages.LABEL_UNNAMED;
            }
            return label;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Font getFont(Object element) {
            return null;
        }

        public Object getAdapter(Object sourceObject, Class<IWorkbenchAdapter> adapterType) {
            Object result;
            IAdaptable adaptable;
            Object result2;
            Assert.isNotNull(adapterType);
            if (sourceObject == null) {
                return null;
            }
            if (adapterType.isInstance(sourceObject)) {
                return sourceObject;
            }
            if (sourceObject instanceof IAdaptable && (result2 = (adaptable = (IAdaptable)sourceObject).getAdapter(adapterType)) != null) {
                Assert.isTrue((boolean)adapterType.isInstance(result2));
                return result2;
            }
            if (!(sourceObject instanceof PlatformObject) && (result = Platform.getAdapterManager().getAdapter(sourceObject, adapterType)) != null) {
                return result;
            }
            return null;
        }

        public final void shutdown() {
            if (this.resourceUtil != null) {
                this.resourceUtil.shutdown();
            }
        }

        public void dispose() {
            this.shutdown();
            super.dispose();
        }

        private class ResourceUtil {
            private Map<Object, Object> imageTable = new Hashtable<Object, Object>(40);

            private ResourceUtil() {
            }

            private final void shutdown() {
                if (this.imageTable != null) {
                    Iterator<Object> i = this.imageTable.values().iterator();
                    while (i.hasNext()) {
                        ((Image)i.next()).dispose();
                    }
                    this.imageTable = null;
                }
            }

            private Map<Object, Object> getImageTable() {
                return this.imageTable;
            }
        }
    }

    private class TreeSelectionListener
    implements ISelectionChangedListener {
        private TreeSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object[] oldSelections = CompositeTreeGroup.this.currentSelections;
            if (event.getSelection() instanceof StructuredSelection) {
                CompositeTreeGroup.this.currentSelections = ((StructuredSelection)event.getSelection()).toArray();
            }
            if (oldSelections != null && oldSelections.length > 0) {
                CompositeTreeGroup.this.getTreeViewer().update(oldSelections, null);
            }
            if (CompositeTreeGroup.this.currentSelections != null && CompositeTreeGroup.this.currentSelections.length > 0) {
                CompositeTreeGroup.this.getTreeViewer().update(CompositeTreeGroup.this.currentSelections, null);
            }
        }
    }
}

