/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.common.controls;

import com.ibm.ccl.sca.core.model.ISCAComposite;
import com.ibm.ccl.sca.internal.ui.common.controls.AbstractSelectionListener;
import com.ibm.ccl.sca.internal.ui.common.controls.CompositeSelectionControlFactory;
import com.ibm.ccl.sca.internal.ui.common.controls.ICompositeSelectionControl;
import com.ibm.ccl.sca.internal.ui.common.controls.ICompositeSelectionDialog;
import com.ibm.ccl.sca.internal.ui.common.controls.IPackButtonAction;
import com.ibm.ccl.sca.ui.messages.Messages;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CompositeSelectionDialog
extends TitleAreaDialog
implements ICompositeSelectionDialog {
    ICompositeSelectionControl compositeSelection;
    List<Object> selected = null;
    List<ISCAComposite> selectedComposites = null;
    private boolean isCheckedTree = false;
    private IProject project = null;
    private Set<IProject> projectSet = null;
    private IResource currentResource = null;

    public void setCheckedTree(boolean isCheckedTree) {
        this.isCheckedTree = isCheckedTree;
    }

    protected CompositeSelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    @Override
    public void addListenerObject(Object listener) {
        this.compositeSelection.addListenerObject(listener);
    }

    @Override
    public void addSelectionListener2DeselectAll(AbstractSelectionListener addAction) {
        this.compositeSelection.addSelectionListener2DeselectAll(addAction);
    }

    @Override
    public void addSelectionListener2SelectAll(AbstractSelectionListener addAction) {
        this.compositeSelection.addSelectionListener2SelectAll(addAction);
    }

    @Override
    public void enableExpansionButtons(boolean enabled) {
        this.compositeSelection.enableExpansionButtons(enabled);
    }

    @Override
    public void enableSelectionButtons(boolean enabled) {
        this.compositeSelection.enableSelectionButtons(enabled);
    }

    @Override
    public List<Object> getSelected() {
        return this.selected;
    }

    @Override
    public List<ISCAComposite> getSelectedComposites() {
        return this.selectedComposites;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.LABEL_SELECT_COMPOSITE);
        this.setMessage(Messages.MSG_SELECT_COMPOSITE);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite child = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        child.setLayout((Layout)layout);
        return child;
    }

    @Override
    public void initialize() {
        this.create();
        this.compositeSelection = this.isCheckedTree ? CompositeSelectionControlFactory.createCompositeSelectionControlAsCheckedTree((Composite)this.getDialogArea()) : CompositeSelectionControlFactory.createCompositeSelectionControlAsSingleSelectTree((Composite)this.getDialogArea());
        this.compositeSelection.setCurrentResource(this.currentResource);
        this.compositeSelection.initialize();
        this.compositeSelection.packButtons(new IPackButtonAction(){

            @Override
            public void pack(Button b) {
                CompositeSelectionDialog.this.setButtonLayoutData(b);
            }
        });
        Label serviceSeparator = new Label((Composite)this.getDialogArea(), 258);
        GridData griddata = new GridData(768);
        griddata.horizontalSpan = 3;
        griddata.verticalIndent = 12;
        serviceSeparator.setLayoutData((Object)griddata);
        this.initializeBounds();
        this.setBlockOnOpen(true);
        this.getButton(0).setEnabled(false);
        this.compositeSelection.addSelectionListener2SelectAll(new AbstractSelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                CompositeSelectionDialog.this.getButton(0).setEnabled(!CompositeSelectionDialog.this.isNothingSelected());
            }
        });
        this.compositeSelection.addSelectionListener2DeselectAll(new AbstractSelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                CompositeSelectionDialog.this.getButton(0).setEnabled(!CompositeSelectionDialog.this.isNothingSelected());
            }
        });
        if (this.isCheckedTree) {
            this.compositeSelection.addListenerObject(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    CompositeSelectionDialog.this.validate();
                }
            });
        } else {
            this.compositeSelection.addListenerObject(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    CompositeSelectionDialog.this.validate();
                }
            });
        }
        this.addSearchScopeListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompositeSelectionDialog.this.validate();
            }
        });
    }

    private void validate() {
        ArrayList<QName> seenQNames = new ArrayList<QName>();
        boolean hasSelectedOutsideProjectSet = false;
        for (ISCAComposite composite : this.compositeSelection.getSelectedComposites()) {
            if (seenQNames.contains(composite.getName())) {
                this.setErrorMessage(Messages.ERROR_DUP_QNAME);
                this.setMessage(null);
                this.getButton(0).setEnabled(false);
                return;
            }
            seenQNames.add(composite.getName());
            if (this.project == null || this.projectSet.contains(composite.getParent())) continue;
            hasSelectedOutsideProjectSet = true;
        }
        if (this.project != null && hasSelectedOutsideProjectSet) {
            this.setErrorMessage(null);
            this.setMessage(Messages.bind((String)Messages.WARN_NOT_IN_DEPENDENT_PROJECT, (Object)this.project.getName()), 2);
            this.getButton(0).setEnabled(true);
            return;
        }
        this.setErrorMessage(null);
        this.setMessage(Messages.MSG_SELECT_COMPOSITE);
        this.getButton(0).setEnabled(!this.isNothingSelected());
    }

    @Override
    public boolean isEmpty() {
        return this.compositeSelection.isEmpty();
    }

    @Override
    public boolean isNothingSelected() {
        return this.compositeSelection.isNothingSelected();
    }

    @Override
    public void packButtons(IPackButtonAction pack) {
        this.compositeSelection.packButtons(pack);
    }

    @Override
    public void removeListenerObject(Object listener) {
        this.compositeSelection.removeListenerObject(listener);
    }

    @Override
    public void select(Object element) {
        this.compositeSelection.select(element);
    }

    @Override
    public void setRootObject(Object root) {
        this.compositeSelection.setRootObject(root);
    }

    @Override
    public void setSelectionListener(ISelectionChangedListener selectionListener) {
        this.compositeSelection.setSelectionListener(selectionListener);
    }

    @Override
    public void setTreeContentProvider(ITreeContentProvider treeContentProvider) {
        this.compositeSelection.setTreeContentProvider(treeContentProvider);
    }

    @Override
    public void setTreeLabelProvider(IBaseLabelProvider treeLabelProvider) {
        this.compositeSelection.setTreeLabelProvider(treeLabelProvider);
    }

    @Override
    public void updateRootObject(Object root) {
        this.compositeSelection.updateRootObject(root);
    }

    @Override
    public void updateTreeViewer(Object[] elements, String[] properties) {
        this.compositeSelection.updateTreeViewer(elements, properties);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        this.selected = this.compositeSelection.getSelected();
        this.selectedComposites = this.compositeSelection.getSelectedComposites();
        super.okPressed();
    }

    protected Control getDialogArea() {
        return super.getDialogArea();
    }

    public void setCompositeSelectionControl(ICompositeSelectionControl control) {
        this.compositeSelection = control;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.Dialog_TITLE_DIALOG_COMPOSITE_SELECTION);
    }

    @Override
    public void setIgnoredQNames(List<QName> qnames) {
        this.compositeSelection.setIgnoredQNames(qnames);
    }

    private void createProjectSet() {
        this.projectSet = new HashSet<IProject>();
        this.projectSet.add(this.project);
        if (this.project.isAccessible()) {
            try {
                IProject[] iProjectArray = this.project.getReferencedProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject referencedProject = iProjectArray[n2];
                    this.projectSet.add(referencedProject);
                    ++n2;
                }
            }
            catch (CoreException coreException) {}
        }
    }

    @Override
    public void setCurrentResource(IResource resource) {
        if (resource != null) {
            this.project = resource.getProject();
            this.createProjectSet();
        }
        this.currentResource = resource;
    }

    @Override
    public void setSearchScope(ICompositeSelectionControl.SCOPE scope, boolean enabled) {
        this.compositeSelection.setSearchScope(scope, enabled);
    }

    @Override
    public void addSearchScopeListener(SelectionListener listener) {
        this.compositeSelection.addSearchScopeListener(listener);
    }
}

