/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.common.controls;

import com.ibm.ccl.sca.core.util.QNameHelpers;
import com.ibm.ccl.sca.ui.messages.Messages;
import com.ibm.ccl.sca.ui.util.UIUtils;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IContainer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CompositeNameConflictDialog
extends Dialog {
    private static final String INFOPOP_NAME_CONFLICT_NAMESPACE = "NAME_CONFLICT_NAMESPACE";
    private static final String INFOPOP_NAME_CONFLICT_NAME = "NAME_CONFLICT_NAME";
    private static final String INFOPOP_NAME_CONFLICT_OVERWRITE = "NAME_CONFLICT_OVERWRITE";
    private IContainer destination;
    private List<QName> qNames;
    private String filename;
    private QName qName;
    private UIUtils utils = new UIUtils("com.ibm.ccl.sca.ui");
    private Text namespaceField;
    private Text nameField;
    private Text filenameField;
    private Text messageText;
    private Button forceOverwrite;
    private boolean logicalNameConflict;
    private boolean physicalNameConflict;

    public CompositeNameConflictDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.LABEL_NAME_CONFLICT_DIALOG_TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite childComposite = this.utils.createComposite(composite, 1);
        Text text = this.utils.createText(childComposite, null, null, null, 64);
        text.setText(Messages.bind((String)Messages.LABEL_ENTER_QNAME, (Object)this.filename));
        text.setEditable(false);
        text.setBackground(childComposite.getBackground());
        this.utils.createHorizontalSeparator(composite, 0);
        childComposite = this.utils.createComposite(composite, 2);
        Label label = this.utils.createLabel(childComposite, Messages.LABEL_TARGET_NAMESPACE, "", 64);
        label.setLayoutData((Object)new GridData(256));
        this.namespaceField = this.utils.createText(childComposite, null, Messages.TOOLTIP_TARGET_NAMESPACE_FOR_COMPOSITE, INFOPOP_NAME_CONFLICT_NAMESPACE, 2048);
        this.namespaceField.setText(this.qName.getNamespaceURI());
        this.namespaceField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CompositeNameConflictDialog.this.validate();
            }
        });
        label = this.utils.createLabel(childComposite, Messages.LABEL_NAME, "", 64);
        label.setLayoutData((Object)new GridData(256));
        this.nameField = this.utils.createText(childComposite, null, Messages.TOOLTIP_NAME_FOR_COMPOSITE, INFOPOP_NAME_CONFLICT_NAME, 2048);
        this.nameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String name = URI.encodeSegment((String)CompositeNameConflictDialog.this.nameField.getText().trim(), (boolean)true);
                CompositeNameConflictDialog.this.filenameField.setText(String.valueOf(name.replaceAll("%[0-9a-fA-F]{2}", "_")) + ".composite");
                CompositeNameConflictDialog.this.validate();
            }
        });
        label = this.utils.createLabel(childComposite, Messages.LABEL_FILENAME, "", 64);
        label.setLayoutData((Object)new GridData(256));
        this.filenameField = this.utils.createText(childComposite, null, null, null, 2048);
        this.filenameField.setEditable(false);
        this.nameField.setText(this.qName.getLocalPart());
        childComposite = this.utils.createComposite(composite, 1);
        childComposite.setLayoutData((Object)new GridData(1808));
        this.messageText = this.utils.createText(childComposite, null, null, null, 64);
        this.messageText.setLayoutData((Object)new GridData(1808));
        this.messageText.setEditable(false);
        this.messageText.setBackground(childComposite.getBackground());
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = this.utils.createComposite(parent, 2);
        ((GridLayout)composite.getLayout()).marginLeft = 10;
        this.forceOverwrite = this.utils.createCheckbox(composite, Messages.LABEL_FORCE_OVERWRITE, Messages.LABEL_FORCE_OVERWRITE, INFOPOP_NAME_CONFLICT_OVERWRITE);
        this.forceOverwrite.setLayoutData((Object)new GridData(1570));
        this.forceOverwrite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompositeNameConflictDialog.this.validate();
            }
        });
        return super.createButtonBar(composite);
    }

    public void create() {
        super.create();
        this.validate();
        Point size = this.getShell().computeSize(400, -1);
        this.getShell().setSize(size);
    }

    private QName getQName() {
        String namespace = this.namespaceField.getText().trim();
        String name = this.nameField.getText().trim();
        return QNameHelpers.createValidQName((String)namespace, (String)name);
    }

    protected void okPressed() {
        this.filename = this.filenameField.getText();
        super.okPressed();
    }

    private void validate() {
        Button ok = this.getButton(0);
        if (ok == null) {
            return;
        }
        if (this.namespaceField.getText().trim().length() == 0 || this.nameField.getText().trim().length() == 0) {
            ok.setEnabled(false);
            this.messageText.setText(Messages.ERR_BLANK_FIELDS);
            return;
        }
        this.qName = this.getQName();
        if (this.qName == null) {
            ok.setEnabled(false);
            this.messageText.setText(Messages.ERR_INVALID_NAME);
            return;
        }
        this.logicalNameConflict = this.qNames.contains(this.qName);
        if (this.logicalNameConflict && !this.forceOverwrite.getSelection()) {
            ok.setEnabled(false);
            this.messageText.setText(Messages.ERR_QNAME_NOT_UNIQUE);
            return;
        }
        boolean bl = this.physicalNameConflict = this.destination.findMember(this.filenameField.getText()) != null;
        if (this.physicalNameConflict && !this.forceOverwrite.getSelection()) {
            ok.setEnabled(false);
            this.messageText.setText(Messages.ERR_FILE_EXISTS);
            return;
        }
        ok.setEnabled(true);
        this.messageText.setText("");
    }

    public void setDestination(IContainer destination) {
        this.destination = destination;
    }

    public void setQNames(List<QName> qNames) {
        this.qNames = qNames;
    }

    public void setSourceFilename(String filename) {
        this.filename = filename;
    }

    public void setSourceQName(QName qName) {
        this.qName = qName;
    }

    public String getAdjustedFilename() {
        return this.filename;
    }

    public QName getAdjustedQName() {
        return this.qName;
    }

    public boolean hasLogicalNameConflict() {
        return this.logicalNameConflict;
    }

    public boolean hasPhysicalNameConflict() {
        return this.physicalNameConflict;
    }
}

