/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.common.controls;

import com.ibm.ccl.sca.core.model.ISCAArtifact;
import com.ibm.ccl.sca.core.model.ISCAComposite;
import com.ibm.ccl.sca.internal.ui.common.controls.CompositeTreeGroup;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;

public class CompositeCheckedTreeGroup
extends CompositeTreeGroup
implements ICheckStateListener {
    protected CompositeCheckedTreeGroup(Composite parent, Object rootObject, int style, boolean useHeightHint) {
        super(parent, rootObject, style, useHeightHint);
    }

    @Override
    protected void createTreeViewer(Composite parent, int style, boolean useHeightHint) {
        Tree tree = new Tree(parent, 0x20 | style);
        GridData data = new GridData(1808);
        if (useHeightHint) {
            data.heightHint = PREFERRED_HEIGHT;
        }
        tree.setLayoutData((Object)data);
        tree.setFont(parent.getFont());
        this.treeViewer = new CheckboxTreeViewer(tree);
        this.treeViewer.setContentProvider((IContentProvider)this.treeContentProvider);
        this.treeViewer.setLabelProvider(this.treeLabelProvider);
        this.treeViewer.setComparator(new ViewerComparator());
        this.treeViewer.addTreeListener((ITreeViewerListener)this);
        ((CheckboxTreeViewer)this.treeViewer).addCheckStateListener((ICheckStateListener)this);
        if (this.selectionListener != null) {
            this.treeViewer.addSelectionChangedListener(this.selectionListener);
        }
    }

    public boolean isTreeFullyUnChecked() {
        return ((CheckboxTreeViewer)this.treeViewer).getCheckedElements().length == 0;
    }

    private Object[] getFilteredChildren(Object parent) {
        Object[] children = this.treeContentProvider.getChildren(parent);
        ViewerFilter[] viewerFilterArray = ((CheckboxTreeViewer)this.treeViewer).getFilters();
        int n = viewerFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter filter = viewerFilterArray[n2];
            children = filter.filter((Viewer)((CheckboxTreeViewer)this.treeViewer), parent, children);
            ++n2;
        }
        return children;
    }

    private boolean areAllChildrenUnChecked(Object treeElement) {
        Object[] children = this.getFilteredChildren(treeElement);
        int i = 0;
        while (i < children.length) {
            if (((CheckboxTreeViewer)this.treeViewer).getChecked(children[i]) || ((CheckboxTreeViewer)this.treeViewer).getGrayed(children[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean areAllChildrenWhiteChecked(Object treeElement) {
        Object[] children = this.getFilteredChildren(treeElement);
        int i = 0;
        while (i < children.length) {
            if (!((CheckboxTreeViewer)this.treeViewer).getChecked(children[i]) || ((CheckboxTreeViewer)this.treeViewer).getGrayed(children[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public List<Object> getAllTreeCheckedElements() {
        ArrayList<Object> listOfCheckedElements = new ArrayList<Object>();
        Object[] elements = ((CheckboxTreeViewer)this.treeViewer).getCheckedElements();
        if (elements != null) {
            int i = 0;
            while (i < elements.length) {
                listOfCheckedElements.add(elements[i]);
                ++i;
            }
        }
        return listOfCheckedElements;
    }

    private void selectAndReveal(Object treeElement) {
        Object parent;
        this.treeViewer.reveal(treeElement);
        StructuredSelection selection = new StructuredSelection(treeElement);
        this.treeViewer.setSelection((ISelection)selection);
        if (treeElement instanceof IProject && this.areAllChildrenWhiteChecked(treeElement)) {
            this.treeViewer.collapseToLevel(treeElement, 1);
        }
        if (treeElement instanceof IFile && this.areAllChildrenWhiteChecked(parent = this.treeContentProvider.getParent(treeElement))) {
            this.treeViewer.collapseToLevel(parent, 1);
        }
    }

    @Override
    public void initialSelection(Object element) {
        this.treeItemChecked(element, true);
        this.selectAndReveal(element);
    }

    public void setAllSelections(boolean isToBeAllOrUncheckedChecked) {
        Object[] children;
        if (this.root == null) {
            return;
        }
        Object[] projectNodes = this.treeContentProvider.getChildren(this.root);
        if (projectNodes != null) {
            int i = 0;
            while (i < projectNodes.length) {
                this.setTreeChecked(projectNodes[i], isToBeAllOrUncheckedChecked);
                ++i;
            }
        }
        if ((children = this.treeContentProvider.getChildren((Object)projectNodes)) != null) {
            int i = 0;
            while (i < children.length) {
                this.setTreeBranchChecked(children[i], isToBeAllOrUncheckedChecked);
                ++i;
            }
        }
    }

    protected void setTreeChecked(Object treeElement, boolean state) {
        ((CheckboxTreeViewer)this.treeViewer).setGrayChecked(treeElement, false);
        ((CheckboxTreeViewer)this.treeViewer).setChecked(treeElement, state);
        Object[] children = this.treeContentProvider.getChildren(treeElement);
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                this.setTreeChecked(children[i], state);
                ++i;
            }
        }
    }

    private void updateParent(Object treeElement) {
        if (treeElement instanceof IProject) {
            return;
        }
        Object parent = this.treeContentProvider.getParent(treeElement);
        if (parent == null) {
            return;
        }
        if (this.areAllChildrenWhiteChecked(parent)) {
            ((CheckboxTreeViewer)this.treeViewer).setGrayChecked(parent, false);
            ((CheckboxTreeViewer)this.treeViewer).setChecked(parent, true);
        }
        if (this.areAllChildrenUnChecked(parent)) {
            ((CheckboxTreeViewer)this.treeViewer).setChecked(parent, false);
            ((CheckboxTreeViewer)this.treeViewer).setGrayChecked(parent, false);
        }
        if (!this.areAllChildrenUnChecked(parent) && !this.areAllChildrenWhiteChecked(parent)) {
            ((CheckboxTreeViewer)this.treeViewer).setGrayChecked(parent, true);
        }
        this.updateParent(parent);
    }

    protected void treeItemChecked(Object treeElement, boolean state) {
        if (treeElement instanceof IProject) {
            this.setTreeChecked(treeElement, state);
        } else {
            this.setTreeBranchChecked(treeElement, state);
        }
    }

    protected void setTreeBranchChecked(Object treeElement, boolean state) {
        this.setTreeChecked(treeElement, state);
        this.updateParent(treeElement);
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        if (event.getCheckable().equals(this.treeViewer)) {
            this.treeItemChecked(event.getElement(), event.getChecked());
        }
        this.notifyCheckStateChangeListeners(event);
    }

    @Override
    public List<ISCAComposite> getSelectedComposites() {
        Object[] checkedItems;
        ArrayList<ISCAComposite> composites = new ArrayList<ISCAComposite>();
        CheckboxTreeViewer checkboxViewer = (CheckboxTreeViewer)this.treeViewer;
        Object[] objectArray = checkedItems = checkboxViewer.getCheckedElements();
        int n = checkedItems.length;
        int n2 = 0;
        while (n2 < n) {
            ISCAComposite composite;
            Object checkedItem = objectArray[n2];
            if (checkedItem instanceof IFile && (composite = (ISCAComposite)((IFile)checkedItem).getAdapter(ISCAArtifact.class)) != null) {
                composites.add(composite);
            }
            ++n2;
        }
        return composites;
    }

    @Override
    public List<Object> getSelected() {
        return this.getAllTreeCheckedElements();
    }
}

