/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.common.controls;

import com.ibm.ccl.sca.core.model.ISCAArtifact;
import com.ibm.ccl.sca.core.model.ISCAContribution;
import com.ibm.ccl.sca.core.model.ISCAProject;
import com.ibm.ccl.sca.core.model.SCAModelManager;
import com.ibm.ccl.sca.core.model.SCAModelUtil;
import com.ibm.ccl.sca.internal.ui.common.controls.CompositeCheckedTreeGroup;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class CompositeAndContributionCheckedTreeGroup
extends CompositeCheckedTreeGroup
implements ICheckStateListener {
    private boolean isExportContributions = false;
    private ITreeContentProvider currentCompositesTreeContentProvider;
    private ITreeContentProvider currentContributionsTreeContentProvider;

    protected CompositeAndContributionCheckedTreeGroup(Composite parent, Object rootObject, int style, boolean useHeightHint) {
        super(parent, rootObject, style, useHeightHint);
    }

    public List<ISCAContribution> getSelectedContributions() {
        Object[] checkedItems;
        ArrayList<ISCAContribution> contributions = new ArrayList<ISCAContribution>();
        CheckboxTreeViewer checkboxViewer = (CheckboxTreeViewer)this.treeViewer;
        Object[] objectArray = checkedItems = checkboxViewer.getCheckedElements();
        int n = checkedItems.length;
        int n2 = 0;
        while (n2 < n) {
            ISCAContribution contribution;
            Object checkedItem = objectArray[n2];
            if (checkedItem instanceof IFile && (contribution = (ISCAContribution)((IProject)checkedItem).getAdapter(ISCAArtifact.class)) != null) {
                contributions.add(contribution);
            }
            ++n2;
        }
        return contributions;
    }

    @Override
    public void setAllSelections(boolean isToBeAllOrUncheckedChecked) {
        Object[] children;
        if (this.root == null) {
            return;
        }
        Object[] projectNodes = null;
        projectNodes = this.isExportContributions ? this.treeContentProvider.getElements(this.root) : this.treeContentProvider.getChildren(this.root);
        if (projectNodes != null) {
            int i = 0;
            while (i < projectNodes.length) {
                this.setTreeChecked(projectNodes[i], isToBeAllOrUncheckedChecked);
                ++i;
            }
        }
        if ((children = this.treeContentProvider.getChildren((Object)projectNodes)) != null) {
            int i = 0;
            while (i < children.length) {
                this.setTreeBranchChecked(children[i], isToBeAllOrUncheckedChecked);
                ++i;
            }
        }
    }

    protected void setExportByContributions(boolean isExportContributions) {
        this.isExportContributions = isExportContributions;
    }

    protected ITreeContentProvider getContributionsResourceProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getElements(Object element) {
                if (element instanceof List) {
                    ISCAProject[] scaProjects = null;
                    try {
                        scaProjects = SCAModelUtil.convertSCAProjectsListToArray((List)SCAModelUtil.getSCAProjectsList());
                    }
                    catch (CoreException coreException) {}
                    ArrayList<IProject> input = new ArrayList<IProject>();
                    if (scaProjects != null && scaProjects.length != 0) {
                        int projectSize = scaProjects.length;
                        int i = 0;
                        while (i < projectSize) {
                            List projectContributionsList = SCAModelManager.getContributions((ISCAProject)scaProjects[i]);
                            for (ISCAContribution scaContribution : projectContributionsList) {
                                if (scaContribution == null || scaContribution.isVirtual()) continue;
                                input.add(scaProjects[i].getProject());
                            }
                            ++i;
                        }
                    }
                    return input.toArray();
                }
                return new Object[0];
            }

            public Object[] getChildren(Object o) {
                return new Object[0];
            }
        };
    }

    @Override
    protected ITreeContentProvider getResourceProvider() {
        this.currentCompositesTreeContentProvider = super.getResourceProvider();
        this.currentContributionsTreeContentProvider = this.getContributionsResourceProvider();
        if (!this.isExportContributions) {
            return this.currentCompositesTreeContentProvider;
        }
        return this.currentContributionsTreeContentProvider;
    }

    public ITreeContentProvider getCurrentCompositesTreeProvider() {
        return this.currentCompositesTreeContentProvider;
    }

    public ITreeContentProvider getCurrentContributionsTreeProvider() {
        return this.currentContributionsTreeContentProvider;
    }
}

