/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.ui.common.controls;

import com.ibm.ccl.sca.internal.ui.common.controls.ISelectionControl;
import com.ibm.ccl.sca.internal.ui.common.controls.ValidateSelectedContentProvider;
import com.ibm.ccl.sca.ui.messages.Messages;
import com.ibm.ccl.sca.ui.util.UIUtils;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class BaseSelectionControl
extends Composite
implements SelectionListener,
ISelectionControl {
    private TreeViewer treeViewer;
    private ValidateSelectedContentProvider treeContentProvider;
    private IBaseLabelProvider treeLabelProvider;
    private Button expandAllButton;
    private Button collapseAllButton;
    private UIUtils uiUtils = new UIUtils(null);
    private SelectionListener treeSelectionListener;

    public BaseSelectionControl(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    public Composite createControls() {
        GridLayout layout = new GridLayout();
        GridData gridData = new GridData(1808);
        gridData.verticalIndent = 5;
        gridData.horizontalIndent = 5;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 5;
        this.setLayout((Layout)layout);
        this.setLayoutData(gridData);
        this.createTreeViewer(2052);
        this.createButtons();
        return this;
    }

    public void enableControls(boolean enabled) {
        this.treeViewer.getTree().setEnabled(enabled);
        this.treeViewer.getTree().setSelection(new TreeItem[0]);
        this.expandAllButton.setEnabled(enabled);
        this.collapseAllButton.setEnabled(enabled);
    }

    @Override
    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.treeLabelProvider = labelProvider;
    }

    @Override
    public void setContentProvider(ValidateSelectedContentProvider contentProvider) {
        this.treeContentProvider = contentProvider;
    }

    @Override
    public void setRoot(Object root) {
        this.treeViewer.setInput(root);
    }

    @Override
    public void addSelectionListener(SelectionListener treeListener) {
        this.treeSelectionListener = treeListener;
    }

    @Override
    public Object getSelection() {
        return ((IStructuredSelection)this.treeViewer.getSelection()).getFirstElement();
    }

    private void createTreeViewer(int treeStyle) {
        final Tree tree = new Tree((Composite)this, treeStyle);
        GridData data = new GridData(1808);
        tree.setLayoutData((Object)data);
        tree.setFont(this.getFont());
        this.treeViewer = new TreeViewer(tree);
        this.treeViewer.setContentProvider((IContentProvider)this.treeContentProvider);
        this.treeViewer.setLabelProvider(this.treeLabelProvider);
        this.treeViewer.setComparator(new ViewerComparator());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (BaseSelectionControl.this.treeSelectionListener != null) {
                    boolean isOk = BaseSelectionControl.this.treeContentProvider.isElementOk(BaseSelectionControl.this.getSelection());
                    Event widgetEvent = new Event();
                    widgetEvent.widget = tree;
                    SelectionEvent evt = new SelectionEvent(widgetEvent);
                    evt.data = new Boolean(isOk);
                    BaseSelectionControl.this.treeSelectionListener.widgetSelected(evt);
                }
            }
        });
    }

    private void createButtons() {
        Composite buttonComposite = this.uiUtils.createComposite(this, 2);
        this.expandAllButton = this.uiUtils.createPushButton(buttonComposite, Messages.SCA_EXPAND_ALL_BUTTON_TEXT, null, null);
        this.expandAllButton.addSelectionListener((SelectionListener)this);
        this.expandAllButton.setFont(this.getFont());
        this.collapseAllButton = this.uiUtils.createPushButton(buttonComposite, Messages.SCA_COLLAPSE_ALL_BUTTON_TEXT, null, null);
        this.collapseAllButton.addSelectionListener((SelectionListener)this);
        this.collapseAllButton.setFont(this.getFont());
    }

    public void widgetDefaultSelected(SelectionEvent evt) {
    }

    public void widgetSelected(SelectionEvent evt) {
        if (evt.widget == this.expandAllButton) {
            this.treeViewer.expandAll();
        } else if (evt.widget == this.collapseAllButton) {
            this.treeViewer.collapseAll();
        }
    }
}

