/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.dialogs;

import com.ibm.ccl.sca.composite.ui.dialogs.ComponentDescription;
import com.ibm.ccl.sca.ui.messages.Messages;
import com.ibm.ccl.sca.ui.plugin.SCAToolsUIPlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SetExistingDialog
extends Dialog
implements SelectionListener {
    private List<Object> values;
    private List<Object> displayedValues = new ArrayList<Object>();
    private Text textFilter;
    private org.eclipse.swt.widgets.List valuesListWidget;
    private CLabel locationLabel;
    private ComponentDescription selectedValue;
    private DelayedEvent delayedEvent;

    public SetExistingDialog() {
        super(SCAToolsUIPlugin.getShell());
    }

    public int createAndOpen() {
        this.create();
        this.getShell().setText(Messages.SetExistingDialog_0);
        this.setBlockOnOpen(true);
        return this.open();
    }

    public void setValuesList(List<Object> list) {
        this.values = list;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dialogArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData gdFill = new GridData();
        gdFill.horizontalAlignment = 4;
        gdFill.grabExcessHorizontalSpace = true;
        gdFill.verticalAlignment = 4;
        gdFill.grabExcessVerticalSpace = true;
        gdFill.minimumHeight = 300;
        gdFill.minimumWidth = 300;
        composite.setLayoutData((Object)gdFill);
        Label filterLabel = new Label(composite, 0);
        filterLabel.setText(Messages.SetExistingDialog_1);
        this.textFilter = new Text(composite, 2052);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textFilter.setLayoutData((Object)gd);
        this.textFilter.addModifyListener((ModifyListener)new TextFilterModifyAdapter());
        new Label(composite, 0);
        Label possibleValues = new Label(composite, 0);
        possibleValues.setText(Messages.SetExistingDialog_2);
        this.valuesListWidget = new org.eclipse.swt.widgets.List(composite, 2052);
        this.valuesListWidget.addSelectionListener((SelectionListener)this);
        GridData multiGridData = new GridData(1808);
        this.valuesListWidget.setLayoutData((Object)multiGridData);
        Label qualifierLabel = new Label(composite, 0);
        qualifierLabel.setText(Messages.SetExistingDialog_3);
        ViewForm fileLocationView = new ViewForm(composite, 0x800800);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.heightHint = 22;
        fileLocationView.setLayoutData((Object)data);
        this.locationLabel = new CLabel((Composite)fileLocationView, 0x800000);
        fileLocationView.setContent((Control)this.locationLabel);
        this.locationLabel.setFont(fileLocationView.getFont());
        for (Object item : this.values) {
            if (!(item instanceof ComponentDescription)) continue;
            this.displayedValues.add(item);
        }
        this.refreshValuesTable();
        if (this.valuesListWidget.getItemCount() > 0) {
            this.valuesListWidget.select(0);
            this.selectedValue = (ComponentDescription)this.displayedValues.get(0);
        }
        this.refreshLocationLabel();
        return dialogArea;
    }

    public ComponentDescription getValue() {
        return this.selectedValue;
    }

    private void refreshValuesTable() {
        this.valuesListWidget.removeAll();
        for (Object item : this.displayedValues) {
            if (!(item instanceof ComponentDescription)) continue;
            String itemString = ((ComponentDescription)item).getLabel();
            this.valuesListWidget.add(itemString);
        }
        if (this.valuesListWidget.getItemCount() > 0) {
            this.valuesListWidget.select(0);
        }
        this.updateSelectedValue();
        this.refreshLocationLabel();
    }

    protected void refreshValues(String filterText) {
        this.displayedValues.clear();
        Pattern regex = Pattern.compile(filterText);
        for (Object item : this.values) {
            if (!(item instanceof ComponentDescription)) continue;
            String itemString = ((ComponentDescription)item).getLabel();
            Matcher m = regex.matcher(itemString.toLowerCase());
            if (!itemString.toLowerCase().startsWith(filterText) && !m.matches()) continue;
            this.displayedValues.add(item);
        }
        this.refreshValuesTable();
    }

    protected String getProcessedFilterString() {
        return this.processFilterString(this.textFilter.getText());
    }

    private String processFilterString(String inputString) {
        if (!inputString.equals("")) {
            inputString = this.insertString("*", ".", inputString);
            inputString = this.insertString("?", ".", inputString);
            inputString = String.valueOf(inputString) + ".*";
        } else {
            inputString = ".*";
        }
        return inputString.toLowerCase();
    }

    private String insertString(String target, String newString, String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int index = stringBuffer.indexOf(target);
        while (index != -1) {
            stringBuffer = stringBuffer.insert(index, newString);
            index = stringBuffer.indexOf(target, index + newString.length() + target.length());
        }
        return stringBuffer.toString();
    }

    private void refreshLocationLabel() {
        if (this.selectedValue != null) {
            this.locationLabel.setText(this.selectedValue.getQualifier());
        }
    }

    private void updateSelectedValue() {
        if (this.valuesListWidget.getSelectionIndex() >= 0) {
            this.selectedValue = (ComponentDescription)this.displayedValues.get(this.valuesListWidget.getSelectionIndex());
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.valuesListWidget) {
            this.updateSelectedValue();
            this.refreshLocationLabel();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private class DelayedEvent
    implements Runnable {
        public boolean CANCEL = false;

        private DelayedEvent() {
        }

        @Override
        public void run() {
            if (!this.CANCEL) {
                SetExistingDialog.this.refreshValues(SetExistingDialog.this.getProcessedFilterString());
                if (SetExistingDialog.this.valuesListWidget.getItemCount() > 0) {
                    SetExistingDialog.this.valuesListWidget.select(0);
                }
            }
        }
    }

    private class TextFilterModifyAdapter
    implements ModifyListener {
        private TextFilterModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            if (e.widget == SetExistingDialog.this.textFilter) {
                if (SetExistingDialog.this.delayedEvent != null) {
                    ((SetExistingDialog)SetExistingDialog.this).delayedEvent.CANCEL = true;
                }
                SetExistingDialog.this.delayedEvent = new DelayedEvent();
                Display.getCurrent().timerExec(400, (Runnable)SetExistingDialog.this.delayedEvent);
            }
        }
    }
}

