/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.dialogs;

import com.ibm.ccl.sca.ui.messages.Messages;
import com.ibm.ccl.sca.ui.plugin.SCAToolsUIPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MultiValueSelectionDialog
extends Dialog
implements SelectionListener {
    private Button addButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    private Text valueTextField;
    private org.eclipse.swt.widgets.List valuesList;
    private CLabel previewLabel;
    private List<Object> originalValuesList = new ArrayList<Object>();
    private List<Object> selectedValues = new ArrayList<Object>();

    public MultiValueSelectionDialog() {
        super(SCAToolsUIPlugin.getShell());
    }

    public int createAndOpen() {
        this.create();
        this.getShell().setText(Messages.SelectionDialog_0);
        this.setBlockOnOpen(true);
        return this.open();
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dialogArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData gdFill = new GridData();
        gdFill.horizontalAlignment = 4;
        gdFill.grabExcessHorizontalSpace = true;
        gdFill.verticalAlignment = 4;
        gdFill.grabExcessVerticalSpace = true;
        gdFill.minimumHeight = 260;
        gdFill.minimumWidth = 300;
        composite.setLayoutData((Object)gdFill);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(Messages.SelectionDialog_1);
        Composite valueComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        valueComposite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.grabExcessVerticalSpace = true;
        valueComposite.setLayoutData((Object)gd);
        this.valueTextField = new Text(valueComposite, 2052);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.valueTextField.setLayoutData((Object)gd);
        this.addButton = new Button(valueComposite, 8);
        this.addButton.setText(Messages.SelectionDialog_2);
        this.valuesList = new org.eclipse.swt.widgets.List(valueComposite, 2048);
        gd = new GridData(1808);
        gd.grabExcessVerticalSpace = true;
        this.valuesList.setLayoutData((Object)gd);
        Composite buttonComp = new Composite(valueComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComp.setLayout((Layout)layout);
        gd = new GridData(1040);
        buttonComp.setLayoutData((Object)gd);
        this.removeButton = new Button(buttonComp, 8);
        this.removeButton.setText(Messages.SelectionDialog_3);
        this.upButton = new Button(buttonComp, 8);
        GridData buttonGD = new GridData(768);
        buttonGD.grabExcessHorizontalSpace = true;
        this.upButton.setLayoutData((Object)buttonGD);
        this.upButton.setText(Messages.SelectionDialog_4);
        this.downButton = new Button(buttonComp, 8);
        buttonGD = new GridData(768);
        buttonGD.grabExcessHorizontalSpace = true;
        this.downButton.setLayoutData((Object)buttonGD);
        this.downButton.setText(Messages.SelectionDialog_5);
        Label previewTitle = new Label(composite, 0);
        previewTitle.setText(Messages.SelectionDialog_6);
        ViewForm previewView = new ViewForm(composite, 0x800800);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.heightHint = 22;
        previewView.setLayoutData((Object)data);
        this.previewLabel = new CLabel((Composite)previewView, 0x800000);
        previewView.setContent((Control)this.previewLabel);
        this.previewLabel.setFont(previewView.getFont());
        for (Object item : this.originalValuesList) {
            if (!(item instanceof String)) continue;
            this.valuesList.add((String)item);
        }
        this.updatePreview();
        this.addButton.addSelectionListener((SelectionListener)this);
        this.removeButton.addSelectionListener((SelectionListener)this);
        this.upButton.addSelectionListener((SelectionListener)this);
        this.downButton.addSelectionListener((SelectionListener)this);
        return dialogArea;
    }

    private void updatePreview() {
        String preview = "";
        String delimiter = " ";
        String[] items = this.valuesList.getItems();
        int index = 0;
        while (index < items.length) {
            preview = String.valueOf(preview) + delimiter + items[index];
            ++index;
        }
        if (items.length > 0) {
            preview = "\"" + preview.substring(1) + "\"";
        }
        this.previewLabel.setText(preview);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.addButton && this.valueTextField.getText() != null && this.valueTextField.getText().length() > 0) {
            this.valuesList.add(this.valueTextField.getText());
            this.updatePreview();
        } else if (e.widget == this.removeButton && this.valuesList.getSelectionIndex() != -1) {
            int index = this.valuesList.getSelectionIndex();
            this.valuesList.remove(index);
            if (index - 1 >= 0) {
                this.valuesList.select(index - 1);
            }
            this.updatePreview();
        } else if (e.widget == this.upButton && this.valuesList.getSelectionIndex() != -1 && this.valuesList.getSelectionIndex() != 0) {
            int index = this.valuesList.getSelectionIndex();
            int indexAbove = index - 1;
            String string = this.valuesList.getItem(index);
            String stringAbove = this.valuesList.getItem(indexAbove);
            this.valuesList.setItem(indexAbove, string);
            this.valuesList.setItem(index, stringAbove);
            this.valuesList.setSelection(indexAbove);
            this.updatePreview();
        } else if (e.widget == this.downButton && this.valuesList.getSelectionIndex() != -1 && this.valuesList.getSelectionIndex() != this.valuesList.getItemCount() - 1) {
            int index = this.valuesList.getSelectionIndex();
            int indexBelow = index + 1;
            String string = this.valuesList.getItem(index);
            String stringBelow = this.valuesList.getItem(indexBelow);
            this.valuesList.setItem(indexBelow, string);
            this.valuesList.setItem(index, stringBelow);
            this.valuesList.setSelection(indexBelow);
            this.updatePreview();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected void okPressed() {
        String[] values = this.valuesList.getItems();
        int index = 0;
        while (index < values.length) {
            this.selectedValues.add(values[index]);
            ++index;
        }
        super.okPressed();
    }

    public List<Object> getValue() {
        return this.selectedValues;
    }

    public void setValuesList(List<Object> list) {
        this.originalValuesList = list;
    }
}

