/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.server.websphere.utils;

import com.ibm.ccl.sca.server.websphere.plugin.SCAWebSphereServerCorePlugin;
import java.util.Date;
import org.eclipse.core.runtime.Platform;

public class Logger {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String DEBUG_OPTION_PREFIX = "com.ibm.ccl.sca.server.websphere/debug/";
    public static final int ERROR = 0;
    public static final int WARNING = 1;
    public static final int INFO = 2;
    public static final int DETAILS = 3;
    private static boolean isLog = true;
    private static transient Integer debugLevel = null;

    protected static boolean isDebugging() {
        SCAWebSphereServerCorePlugin plugin = SCAWebSphereServerCorePlugin.getInstance();
        return plugin == null ? false : plugin.isDebugging();
    }

    public static boolean isShowDebug(int severity) {
        if (!Logger.isDebugging()) {
            return false;
        }
        if (debugLevel == null) {
            debugLevel = "true".equals(Platform.getDebugOption((String)"com.ibm.ccl.sca.server.websphere/debug/details")) ? new Integer(3) : ("true".equals(Platform.getDebugOption((String)"com.ibm.ccl.sca.server.websphere/debug/info")) ? new Integer(2) : ("true".equals(Platform.getDebugOption((String)"com.ibm.ccl.sca.server.websphere/debug/warning")) ? new Integer(1) : ("true".equals(Platform.getDebugOption((String)"com.ibm.ccl.sca.server.websphere/debug/error")) ? new Integer(0) : new Integer(1))));
        }
        return debugLevel >= severity;
    }

    public static boolean isLog() {
        return isLog;
    }

    public static void print(int severity, String s) {
        if (!Logger.isShowDebug(severity)) {
            return;
        }
        String printStr = new StringBuffer().append(severity).append(" ").append(new Date()).append(" ").append(s).toString();
        System.out.print(printStr);
    }

    public static void println(int severity, Class<?> c, String s) {
        if (c != null) {
            Logger.print(severity, String.valueOf(c.getName()) + ": ");
        }
        Logger.println(severity, s);
    }

    public static void println(int severity, Class<?> curClass, String methodName, String msgStr) {
        StringBuffer printStrBuf = new StringBuffer();
        if (curClass != null) {
            printStrBuf.append(curClass.getName());
        }
        if (methodName != null) {
            printStrBuf.append(".").append(methodName).append(": ");
        }
        if (msgStr != null) {
            printStrBuf.append(msgStr);
        }
        Logger.println(severity, printStrBuf.toString());
    }

    public static void println(int severity, Class<?> curClass, String methodName, String msgStr, Throwable t) {
        if (!Logger.isShowDebug(severity)) {
            return;
        }
        StringBuffer printStrBuf = new StringBuffer();
        if (curClass != null) {
            printStrBuf.append(curClass.getName());
        }
        if (methodName != null) {
            printStrBuf.append(".").append(methodName).append(": ");
        }
        if (msgStr != null) {
            printStrBuf.append(msgStr);
        }
        Logger.println(severity, printStrBuf.toString());
        if (t != null) {
            System.out.print(String.valueOf(severity) + " " + t);
            t.printStackTrace();
        }
    }

    public static void println(int severity, Object o, String s) {
        if (o != null) {
            Logger.print(severity, String.valueOf(o.getClass().getName()) + ": ");
        }
        Logger.println(severity, s);
    }

    public static void println(int severity, Object obj, String methodName, String msgStr) {
        StringBuffer printStrBuf = new StringBuffer();
        if (obj != null) {
            printStrBuf.append(obj.getClass().getName());
        }
        if (methodName != null) {
            printStrBuf.append(".").append(methodName).append(": ");
        }
        if (msgStr != null) {
            printStrBuf.append(msgStr);
        }
        Logger.println(severity, printStrBuf.toString());
    }

    public static void println(int severity, Object obj, String methodName, String msgStr, Throwable t) {
        if (!Logger.isShowDebug(severity)) {
            return;
        }
        StringBuffer printStrBuf = new StringBuffer();
        if (obj != null) {
            printStrBuf.append(obj.getClass().getName());
        }
        if (methodName != null) {
            printStrBuf.append(".").append(methodName).append(": ");
        }
        if (msgStr != null) {
            printStrBuf.append(msgStr);
        }
        Logger.println(severity, printStrBuf.toString());
        if (t != null) {
            System.out.print(String.valueOf(severity) + " " + t);
            t.printStackTrace();
        }
    }

    public static void println(int severity, String s) {
        Logger.print(severity, String.valueOf(s) + LINE_SEPARATOR);
    }
}

