/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.server.websphere.publish;

import com.ibm.ccl.sca.core.model.ISCAArtifact;
import com.ibm.ccl.sca.core.model.ISCAComposite;
import com.ibm.ccl.sca.core.model.ISCAContribution;
import com.ibm.ccl.sca.core.preferences.PreferencesState;
import com.ibm.ccl.sca.core.tracing.SCATrace;
import com.ibm.ccl.sca.core.util.JavaUtil;
import com.ibm.ccl.sca.facets.websphere.util.ExportImportUtil;
import com.ibm.ccl.sca.internal.core.datatransfer.DeployableArchive;
import com.ibm.ccl.sca.internal.core.resolver.WSDLResolver;
import com.ibm.ccl.sca.server.core.module.contribution.ContributionModule;
import com.ibm.ccl.sca.server.websphere.internal.bla.BLAInfo;
import com.ibm.ccl.sca.server.websphere.messages.Messages;
import com.ibm.ccl.sca.server.websphere.plugin.SCAWebSphereServerCorePlugin;
import com.ibm.ccl.sca.server.websphere.utils.Logger;
import com.ibm.ccl.sca.server.websphere.utils.SCAModelUtil;
import com.ibm.ws.ast.st.core.model.IGenericModuleServer;
import com.ibm.ws.ast.st.core.model.IGenericModuleSupport;
import com.ibm.ws.ast.st.core.model.IWebSphereServer;
import com.ibm.ws.bla.management.core.BLACommandNotification;
import com.ibm.ws.bla.management.core.BLACommandResult;
import com.ibm.ws.bla.management.core.CommandEventHandler;
import com.ibm.ws.bla.management.core.CommandsDelegate;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.implementation.jee.JEEImplementation;
import org.apache.tuscany.sca.implementation.spring.SpringImplementation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;

public class SCAWebSphereServerBehaviour
extends CommandEventHandler
implements IGenericModuleSupport {
    public static final String SPRING_LOCATION_KEY = ".springLocation";
    public static final String SPRING_IMPL_PLUGIN_ID = "com.ibm.ccl.sca.composite.emf.spring.impl";
    public static final String CHECK_SERVER_FOR_SDO_KEY = "check_server_for_sdo_feature";
    public static final String JAVA_UI_PLUGIN_ID = "com.ibm.ccl.sca.java.ui";
    IGenericModuleServer cachedGenericServer = null;
    static CommandsDelegate commandRunnerDelegate = null;
    static Hashtable<String, String> serverTempDirs = new Hashtable();
    public static final String SPRING_ASSET_NAME_PREFIX = "assetname=";

    public SCAWebSphereServerBehaviour() throws CoreException {
        if (commandRunnerDelegate == null) {
            commandRunnerDelegate = SCAWebSphereServerBehaviour.loadBLAManagers();
        }
        if (commandRunnerDelegate == null) {
            Logger.println(0, (Object)this, "SCAWebSphereServerBehaviour()", "Error getting command runner delegate ", null);
            throw new CoreException((IStatus)new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.SCA_PUBLISHING_FAILED_ERROR));
        }
    }

    public void publishModules(IGenericModuleServer genericModuleServer, int kind, List<IModule[]> modules, List<Integer> deltaKindList, MultiStatus multi, IProgressMonitor monitor) {
        Logger.println(2, (Object)this, "publishModules(....)", "Enter.");
        if (monitor != null && monitor.isCanceled()) {
            Logger.println(2, (Object)this, "publishModules(....)", "Exiting due to monitor is null or canceled.");
            return;
        }
        if (!this.doSCAFeatureEnabledValidation(genericModuleServer.getServer(), modules, multi)) {
            Logger.println(2, (Object)this, "publishModules(....)", "Exiting due to not valid modules.");
            return;
        }
        this.cachedGenericServer = genericModuleServer;
        this.createServerTempDirectory(genericModuleServer);
        ArrayList<IModule> contributionList = new ArrayList<IModule>();
        ArrayList<Integer> contributionDeltaKindList = new ArrayList<Integer>();
        Hashtable<IModule, ArrayList<IModule[]>> childrenTable = new Hashtable<IModule, ArrayList<IModule[]>>();
        this.extractContributionsForPublish(modules, deltaKindList, contributionList, contributionDeltaKindList, childrenTable);
        Iterator<IModule> contributionItr = contributionList.iterator();
        Iterator<Integer> contributionDeltaKindItr = contributionDeltaKindList.iterator();
        boolean isPublishWithErrors = genericModuleServer.isPublishWithErrors();
        while (contributionItr.hasNext() && contributionDeltaKindItr.hasNext() && !monitor.isCanceled()) {
            IModule curContribution = contributionItr.next();
            int currentDeltaKind = contributionDeltaKindItr.next();
            if (!isPublishWithErrors && (currentDeltaKind == 1 || currentDeltaKind == 2) && !this.doContributionValidationCheck(curContribution, multi) || this.checkServerForSDO(curContribution) && !this.isSDOFeatureInstalled(genericModuleServer.getServer(), multi)) continue;
            Logger.println(2, (Object)this, "publishModules(....)", "publishing contribution: " + curContribution.getName());
            IStatus status = this.publishContribution(genericModuleServer, curContribution, currentDeltaKind, monitor);
            if (status != null) {
                multi.add(status);
                int sevirity = status.getSeverity();
                if (sevirity != 4 && sevirity != 8) {
                    ArrayList<IModule[]> list = childrenTable.get(curContribution);
                    if (list == null) continue;
                    for (IModule[] m : list) {
                        genericModuleServer.setGenericModulePublishState(m, 1);
                        if (m.length != 1) continue;
                        genericModuleServer.setGenericModuleState(m, 2);
                    }
                    continue;
                }
                Logger.println(1, (Object)this, "publishModules(....)", "publishing status is ERROR or Canceled for contribution: " + curContribution.getName());
                continue;
            }
            Logger.println(0, (Object)this, "publishModules(....)", "publishing status is null for contribution: " + curContribution.getName());
        }
        Logger.println(2, (Object)this, "publishModules(....)", "Exiting.");
    }

    protected boolean isSDOFeatureInstalled(IServer server, MultiStatus multiStatus) {
        try {
            IWebSphereServer wasServer = (IWebSphereServer)server.loadAdapter(IWebSphereServer.class, null);
            if (wasServer.getWASProductVersion("com.ibm.websphere.SDOFeatureVersion") == null) {
                multiStatus.add((IStatus)new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.PUBLISH_VALIDATION_MISSING_SDO));
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            multiStatus.add((IStatus)new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.PUBLISH_VALIDATION_MISSING_SDO));
            return false;
        }
    }

    protected boolean checkServerForSDO(IModule currentModule) {
        IPreferencesService ps = Platform.getPreferencesService();
        boolean checkSDO = ps.getBoolean(JAVA_UI_PLUGIN_ID, CHECK_SERVER_FOR_SDO_KEY, false, null);
        return checkSDO;
    }

    protected boolean doContributionValidationCheck(IModule curContribution, MultiStatus mStatus) {
        Logger.println(2, (Object)this, "doContributionValidationCheck() entering");
        boolean valid = true;
        MultiStatus curMStatus = new MultiStatus("com.ibm.ccl.sca.server.websphere", 4, NLS.bind((String)Messages.PUBLISH_VALIDATION_PROBLEM1, (Object[])new String[]{curContribution.getName()}), null);
        curMStatus.add((IStatus)new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.PUBLISH_VALIDATION_PROBLEM2));
        ContributionModule contribution = (ContributionModule)curContribution.loadAdapter(ContributionModule.class, null);
        if (contribution == null) {
            Logger.println(0, (Object)this, "doContributionValidationCheck()", "Can't load the contribution adapter");
            return true;
        }
        ISCAContribution iSCAContribution = contribution.getISCAContribution();
        List<ISCAArtifact<?>> artifacts = SCAModelUtil.resolveArtifactsInContribution(iSCAContribution);
        if (artifacts != null) {
            for (ISCAArtifact<?> artifact : artifacts) {
                IResource resource = artifact.getResource();
                if (resource == null) continue;
                int errorLevel = -1;
                try {
                    IMarker[] markers;
                    if ("wsdl".equals(resource.getFileExtension())) {
                        WSDLResolver wsdlResolver = new WSDLResolver(resource);
                        wsdlResolver.run(null);
                        List wsdlResources = wsdlResolver.getResources();
                        for (IResource wsdlResource : wsdlResources) {
                            IMarker[] markers2;
                            if (wsdlResource == null || (errorLevel = wsdlResource.findMaxProblemSeverity(null, true, 0)) != 2) continue;
                            valid = false;
                            IMarker[] iMarkerArray = markers2 = wsdlResource.findMarkers(null, true, 0);
                            int n = markers2.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IMarker marker = iMarkerArray[n2];
                                if (marker.getAttribute("severity") != null && (Integer)marker.getAttribute("severity") == 2) {
                                    Status status = new Status(4, "com.ibm.ccl.sca.server.websphere", marker.getAttribute("message").toString());
                                    curMStatus.add((IStatus)status);
                                }
                                ++n2;
                            }
                        }
                        continue;
                    }
                    errorLevel = resource.findMaxProblemSeverity(null, true, 0);
                    if (errorLevel != 2) continue;
                    valid = false;
                    IMarker[] iMarkerArray = markers = resource.findMarkers(null, true, 0);
                    int n = markers.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IMarker marker = iMarkerArray[n3];
                        if (marker.getAttribute("severity") != null && (Integer)marker.getAttribute("severity") == 2) {
                            Status status = new Status(4, "com.ibm.ccl.sca.server.websphere", marker.getAttribute("message").toString());
                            curMStatus.add((IStatus)status);
                        }
                        ++n3;
                    }
                }
                catch (CoreException coreException) {
                    Logger.println(0, (Object)this, "doContributionValidationCheck()", "Exception when find problem markers:" + resource.getFullPath().toOSString());
                }
            }
        }
        if (!valid) {
            mStatus.add((IStatus)curMStatus);
        }
        Logger.println(2, (Object)this, "doContributionValidationCheck() exiting with:" + valid);
        return valid;
    }

    public boolean canControlModule(IModule[] modules) {
        return modules != null && modules.length > 0;
    }

    public IStatus canModifyModules(IModule module) {
        if (module != null) {
            return new Status(0, "com.ibm.ccl.sca.server.websphere", Messages.SCA_PUBLISHING_SUCCESS_INFO);
        }
        return new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.SCA_PUBLISHING_FAILED_ERROR);
    }

    public IModule[] getRootModules(IModule module) {
        if (module == null) {
            return new IModule[0];
        }
        if ("sca.contribution".equals(module.getModuleType().getId())) {
            return new IModule[]{module};
        }
        return new IModule[0];
    }

    public void restartModule(IModule[] modules, IProgressMonitor monitor) throws CoreException {
        if (modules == null || modules.length == 0) {
            return;
        }
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        try {
            this.stopBLA(this.cachedGenericServer.getServer(), modules[0], monitor);
            this.cachedGenericServer.setGenericModuleState(modules, 4);
            this.startBLA(this.cachedGenericServer.getServer(), modules[0], monitor);
            this.cachedGenericServer.setGenericModuleState(modules, 2);
        }
        catch (Throwable throwable) {
            Logger.println(0, (Object)this, "restartModule)", "Failed to restart module " + modules[0], throwable);
        }
    }

    public void stopModule(IModule[] modules, IProgressMonitor monitor) throws CoreException {
        if (modules == null || modules.length == 0) {
            return;
        }
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        try {
            this.stopBLA(this.cachedGenericServer.getServer(), modules[0], monitor);
            this.cachedGenericServer.setGenericModuleState(modules, 4);
        }
        catch (Throwable throwable) {
            Logger.println(0, (Object)this, "stopModule)", "Failed to stop module " + modules[0], throwable);
        }
    }

    public void startModule(IModule[] modules, IProgressMonitor monitor) throws CoreException {
        if (modules == null || modules.length == 0) {
            return;
        }
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        try {
            this.startBLA(this.cachedGenericServer.getServer(), modules[0], monitor);
            this.cachedGenericServer.setGenericModuleState(modules, 2);
        }
        catch (Throwable throwable) {
            Logger.println(0, (Object)this, "startModule)", "Failed to start module " + modules[0], throwable);
        }
    }

    public void handleNotification(BLACommandNotification notification) {
        BLACommandResult commandResult = notification.getCommandResult();
        Throwable throwable = commandResult.getException();
        if (throwable != null) {
            Logger.println(0, (Object)this, "handleNotification()", "Exception was thrown running BLA command " + notification.getCommandName(), throwable);
        }
    }

    public List<ISourceContainer> getDebugSourceContainers(List<IModule> modules) {
        return null;
    }

    public List<IJavaProject> getJavaSourceProjects(List<IModule> modules) {
        Logger.println(2, (Object)this, "getJavaSourceProjects(.)", "Enter.");
        ArrayList<IJavaProject> list = new ArrayList<IJavaProject>();
        if (modules != null) {
            for (IModule module : modules) {
                if (module == null || !module.getModuleType().getId().equals("sca.contribution")) continue;
                ContributionModule contribution = (ContributionModule)module.loadAdapter(ContributionModule.class, null);
                if (contribution == null) {
                    Logger.println(0, (Object)this, "getJavaSourceProjects()", "Can't loadAdapter contribution: " + module.getName());
                    continue;
                }
                List projects = contribution.getReferencedProjects();
                for (IProject project : projects) {
                    try {
                        IJavaProject javaProject;
                        if (project == null || !project.hasNature("org.eclipse.jdt.core.javanature") || list.contains(javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature"))) continue;
                        Logger.println(3, (Object)this, "getJavaSourceProjects(.)", "Add project: " + project.getName());
                        list.add(javaProject);
                    }
                    catch (Exception e) {
                        Logger.println(0, (Object)this, "getJavaSourceProjects(.)", "Exception.", (Throwable)e);
                    }
                }
            }
        } else {
            Logger.println(0, (Object)this, "getJavaSourceProjects(.)", "modules is null.");
        }
        Logger.println(2, (Object)this, "getJavaSourceProjects(.)", "Exiting.");
        return list;
    }

    public int getModuleState(IGenericModuleServer genericModuleServer, IModule[] module) {
        Logger.println(2, (Object)this, "getModuleState(..)", "Enter.");
        int state = 0;
        BLAInfo info = this.setBLAInfo(null, module[0]);
        String s = this.getBlaExecutionState(genericModuleServer.getServer(), info, null);
        if ("ExecutionState.STARTED".equals(s)) {
            state = 2;
        } else if ("ExecutionState.STOPPED".equals(s)) {
            state = 4;
        }
        Logger.println(2, (Object)this, "getModuleState(..)", "Exiting with state:" + state + ".  The command returned state of the BLA is:" + s);
        return state;
    }

    protected boolean doSCAFeatureEnabledValidation(IServer server, List<IModule[]> modules, MultiStatus multi) {
        String fepVersion;
        IWebSphereServer wasServer = (IWebSphereServer)server.loadAdapter(IWebSphereServer.class, null);
        if (wasServer == null) {
            return false;
        }
        try {
            fepVersion = wasServer.getWASProductVersion("com.ibm.websphere.SCAFeaturePackProductVersion");
        }
        catch (CoreException coreException) {
            fepVersion = null;
        }
        if (fepVersion != null) {
            for (IModule[] m : modules) {
                if (!"sca.contribution".equals(m[0].getModuleType().getId())) continue;
                IProject p = m[0].getProject();
                if (p != null) {
                    block12: {
                        IFacetedProject facetProj = ProjectFacetsManager.create((IProject)p);
                        IProjectFacet scaFepFacet = ProjectFacetsManager.getProjectFacet((String)"com.ibm.websphere.scafp");
                        IProjectFacetVersion scafp101 = scaFepFacet.getVersion("1.0.1");
                        if (facetProj.hasProjectFacet(scafp101)) break block12;
                        return true;
                    }
                    try {
                        if (this.isServerVersionRequirementMet(fepVersion)) {
                            return true;
                        }
                    }
                    catch (CoreException coreException) {
                        SCATrace.trace((Plugin)SCAWebSphereServerCorePlugin.getInstance(), (int)0, (String)"CoreException in doSCAFeaturePackEnabledValidation");
                    }
                }
                Status status = new Status(4, "com.ibm.ccl.sca.server.websphere", NLS.bind((String)Messages.PROJECT_REQUIRES_SCA_FEP101_MSG1, (Object[])new String[]{m[0].getName()}));
                multi.add((IStatus)status);
                status = new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.PROJECT_REQUIRES_SCA_FEP101_MSG2);
                multi.add((IStatus)status);
                status = new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.PROJECT_REQUIRES_SCA_FEP101_MSG3);
                multi.add((IStatus)status);
                return false;
            }
        } else {
            for (IModule[] m : modules) {
                if (!"sca.contribution".equals(m[0].getModuleType().getId())) continue;
                Status status = new Status(4, "com.ibm.ccl.sca.server.websphere", NLS.bind((String)Messages.PROJECT_REQUIRES_SCA_FEATURE_PACK_ERROR1, (Object[])new String[]{m[0].getName()}));
                multi.add((IStatus)status);
                status = new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.PROJECT_REQUIRES_SCA_FEATURE_PACK_ERROR2);
                multi.add((IStatus)status);
                status = new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.PROJECT_REQUIRES_SCA_FEATURE_PACK_ERROR3);
                multi.add((IStatus)status);
                return false;
            }
        }
        return true;
    }

    public boolean isServerVersionRequirementMet(String version) {
        if (version == null) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(version, ".");
        int count = 0;
        int firstdigit = 0;
        int seconddigit = 0;
        int thirddigit = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int digit = Integer.parseInt(token);
            if (count == 0) {
                firstdigit = digit;
                if (digit < 1) {
                    return false;
                }
            }
            if (count == 1) {
                seconddigit = digit;
            }
            if (count == 2) {
                thirddigit = digit;
            }
            if (count == 3 && firstdigit == 1 && seconddigit == 0 && thirddigit < 1) {
                return false;
            }
            ++count;
        }
        return true;
    }

    protected void extractContributionsForPublish(List<IModule[]> modules, List<Integer> deltaKindList, ArrayList<IModule> contributionList, ArrayList<Integer> contributionDeltaKindList, Hashtable<IModule, ArrayList<IModule[]>> childrenTable) {
        Logger.println(2, (Object)this, "extractContributionsForPublish(....)", "Enter.");
        Iterator<IModule[]> modulesArrayIterator = modules.iterator();
        Iterator<Integer> deltaKindIterator = deltaKindList.iterator();
        block18: while (modulesArrayIterator.hasNext() && deltaKindIterator.hasNext()) {
            IModule[] module = modulesArrayIterator.next();
            Integer delta = deltaKindIterator.next();
            if (module == null || delta == null) continue;
            if (module[0] != null) {
                if (childrenTable.containsKey(module[0])) {
                    childrenTable.get(module[0]).add(module);
                } else {
                    ArrayList<IModule[]> list = new ArrayList<IModule[]>();
                    list.add(module);
                    childrenTable.put(module[0], list);
                }
            }
            int deltaInt = delta;
            if (module.length == 0) continue;
            if (module.length == 1) {
                if (module[0] != null) {
                    int index = contributionList.indexOf(module[0]);
                    if (index == -1) {
                        contributionList.add(module[0]);
                        contributionDeltaKindList.add(delta);
                        Logger.println(3, (Object)this, "extractContributionsForPublish(....)", "adding to the root list. " + module[0].getName() + " delta=" + delta);
                        continue;
                    }
                    Integer storedDelta = contributionDeltaKindList.get(index);
                    if (storedDelta != null) {
                        switch (deltaInt) {
                            case 0: {
                                Logger.println(3, (Object)this, "extractContributionsForPublish(....)", "Contribution not changed. " + module[0].getName());
                                break;
                            }
                            case 1: {
                                Logger.println(3, (Object)this, "extractContributionsForPublish(....)", String.valueOf(module[0].getName()) + " changed to ADDED");
                            }
                            case 2: {
                                if (deltaInt == 2) {
                                    Logger.println(3, (Object)this, "extractContributionsForPublish(....)", String.valueOf(module[0].getName()) + " changed to Changed");
                                }
                            }
                            case 3: {
                                if (deltaInt == 3) {
                                    Logger.println(3, (Object)this, "extractContributionsForPublish(....)", String.valueOf(module[0].getName()) + " changed to Removed");
                                }
                                contributionDeltaKindList.set(index, delta);
                            }
                        }
                        continue;
                    }
                    Logger.println(0, (Object)this, "extractContributionsForPublish(....)", "contributionDeltaKindList has null for " + module[0].getName());
                    continue;
                }
                Logger.println(0, (Object)this, "extractContributionsForPublish(....)", "The incoming root module is null.");
                continue;
            }
            IModule rootModule = module[0];
            if (rootModule != null) {
                int index = contributionList.indexOf(rootModule);
                if (index == -1) {
                    switch (deltaInt) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            Logger.println(3, (Object)this, "extractContributionsForPublish(....)", "Child of " + rootModule.getName() + " ADDED");
                        }
                        case 2: {
                            if (deltaInt == 2) {
                                Logger.println(3, (Object)this, "extractContributionsForPublish(....)", "Child of " + rootModule.getName() + " CHANGED");
                            }
                        }
                        case 3: {
                            if (deltaInt == 3) {
                                Logger.println(3, (Object)this, "extractContributionsForPublish(....)", "Child of " + rootModule.getName() + " CHANGED");
                            }
                            contributionList.add(rootModule);
                            contributionDeltaKindList.add(2);
                            Logger.println(3, (Object)this, "extractContributionsForPublish(....)", "Add " + rootModule.getName() + " to the root list due to changes in child");
                        }
                    }
                    continue;
                }
                switch (deltaInt) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        Logger.println(3, (Object)this, "extractContributionsForPublish(....)", "Child of " + rootModule.getName() + " ADDED");
                    }
                    case 2: {
                        if (deltaInt == 2) {
                            Logger.println(3, (Object)this, "extractContributionsForPublish(....)", "Child of " + rootModule.getName() + " CHANGED");
                        }
                    }
                    case 3: {
                        Integer storedDInteger;
                        if (deltaInt == 3) {
                            Logger.println(3, (Object)this, "extractContributionsForPublish(....)", "Child of " + rootModule.getName() + " REMOVED");
                        }
                        if ((storedDInteger = contributionDeltaKindList.get(index)) != null) {
                            int sd = storedDInteger;
                            if (sd != 0) continue block18;
                            contributionDeltaKindList.set(index, 2);
                            Logger.println(3, (Object)this, "extractContributionsForPublish(....)", "Change " + rootModule.getName() + " in the root list to CHANGED due to changes in child");
                            break;
                        }
                        Logger.println(0, (Object)this, "extractContributionsForPublish(....)", "contributionDeltaKindList has null for " + rootModule.getName());
                    }
                }
                continue;
            }
            Logger.println(0, (Object)this, "extractContributionsForPublish(....)", "The root module of an incoming module is null.");
        }
        Logger.println(2, (Object)this, "extractContributionsForPublish(....)", "Exiting.");
    }

    protected IStatus publishContribution(IGenericModuleServer genericModuleServer, IModule currentModule, int currentDeltaKind, IProgressMonitor monitor) {
        if (currentModule == null) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", 0, Messages.NO_MODULES_TO_PUBLISH_ERROR, null);
        }
        if (monitor != null && monitor.isCanceled()) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.SCA_PUBLISHING_CANCEL_ERROR);
        }
        IStatus status = null;
        switch (currentDeltaKind) {
            case 1: {
                status = this.publishAdd(genericModuleServer, currentModule, monitor);
                break;
            }
            case 2: {
                status = this.publishUpdate(genericModuleServer, currentModule, monitor);
                break;
            }
            case 0: {
                status = this.publishNoChange(genericModuleServer, currentModule, monitor);
                break;
            }
            case 3: {
                status = this.publishRemove(genericModuleServer, currentModule, monitor);
                break;
            }
            default: {
                status = new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.SCA_PUBLISHING_FAILED_ERROR);
            }
        }
        return status;
    }

    protected IStatus publishAdd(IGenericModuleServer genericModuleServer, IModule currentModule, IProgressMonitor monitor) {
        if (currentModule == null) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", 0, Messages.NO_MODULES_TO_PUBLISH_ERROR, null);
        }
        ContributionModule contribution = (ContributionModule)currentModule.loadAdapter(ContributionModule.class, null);
        if (contribution == null) {
            SCATrace.trace((Plugin)SCAWebSphereServerCorePlugin.getInstance(), (int)0, (String)"The contribution is null in publishAdd().");
            Status status = new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.PUBLISH_ERROR_CONTRIBUTION_IS_NULL);
            return status;
        }
        Boolean[] usedImplementations = new Boolean[1];
        List<String> jeeArchives = this.navigateContribution(contribution, usedImplementations);
        boolean springImplementationUsed = usedImplementations[0];
        List earProjectList = contribution.getReferencedEARProjects(jeeArchives);
        int earIndex = this.detectedEARRepublish(earProjectList, genericModuleServer);
        if (earIndex >= 0) {
            Status status = new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.bind((String)Messages.PUBLISH_ERROR_CONTRIBUTION_CONTAINS_PUBLISHED_EARS, (Object)((IProject)earProjectList.get(earIndex)).getName()));
            return status;
        }
        if (monitor != null && monitor.isCanceled()) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.SCA_PUBLISHING_CANCEL_ERROR);
        }
        String archiveFilename = String.valueOf(this.getModuleAsIdentifierName(currentModule)) + ".jar";
        IPath archivePath = this.calculateArchivePath(genericModuleServer, archiveFilename);
        IStatus status = this.createArchiveFile(currentModule, archivePath);
        if (!status.isOK()) {
            return status;
        }
        MultiStatus multiStatus = new MultiStatus("com.ibm.ccl.sca.server.websphere", 0, Messages.SCA_PUBLISHING_FAILED_ERROR, null);
        if (archivePath != null && !archivePath.isEmpty()) {
            String cuID;
            BLAInfo blaInfo = this.setBLAInfo(archivePath, currentModule);
            status = this.publishSCAContribution(genericModuleServer, archivePath, blaInfo, currentModule, 102, monitor);
            if (status != null) {
                multiStatus.add(status);
            }
            if (!status.isOK()) {
                return status;
            }
            if (springImplementationUsed) {
                String springAssetName = this.createSpringAssetIfNecessary(genericModuleServer, currentModule, blaInfo, monitor, multiStatus);
                if (springAssetName == null) {
                    this.publishSCAContribution(genericModuleServer, archivePath, blaInfo, currentModule, 103, monitor);
                    return multiStatus;
                }
                blaInfo.getAssetOptions().put("relationship", SPRING_ASSET_NAME_PREFIX + springAssetName + ".jar");
                status = this.publishSCAContribution(genericModuleServer, archivePath, blaInfo, currentModule, 104, monitor);
            } else {
                status = this.publishSCAContribution(genericModuleServer, archivePath, blaInfo, currentModule, 104, monitor);
            }
            if (!status.isOK()) {
                IStatus cleanupStatus;
                if (monitor.isCanceled()) {
                    monitor = new NullProgressMonitor();
                }
                if ((cleanupStatus = this.publishSCAContribution(genericModuleServer, archivePath, blaInfo, currentModule, 105, monitor)) != null && !cleanupStatus.isOK()) {
                    Status failedCleaupAssetStatus = new Status(4, "com.ibm.ccl.sca.server.websphere", 0, Messages.CLEANUP_DELETE_ASSET_ON_FAILED_PUBLISH_ERROR, null);
                    multiStatus.add((IStatus)failedCleaupAssetStatus);
                }
                if ((cleanupStatus = this.publishSCAContribution(genericModuleServer, archivePath, blaInfo, currentModule, 103, monitor)) != null && !cleanupStatus.isOK()) {
                    Status failedCleaupStatus = new Status(4, "com.ibm.ccl.sca.server.websphere", 0, Messages.CLEANUP_DELETE_BLA_ON_FAILED_PUBLISH_ERROR, null);
                    multiStatus.add((IStatus)failedCleaupStatus);
                }
                SCAWebSphereServerCorePlugin.getInstance().getLog().log((IStatus)multiStatus);
                return status;
            }
            ArrayList<IProject> assetCreatedProjects = new ArrayList<IProject>();
            ArrayList<IProject> cuCreatedProjects = new ArrayList<IProject>();
            for (IProject proj : earProjectList) {
                Iterator earBLAInfo = this.setEARBLAInfo(archivePath, currentModule, proj);
                String earFilename = String.valueOf(proj.getName()) + ".ear";
                IPath earPath = this.calculateArchivePath(genericModuleServer, earFilename);
                ExportImportUtil.exportEAR((IProject)proj, (IProgressMonitor)monitor, (IPath)earPath);
                status = this.publishSCAContribution(genericModuleServer, earPath, (BLAInfo)((Object)earBLAInfo), currentModule, 104, monitor);
                if (status == null || !status.isOK()) break;
                multiStatus.add(status);
                assetCreatedProjects.add(proj);
                cuID = "WebSphere:cuname=" + proj.getName();
                ((BLAInfo)((Object)earBLAInfo)).setCuID(cuID);
                status = this.publishSCAContribution(genericModuleServer, earPath, (BLAInfo)((Object)earBLAInfo), currentModule, 106, monitor);
                if (status == null || !status.isOK()) break;
                multiStatus.add(status);
                cuCreatedProjects.add(proj);
            }
            if (!status.isOK()) {
                Object earBLAInfo;
                if (monitor.isCanceled()) {
                    monitor = new NullProgressMonitor();
                }
                IStatus cleanupStatus = null;
                for (IProject proj : cuCreatedProjects) {
                    earBLAInfo = this.setEARBLAInfo(archivePath, currentModule, proj);
                    String cuID2 = "WebSphere:cuname=" + proj.getName();
                    ((BLAInfo)earBLAInfo).setCuID(cuID2);
                    cleanupStatus = this.publishSCAContribution(genericModuleServer, null, (BLAInfo)earBLAInfo, currentModule, 107, monitor);
                    if (cleanupStatus == null) continue;
                    multiStatus.add(cleanupStatus);
                }
                for (IProject proj : assetCreatedProjects) {
                    earBLAInfo = this.setEARBLAInfo(archivePath, currentModule, proj);
                    cleanupStatus = this.publishSCAContribution(genericModuleServer, null, (BLAInfo)earBLAInfo, currentModule, 105, monitor);
                    if (cleanupStatus == null) continue;
                    multiStatus.add(cleanupStatus);
                }
                cleanupStatus = this.publishSCAContribution(genericModuleServer, archivePath, blaInfo, currentModule, 105, monitor);
                if (cleanupStatus != null && !cleanupStatus.isOK()) {
                    Status failedCleaupAssetStatus = new Status(4, "com.ibm.ccl.sca.server.websphere", 0, Messages.CLEANUP_DELETE_ASSET_ON_FAILED_PUBLISH_ERROR, null);
                    multiStatus.add((IStatus)failedCleaupAssetStatus);
                }
                if ((cleanupStatus = this.publishSCAContribution(genericModuleServer, archivePath, blaInfo, currentModule, 103, monitor)) != null && !cleanupStatus.isOK()) {
                    Status failedCleaupStatus = new Status(4, "com.ibm.ccl.sca.server.websphere", 0, Messages.CLEANUP_DELETE_BLA_ON_FAILED_PUBLISH_ERROR, null);
                    multiStatus.add((IStatus)failedCleaupStatus);
                }
                SCAWebSphereServerCorePlugin.getInstance().getLog().log((IStatus)multiStatus);
                return status;
            }
            List<QName> compositeQNamesList = this.getAllDeployableCompositeQnames(currentModule);
            ArrayList<String> deployedCUsList = new ArrayList<String>();
            for (QName qName : compositeQNamesList) {
                String currentQName = qName.toString();
                cuID = "WebSphere:cuname=" + qName.getLocalPart();
                blaInfo.setDeployableUnits(currentQName);
                blaInfo.setCuID(cuID);
                status = this.publishSCAContribution(genericModuleServer, archivePath, blaInfo, currentModule, 106, monitor);
                if (status == null || !status.isOK()) break;
                multiStatus.add(status);
                deployedCUsList.add(cuID);
            }
            if (!status.isOK()) {
                IStatus cleanupStatus;
                if (monitor.isCanceled()) {
                    monitor = new NullProgressMonitor();
                }
                if ((cleanupStatus = this.publishSCAContribution(genericModuleServer, archivePath, blaInfo, currentModule, 105, monitor)) != null && !cleanupStatus.isOK()) {
                    Status failedCleaupAssetStatus = new Status(4, "com.ibm.ccl.sca.server.websphere", 0, Messages.CLEANUP_DELETE_ASSET_ON_FAILED_PUBLISH_ERROR, null);
                    multiStatus.add((IStatus)failedCleaupAssetStatus);
                }
                if ((cleanupStatus = this.publishSCAContribution(genericModuleServer, archivePath, blaInfo, currentModule, 103, monitor)) != null && !cleanupStatus.isOK()) {
                    Status failedCleaupBLAStatus = new Status(4, "com.ibm.ccl.sca.server.websphere", 0, Messages.CLEANUP_DELETE_BLA_ON_FAILED_PUBLISH_ERROR, null);
                    multiStatus.add((IStatus)failedCleaupBLAStatus);
                }
                SCAWebSphereServerCorePlugin.getInstance().getLog().log((IStatus)multiStatus);
                return status;
            }
            status = this.publishSCAContribution(genericModuleServer, archivePath, blaInfo, currentModule, 108, monitor);
            if (status != null) {
                multiStatus.add(status);
            }
            this.deleteTemporaryExportedArchives(genericModuleServer.getServer().getId(), monitor);
        }
        return multiStatus;
    }

    protected List<String> navigateContribution(ContributionModule contribution, Boolean[] usedImplementations) {
        boolean springImplementationUsed = false;
        ArrayList<String> jeeArchives = new ArrayList<String>();
        try {
            List<ISCAComposite> composites = SCAModelUtil.getISCAComposites(contribution.getISCAContribution());
            for (ISCAComposite c : composites) {
                Composite composite = (Composite)c.getModelObject();
                List components = composite.getComponents();
                for (Component component : components) {
                    Implementation impl = component.getImplementation();
                    if (impl instanceof JEEImplementation) {
                        JEEImplementation jeeImpl = (JEEImplementation)impl;
                        String archive = jeeImpl.getArchive();
                        if (archive == null || archive.length() == 0) continue;
                        jeeArchives.add(archive);
                        continue;
                    }
                    if (!(impl instanceof SpringImplementation)) continue;
                    springImplementationUsed = true;
                }
            }
        }
        catch (CoreException e) {
            SCATrace.trace((Plugin)SCAWebSphereServerCorePlugin.getInstance(), (int)0, (Throwable)e);
        }
        usedImplementations[0] = springImplementationUsed;
        return jeeArchives;
    }

    protected String createSpringAssetIfNecessary(IGenericModuleServer genericModuleServer, IModule currentModule, BLAInfo blaInfo, IProgressMonitor monitor, MultiStatus multiStatus) {
        BLAInfo springAssetBLAInfo;
        IStatus status;
        PreferencesState ps = new PreferencesState(SPRING_IMPL_PLUGIN_ID);
        String springAssetLocation = ps.getValue("com.ibm.ccl.sca.composite.emf.spring.impl.springLocation", "", currentModule.getProject());
        if (springAssetLocation == null || springAssetLocation.length() == 0) {
            Status status2 = new Status(4, "com.ibm.ccl.sca.server.websphere", NLS.bind((String)Messages.CONTRIBUTION_REQUIRES_SPRING_ASSET_CONFIG, (Object[])new String[]{currentModule.getName()}));
            SCAWebSphereServerCorePlugin.getInstance().getLog().log((IStatus)status2);
            multiStatus.add((IStatus)status2);
            return null;
        }
        Path springAssetPath = new Path(springAssetLocation);
        String springAssetJarName = springAssetPath.lastSegment();
        IServer server = genericModuleServer.getServer();
        List<String> retAssetList = this.getAssetList(server, springAssetJarName, monitor);
        int dotIndex = springAssetJarName.lastIndexOf(46);
        if (dotIndex != -1) {
            springAssetJarName = springAssetJarName.substring(0, dotIndex);
        }
        if (!(retAssetList != null && retAssetList.size() != 0 || (status = this.publishSCAContribution(genericModuleServer, (IPath)springAssetPath, springAssetBLAInfo = this.setSpringAssetBLAInfo((IPath)springAssetPath, currentModule, springAssetJarName), currentModule, 104, monitor)).isOK())) {
            SCAWebSphereServerCorePlugin.getInstance().getLog().log(status);
            multiStatus.add(status);
            return null;
        }
        return springAssetJarName;
    }

    protected int detectedEARRepublish(List<IProject> earProjectList, IGenericModuleServer genericModuleServer) {
        IServer server = genericModuleServer.getServer();
        IModule[] modules = server.getModules();
        int earCounter = 0;
        for (IProject earProject : earProjectList) {
            int i = 0;
            while (i < modules.length) {
                if (earProject.getName().equals(modules[i].getProject().getName())) {
                    return earCounter;
                }
                ++i;
            }
            ++earCounter;
        }
        return -1;
    }

    protected IPath calculateArchivePath(IGenericModuleServer genericModuleServer, String archiveFilename) {
        String serverId = genericModuleServer.getServer().getId();
        IPath path = this.getServerTempDirectory(serverId);
        IPath fullpath = path.append(archiveFilename);
        return fullpath;
    }

    protected List<String> getDeployedCUsList(IModule currentModule) {
        Hashtable<String, ArrayList<String>> deployedCompositionUnitIDs = new Hashtable<String, ArrayList<String>>();
        List<QName> compositeQNamesList = this.getAllCompositeQnames(currentModule);
        BLAInfo blaInfo = this.setBLAInfo(null, currentModule);
        ArrayList<String> deployedCUsList = new ArrayList<String>();
        deployedCompositionUnitIDs.put(blaInfo.getBlaID(), deployedCUsList);
        if (compositeQNamesList == null || compositeQNamesList.isEmpty()) {
            deployedCUsList.add(blaInfo.getCuID());
            return deployedCUsList;
        }
        for (QName qName : compositeQNamesList) {
            String qNameLocalPart;
            String cuID = null;
            cuID = qName != null ? ((qNameLocalPart = qName.getLocalPart()) != null && !qNameLocalPart.equals("") ? "WebSphere:cuname=" + qNameLocalPart : blaInfo.getCuID()) : blaInfo.getCuID();
            deployedCUsList.add(cuID);
        }
        return deployedCUsList;
    }

    protected IStatus publishRemove(IGenericModuleServer genericModuleServer, IModule currentModule, IProgressMonitor monitor) {
        if (currentModule == null) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", 0, Messages.NO_MODULES_TO_PUBLISH_ERROR, null);
        }
        if (monitor != null && monitor.isCanceled()) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.SCA_PUBLISHING_CANCEL_ERROR);
        }
        MultiStatus multiStatus = new MultiStatus("com.ibm.ccl.sca.server.websphere", 0, Messages.SCA_PUBLISHING_FAILED_ERROR, null);
        IPath archivePath = null;
        BLAInfo blaInfo = this.setBLAInfo(archivePath, currentModule);
        IStatus status = this.publishSCAContribution(genericModuleServer, archivePath, blaInfo, currentModule, 109, monitor);
        if (status != null) {
            multiStatus.add(status);
        }
        List<String> deployedCUsList = this.getDeployedCUsList(currentModule);
        for (String deployeCUid : deployedCUsList) {
            blaInfo.setCuID(deployeCUid);
            status = this.publishSCAContribution(genericModuleServer, archivePath, blaInfo, currentModule, 107, monitor);
            if (status == null) continue;
            multiStatus.add(status);
        }
        ContributionModule contribution = (ContributionModule)currentModule.loadAdapter(ContributionModule.class, null);
        if (contribution == null) {
            SCATrace.trace((Plugin)SCAWebSphereServerCorePlugin.getInstance(), (int)0, (String)"The contribution is null");
            SCAWebSphereServerCorePlugin.getInstance().getLog().log((IStatus)multiStatus);
            return status;
        }
        Boolean[] usedImplementations = new Boolean[1];
        List<String> jeeArchives = this.navigateContribution(contribution, usedImplementations);
        List projectList = contribution.getReferencedEARProjects(jeeArchives);
        for (IProject proj : projectList) {
            BLAInfo earBLAInfo = this.setEARBLAInfo(archivePath, currentModule, proj);
            String cuID = "WebSphere:cuname=" + proj.getName();
            earBLAInfo.setCuID(cuID);
            status = this.publishSCAContribution(genericModuleServer, null, earBLAInfo, currentModule, 107, monitor);
            if (status != null) {
                multiStatus.add(status);
            }
            if ((status = this.publishSCAContribution(genericModuleServer, null, earBLAInfo, currentModule, 105, monitor)) == null) continue;
            multiStatus.add(status);
        }
        status = this.deleteAllCompositionUnits(genericModuleServer, blaInfo, monitor);
        if (status != null) {
            multiStatus.add(status);
        }
        if ((status = this.publishSCAContribution(genericModuleServer, archivePath, blaInfo, currentModule, 105, monitor)) != null) {
            multiStatus.add(status);
        }
        if ((status = this.publishSCAContribution(genericModuleServer, archivePath, blaInfo, currentModule, 103, monitor)) != null) {
            multiStatus.add(status);
        }
        this.deleteTemporaryExportedArchives(genericModuleServer.getServer().getId(), monitor);
        genericModuleServer.setGenericModulePublishState(new IModule[]{currentModule}, 1);
        genericModuleServer.setGenericModuleState(new IModule[]{currentModule}, 1);
        return multiStatus;
    }

    protected IStatus publishUpdate(IGenericModuleServer genericModuleServer, IModule currentModule, IProgressMonitor monitor) {
        if (currentModule == null) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", 0, Messages.NO_MODULES_TO_PUBLISH_ERROR, null);
        }
        if (monitor != null && monitor.isCanceled()) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.SCA_PUBLISHING_CANCEL_ERROR);
        }
        String archiveFilename = String.valueOf(this.getModuleAsIdentifierName(currentModule)) + ".jar";
        IPath archivePath = this.calculateArchivePath(genericModuleServer, archiveFilename);
        IStatus status = this.createArchiveFile(currentModule, archivePath);
        if (!status.isOK()) {
            return status;
        }
        if (archivePath != null && !archivePath.isEmpty()) {
            BLAInfo blaInfo = this.setBLAInfo(archivePath, currentModule);
            status = this.publishSCAContribution(genericModuleServer, archivePath, blaInfo, currentModule, 110, monitor);
        }
        if (status.isOK()) {
            this.deleteTemporaryExportedArchives(genericModuleServer.getServer().getId(), monitor);
        }
        return status;
    }

    protected IStatus publishNoChange(IGenericModuleServer genericModuleServer, IModule currentModule, IProgressMonitor monitor) {
        return new Status(0, "com.ibm.ccl.sca.server.websphere", 0, Messages.NO_CHANGE_FOR_PUBLISHING_INFO, null);
    }

    protected IStatus publishRemoveAsset(IGenericModuleServer genericModuleServer, IModule currentModule, IProgressMonitor monitor) {
        if (currentModule == null) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", 0, Messages.NO_MODULES_TO_PUBLISH_ERROR, null);
        }
        if (monitor != null && monitor.isCanceled()) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.SCA_PUBLISHING_CANCEL_ERROR);
        }
        BLAInfo blaInfo = this.setBLAInfo(null, currentModule);
        return this.publishSCAContribution(genericModuleServer, null, blaInfo, currentModule, 105, monitor);
    }

    protected IStatus publishRemoveCompositionUnit(IGenericModuleServer genericModuleServer, IModule currentModule, IProgressMonitor monitor) {
        if (currentModule == null) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", 0, Messages.NO_MODULES_TO_PUBLISH_ERROR, null);
        }
        if (monitor != null && monitor.isCanceled()) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.SCA_PUBLISHING_CANCEL_ERROR);
        }
        BLAInfo blaInfo = this.setBLAInfo(null, currentModule);
        return this.publishSCAContribution(genericModuleServer, null, blaInfo, currentModule, 105, monitor);
    }

    protected IStatus publishSCAContribution(IGenericModuleServer genericModuleServer, IPath archivePath, BLAInfo blaInfo, IModule currentModule, int publishingOperationRequired, IProgressMonitor monitor) {
        if (currentModule == null) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", 0, Messages.NO_MODULES_TO_PUBLISH_ERROR, null);
        }
        if (monitor != null && monitor.isCanceled()) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.SCA_PUBLISHING_CANCEL_ERROR);
        }
        IStatus status = null;
        try {
            IServer server = genericModuleServer.getServer();
            switch (publishingOperationRequired) {
                case 102: {
                    status = this.publishAddBLA(server, blaInfo, monitor);
                    break;
                }
                case 108: {
                    status = this.publishStartBLA(server, blaInfo, monitor);
                    break;
                }
                case 109: {
                    status = this.publishStopBLA(server, blaInfo, monitor);
                    break;
                }
                case 103: {
                    status = this.publishDeleteBLA(server, blaInfo, monitor);
                    break;
                }
                case 104: {
                    status = this.publishAddAsset(server, archivePath, blaInfo, monitor);
                    break;
                }
                case 110: {
                    status = this.publishUpdateAsset(server, archivePath, blaInfo, monitor);
                    break;
                }
                case 105: {
                    status = this.publishDeleteAsset(server, blaInfo, monitor);
                    break;
                }
                case 106: {
                    status = this.publishAddCompositionUnit(server, blaInfo, monitor);
                    break;
                }
                case 107: {
                    status = this.publishDeleteCompositionUnit(server, blaInfo, monitor);
                    break;
                }
                default: {
                    status = new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.SCA_PUBLISHING_FAILED_ERROR);
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            Logger.println(0, (Object)this, "publishSCAContribution()", "Publish SCA Contribution failed ", throwable);
        }
        return status;
    }

    protected IStatus publishAddBLA(IServer server, BLAInfo blaInfo, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.SCA_PUBLISHING_CANCEL_ERROR);
        }
        return this.createBLA(server, blaInfo, monitor);
    }

    protected IStatus publishStartBLA(IServer server, BLAInfo blaInfo, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.SCA_PUBLISHING_CANCEL_ERROR);
        }
        return this.startBLA(server, blaInfo, monitor);
    }

    protected IStatus publishStopBLA(IServer server, BLAInfo blaInfo, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.SCA_PUBLISHING_CANCEL_ERROR);
        }
        return this.stopBLA(server, blaInfo, monitor);
    }

    protected IStatus publishDeleteBLA(IServer server, BLAInfo blaInfo, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.SCA_PUBLISHING_CANCEL_ERROR);
        }
        return this.deleteBLA(server, blaInfo, monitor);
    }

    protected IStatus publishAddAsset(IServer server, IPath archivePath, BLAInfo blaInfo, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.SCA_PUBLISHING_CANCEL_ERROR);
        }
        return this.addAsset(server, archivePath, blaInfo, monitor);
    }

    protected IStatus publishUpdateAsset(IServer server, IPath archivePath, BLAInfo blaInfo, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.SCA_PUBLISHING_CANCEL_ERROR);
        }
        return this.updateAsset(server, archivePath, blaInfo, monitor);
    }

    protected IStatus publishDeleteAsset(IServer server, BLAInfo blaInfo, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.SCA_PUBLISHING_CANCEL_ERROR);
        }
        return this.deleteAsset(server, blaInfo, monitor);
    }

    protected IStatus publishAddCompositionUnit(IServer server, BLAInfo blaInfo, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.SCA_PUBLISHING_CANCEL_ERROR);
        }
        return this.addCompositionUnit(server, blaInfo, monitor);
    }

    protected IStatus publishDeleteCompositionUnit(IServer server, BLAInfo blaInfo, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.SCA_PUBLISHING_CANCEL_ERROR);
        }
        return this.deleteCompositionUnit(server, blaInfo, monitor);
    }

    private static CommandsDelegate loadBLAManagers() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("com.ibm.ws.bla.management.core", "blaManagement");
        int size = cf.length;
        ArrayList<CommandsDelegate> extendersList = new ArrayList<CommandsDelegate>(size);
        int i = 0;
        while (i < size) {
            try {
                CommandsDelegate wrapper = new CommandsDelegate(cf[i]);
                if (wrapper.getServerTypeId().equals("com.ibm.ws.ast.st.v7.server.base")) {
                    extendersList.add(wrapper);
                }
            }
            catch (Throwable throwable) {
                Logger.println(0, "loadBLAManagers()", "Failed to get or instantiate the BLA manager extension point");
            }
            ++i;
        }
        CommandsDelegate commandsDelegate2 = null;
        for (CommandsDelegate commandsDelegate2 : extendersList) {
            String serverTypeId = commandsDelegate2.getServerTypeId();
            if (serverTypeId.equals("com.ibm.ws.ast.st.v7.server.base")) break;
        }
        return commandsDelegate2;
    }

    private BLAInfo setBLAInfo(IPath archivePath, IModule module) {
        BLAInfo blaInfo = new BLAInfo();
        if (module == null) {
            return blaInfo;
        }
        String assetPath = null;
        if (archivePath != null) {
            assetPath = archivePath.toPortableString();
            blaInfo.setAssetPath(assetPath);
        }
        String supportedName = this.getModuleAsIdentifierName(module);
        blaInfo.setBlaName(supportedName);
        blaInfo.setBlaDescription("");
        blaInfo.setLocalCommandManager(false);
        blaInfo.setStorageType("FULL");
        blaInfo.setBlaID("WebSphere:blaname=" + supportedName);
        blaInfo.setCuID("WebSphere:cuname=" + supportedName);
        blaInfo.setDeployableUnits("default");
        blaInfo.setCuSourceID("WebSphere:assetname=" + supportedName + ".jar");
        blaInfo.setMapTargets("server1");
        blaInfo.setForceDelete(true);
        blaInfo.setAssetID("WebSphere:assetname=" + supportedName + ".jar");
        HashMap<String, String> cuOptions = new HashMap<String, String>();
        cuOptions.put("name", supportedName);
        cuOptions.put("description", "Composition Unit for tesing");
        blaInfo.setCuOptions(cuOptions);
        return blaInfo;
    }

    private BLAInfo setEARBLAInfo(IPath archivePath, IModule module, IProject earProject) {
        BLAInfo blaInfo = new BLAInfo();
        if (module == null || earProject == null) {
            return blaInfo;
        }
        String assetPath = null;
        if (archivePath != null) {
            assetPath = archivePath.toPortableString();
            blaInfo.setAssetPath(assetPath);
        }
        String supportedName = this.getModuleAsIdentifierName(module);
        blaInfo.setBlaName(supportedName);
        blaInfo.setBlaDescription("");
        blaInfo.setLocalCommandManager(false);
        blaInfo.setStorageType("FULL");
        blaInfo.setBlaID("WebSphere:blaname=" + supportedName);
        blaInfo.setCuID("WebSphere:cuname=" + earProject.getName());
        blaInfo.setDeployableUnits("");
        blaInfo.setCuSourceID("WebSphere:assetname=" + earProject.getName() + ".ear");
        blaInfo.setMapTargets("server1");
        blaInfo.setForceDelete(true);
        blaInfo.setAssetID("WebSphere:assetname=" + earProject.getName() + ".ear");
        HashMap<String, String> cuOptions = new HashMap<String, String>();
        cuOptions.put("name", earProject.getName());
        cuOptions.put("description", "Composition Unit for tesing");
        HashMap<String, String> appDeploymentOptions = new HashMap<String, String>();
        appDeploymentOptions.put("appname", earProject.getName());
        blaInfo.setAppDeploymentOptions(appDeploymentOptions);
        return blaInfo;
    }

    private BLAInfo setSpringAssetBLAInfo(IPath archivePath, IModule module, String springAssetName) {
        BLAInfo blaInfo = new BLAInfo();
        if (module == null || springAssetName == null) {
            return blaInfo;
        }
        String assetPath = null;
        if (archivePath != null) {
            assetPath = archivePath.toPortableString();
            blaInfo.setAssetPath(assetPath);
        }
        String supportedName = this.getModuleAsIdentifierName(module);
        blaInfo.setBlaName(supportedName);
        blaInfo.setBlaDescription("");
        blaInfo.setLocalCommandManager(false);
        blaInfo.setStorageType("FULL");
        blaInfo.setBlaID("WebSphere:blaname=" + supportedName);
        blaInfo.setCuID("WebSphere:cuname=" + springAssetName);
        blaInfo.setDeployableUnits("");
        blaInfo.setCuSourceID("WebSphere:assetname=" + springAssetName + ".jar");
        blaInfo.setMapTargets("server1");
        blaInfo.setForceDelete(true);
        blaInfo.setAssetID("WebSphere:assetname=" + springAssetName + ".jar");
        HashMap<String, String> cuOptions = new HashMap<String, String>();
        cuOptions.put("name", springAssetName);
        cuOptions.put("description", "Composition Unit for tesing");
        blaInfo.setCuOptions(cuOptions);
        return blaInfo;
    }

    private String getModuleAsIdentifierName(IModule module) {
        if (module == null) {
            return null;
        }
        String newSupportedName = module.getName();
        return this.getSupportedIdentifierName(newSupportedName);
    }

    private String getSupportedIdentifierName(String newSupportedName) {
        newSupportedName = newSupportedName.replace(' ', '_');
        newSupportedName = newSupportedName.replace('.', '_');
        newSupportedName = newSupportedName.replace('\\', '_');
        newSupportedName = newSupportedName.replace('/', '_');
        newSupportedName = newSupportedName.replace('#', '_');
        newSupportedName = newSupportedName.replace(',', '_');
        newSupportedName = newSupportedName.replace('$', '_');
        newSupportedName = newSupportedName.replace('@', '_');
        newSupportedName = newSupportedName.replace(':', '_');
        newSupportedName = newSupportedName.replace(';', '_');
        newSupportedName = newSupportedName.replace('\"', '_');
        newSupportedName = newSupportedName.replace('*', '_');
        newSupportedName = newSupportedName.replace('?', '_');
        newSupportedName = newSupportedName.replace('<', '_');
        newSupportedName = newSupportedName.replace('>', '_');
        newSupportedName = newSupportedName.replace('|', '_');
        newSupportedName = newSupportedName.replace('=', '_');
        newSupportedName = newSupportedName.replace('+', '_');
        newSupportedName = newSupportedName.replace('&', '_');
        newSupportedName = newSupportedName.replace('%', '_');
        newSupportedName = newSupportedName.replace('\'', '_');
        return newSupportedName;
    }

    private IStatus createArchiveFile(IModule module, IPath archivePath) {
        Status status = new Status(4, "com.ibm.ccl.sca.server.websphere", 0, Messages.CREATE_ARCHIVE_ERROR, null);
        if (module == null || archivePath == null) {
            Logger.println(0, (Object)this, "createArchiveFile()", "The module or the archivePath is null");
            return status;
        }
        ContributionModule contribution = (ContributionModule)module.loadAdapter(ContributionModule.class, null);
        if (contribution == null) {
            Logger.println(0, (Object)this, "createArchiveFile()", "The contribution is null");
            return status;
        }
        List projectList = contribution.getReferencedProjects();
        for (IProject proj : projectList) {
            if (!JavaUtil.hasEARFacet((IProject)proj)) continue;
            projectList.remove(proj);
        }
        List<ISCAComposite> composites = SCAModelUtil.getISCAComposites(contribution.getISCAContribution());
        try {
            DeployableArchive deployableArchiveExport = new DeployableArchive();
            status = deployableArchiveExport.createSCAContributionArchive(composites, projectList, archivePath);
        }
        catch (CoreException coreException) {
            Logger.println(0, (Object)this, "createArchiveFile()", "Create SCA archive failed ", (Throwable)coreException);
        }
        return status;
    }

    private IStatus createBLA(IServer server, BLAInfo blaInfo, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.SCA_PUBLISHING_CANCEL_ERROR);
        }
        boolean operationsSuccess = false;
        try {
            boolean localCommandManager = blaInfo.isLocalCommandManager();
            String blaName = blaInfo.getBlaName();
            String blaDescription = blaInfo.getBlaDescription();
            BLACommandResult commandResult = commandRunnerDelegate.createEmptyBLA(server, blaName, blaDescription, localCommandManager, (CommandEventHandler)this, monitor);
            if (commandResult != null) {
                operationsSuccess = commandResult.isSuccessful();
            }
        }
        catch (Throwable throwable) {
            Logger.println(1, (Object)this, "createBLA()", "Create BLA failed ", throwable);
            return new Status(2, "com.ibm.ccl.sca.server.websphere", 0, Messages.ADD_BLA_ERROR, throwable);
        }
        if (operationsSuccess) {
            return new Status(0, "com.ibm.ccl.sca.server.websphere", 0, Messages.ADD_BLA_SUCCESS_INFO, null);
        }
        return new Status(4, "com.ibm.ccl.sca.server.websphere", 0, Messages.ADD_BLA_ERROR, null);
    }

    private IStatus startBLA(IServer server, BLAInfo blaInfo, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.SCA_PUBLISHING_CANCEL_ERROR);
        }
        boolean operationsSuccess = false;
        try {
            boolean localCommandManager = blaInfo.isLocalCommandManager();
            String blaID = blaInfo.getBlaID();
            BLACommandResult commandResult = commandRunnerDelegate.startBLA(server, blaID, localCommandManager, (CommandEventHandler)this, monitor);
            if (commandResult != null) {
                operationsSuccess = commandResult.isSuccessful();
            }
        }
        catch (Throwable throwable) {
            Logger.println(0, (Object)this, "startBLA()", "Start BLA failed ", throwable);
            return new Status(4, "com.ibm.ccl.sca.server.websphere", 0, Messages.START_BLA_ERROR, throwable);
        }
        if (operationsSuccess) {
            return new Status(0, "com.ibm.ccl.sca.server.websphere", 0, Messages.START_BLA_SUCCESS_INFO, null);
        }
        return new Status(4, "com.ibm.ccl.sca.server.websphere", 0, Messages.START_BLA_ERROR, null);
    }

    private IStatus startBLA(IServer server, IModule module, IProgressMonitor monitor) {
        if (module == null) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", 0, Messages.NO_MODULES_TO_PUBLISH_ERROR, null);
        }
        if (monitor != null && monitor.isCanceled()) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.SCA_PUBLISHING_CANCEL_ERROR);
        }
        boolean operationsSuccess = false;
        try {
            String supportedName = this.getModuleAsIdentifierName(module);
            boolean localCommandManager = false;
            String blaID = "WebSphere:blaname=" + supportedName;
            BLACommandResult commandResult = commandRunnerDelegate.startBLA(server, blaID, localCommandManager, (CommandEventHandler)this, monitor);
            if (commandResult != null) {
                operationsSuccess = commandResult.isSuccessful();
            }
        }
        catch (Throwable throwable) {
            Logger.println(0, (Object)this, "startBLA()", "Start BLA failed ", throwable);
            return new Status(4, "com.ibm.ccl.sca.server.websphere", 0, Messages.START_BLA_ERROR, throwable);
        }
        if (operationsSuccess) {
            return new Status(0, "com.ibm.ccl.sca.server.websphere", 0, Messages.START_BLA_SUCCESS_INFO, null);
        }
        return new Status(4, "com.ibm.ccl.sca.server.websphere", 0, Messages.START_BLA_ERROR, null);
    }

    private IStatus stopBLA(IServer server, BLAInfo blaInfo, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.SCA_PUBLISHING_CANCEL_ERROR);
        }
        boolean operationsSuccess = false;
        try {
            boolean localCommandManager = blaInfo.isLocalCommandManager();
            String blaID = blaInfo.getBlaID();
            BLACommandResult commandResult = commandRunnerDelegate.stopBLA(server, blaID, localCommandManager, (CommandEventHandler)this, monitor);
            if (commandResult != null) {
                operationsSuccess = commandResult.isSuccessful();
            }
        }
        catch (Throwable throwable) {
            Logger.println(0, (Object)this, "stopBLA()", "Stop BLA failed ", throwable);
            return new Status(4, "com.ibm.ccl.sca.server.websphere", 0, Messages.STOP_BLA_ERROR, throwable);
        }
        if (operationsSuccess) {
            return new Status(0, "com.ibm.ccl.sca.server.websphere", 0, Messages.STOP_BLA_SUCCESS_INFO, null);
        }
        return new Status(4, "com.ibm.ccl.sca.server.websphere", 0, Messages.STOP_BLA_ERROR, null);
    }

    private IStatus stopBLA(IServer server, IModule module, IProgressMonitor monitor) {
        if (module == null) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", 0, Messages.NO_MODULES_TO_PUBLISH_ERROR, null);
        }
        if (monitor != null && monitor.isCanceled()) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.SCA_PUBLISHING_CANCEL_ERROR);
        }
        boolean operationsSuccess = false;
        try {
            String supportedName = this.getModuleAsIdentifierName(module);
            boolean localCommandManager = false;
            String blaID = "WebSphere:blaname=" + supportedName;
            BLACommandResult commandResult = commandRunnerDelegate.stopBLA(server, blaID, localCommandManager, (CommandEventHandler)this, monitor);
            if (commandResult != null) {
                operationsSuccess = commandResult.isSuccessful();
            }
        }
        catch (Throwable throwable) {
            Logger.println(0, (Object)this, "stopBLA()", "Stop BLA failed ", throwable);
            return new Status(4, "com.ibm.ccl.sca.server.websphere", 0, Messages.STOP_BLA_ERROR, throwable);
        }
        if (operationsSuccess) {
            return new Status(0, "com.ibm.ccl.sca.server.websphere", 0, Messages.STOP_BLA_SUCCESS_INFO, null);
        }
        return new Status(4, "com.ibm.ccl.sca.server.websphere", 0, Messages.STOP_BLA_ERROR, null);
    }

    private IStatus deleteBLA(IServer server, BLAInfo blaInfo, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.SCA_PUBLISHING_CANCEL_ERROR);
        }
        boolean operationsSuccess = false;
        try {
            boolean localCommandManager = blaInfo.isLocalCommandManager();
            String blaID = blaInfo.getBlaID();
            BLACommandResult commandResult = commandRunnerDelegate.deleteBLA(server, blaID, localCommandManager, (CommandEventHandler)this, monitor);
            if (commandResult != null) {
                operationsSuccess = commandResult.isSuccessful();
            }
        }
        catch (Throwable throwable) {
            Logger.println(1, (Object)this, "deleteBLA()", "Delete BLA failed ", throwable);
            return new Status(2, "com.ibm.ccl.sca.server.websphere", 0, Messages.DELETE_BLA_ERROR, throwable);
        }
        if (operationsSuccess) {
            return new Status(0, "com.ibm.ccl.sca.server.websphere", 0, Messages.DELETE_BLA_SUCCESS_INFO, null);
        }
        return new Status(4, "com.ibm.ccl.sca.server.websphere", 0, Messages.DELETE_BLA_ERROR, null);
    }

    private List<String> getBLAList(IServer server, String blaID, IProgressMonitor monitor) {
        BLACommandResult commandResult;
        ArrayList<String> deployedBLAsList;
        block6: {
            block5: {
                deployedBLAsList = new ArrayList<String>();
                commandResult = null;
                commandResult = commandRunnerDelegate.listBLAs(server, blaID, "false", false, (CommandEventHandler)this, monitor);
                if (commandResult != null) break block5;
                return null;
            }
            if (commandResult.isSuccessful()) break block6;
            return null;
        }
        try {
            ArrayList blasList = (ArrayList)commandResult.getResult();
            for (String content : blasList) {
                if (content == null || content.equals("")) continue;
                deployedBLAsList.add(content);
            }
            return deployedBLAsList;
        }
        catch (Throwable throwable) {
            Logger.println(0, (Object)this, "getBLAsList()", "Getting the list of deployed BLAst failed ", throwable);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getBlaExecutionState(IServer server, BLAInfo blaInfo, IProgressMonitor monitor) {
        boolean localCommandManager = blaInfo.isLocalCommandManager();
        String blaID = blaInfo.getBlaID();
        String cuID = blaInfo.getCuID();
        String targetID = blaInfo.getTargetID();
        String executionStateString = null;
        try {
            BLACommandResult result = commandRunnerDelegate.getBLAStatus(server, blaID, cuID, targetID, localCommandManager, (CommandEventHandler)this, monitor);
            if (result.isSuccessful()) {
                ArrayList executionStateList = (ArrayList)result.getResult();
                for (String stateMessage : executionStateList) {
                    if (stateMessage != null && stateMessage.endsWith("\"ExecutionState.STOPPED\".")) {
                        return "ExecutionState.STOPPED";
                    }
                    if (stateMessage != null && stateMessage.endsWith("\"ExecutionState.STARTED\".")) {
                        return "ExecutionState.STARTED";
                    }
                    if (stateMessage != null && stateMessage.endsWith("\"ExecutionState.PARTIAL_START\".")) {
                        return "ExecutionState.PARTIAL_START";
                    }
                    if (stateMessage == null || !stateMessage.endsWith("\"ExecutionState.UNKNOWN\".")) continue;
                    return "ExecutionState.UNKNOWN";
                }
            }
            return executionStateString;
        }
        catch (Throwable throwable) {
            Logger.println(0, (Object)this, "getBLAExectionState()", "Getting BLA execution state failed ", throwable);
            return "ExecutionState.UNKNOWN";
        }
    }

    private IStatus addAsset(IServer server, IPath archivePath, BLAInfo blaInfo, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.SCA_PUBLISHING_CANCEL_ERROR);
        }
        boolean operationsSuccess = false;
        try {
            String archivePathAsString = null;
            String assetPath = null;
            if (archivePath != null && !archivePath.isEmpty()) {
                assetPath = archivePathAsString = archivePath.toPortableString();
            }
            boolean localCommandManager = blaInfo.isLocalCommandManager();
            HashMap<String, String> assetOptions = blaInfo.getAssetOptions();
            String storageType = blaInfo.getStorageType();
            BLACommandResult commandResult = commandRunnerDelegate.importAsset(server, assetPath, storageType, assetOptions, localCommandManager, (CommandEventHandler)this, monitor);
            if (commandResult != null) {
                operationsSuccess = commandResult.isSuccessful();
            }
        }
        catch (Throwable throwable) {
            Logger.println(1, (Object)this, "addAsset()", "Add asset failed ", throwable);
            return new Status(2, "com.ibm.ccl.sca.server.websphere", 0, Messages.ADD_ASSET_ERROR, throwable);
        }
        if (operationsSuccess) {
            return new Status(0, "com.ibm.ccl.sca.server.websphere", 0, Messages.ADD_ASSET_SUCCESS_INFO, null);
        }
        return new Status(4, "com.ibm.ccl.sca.server.websphere", 0, Messages.ADD_ASSET_ERROR, null);
    }

    private IStatus updateAsset(IServer server, IPath archivePath, BLAInfo blaInfo, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.SCA_PUBLISHING_CANCEL_ERROR);
        }
        boolean operationsSuccess = false;
        try {
            BLACommandResult commandResult = null;
            boolean localCommandManager = blaInfo.isLocalCommandManager();
            String operation = "replace";
            String archivePathAsString = null;
            String archiveFilename = null;
            String assetID = blaInfo.getAssetID();
            if (archivePath != null && !archivePath.isEmpty()) {
                archivePathAsString = archivePath.toPortableString();
                archiveFilename = archivePath.toFile().getName();
            }
            if ((commandResult = commandRunnerDelegate.updateAsset(server, assetID, operation, archivePathAsString, archiveFilename, localCommandManager, (CommandEventHandler)this, monitor)) != null) {
                operationsSuccess = commandResult.isSuccessful();
            }
        }
        catch (Throwable throwable) {
            Logger.println(0, (Object)this, "updateAsset()", "Update asset failed ", throwable);
            return new Status(4, "com.ibm.ccl.sca.server.websphere", 0, Messages.UPDATE_ASSET_ERROR, throwable);
        }
        if (operationsSuccess) {
            return new Status(0, "com.ibm.ccl.sca.server.websphere", 0, Messages.UPDATE_ASSET_SUCCESS_INFO, null);
        }
        return new Status(4, "com.ibm.ccl.sca.server.websphere", 0, Messages.UPDATE_ASSET_ERROR, null);
    }

    private IStatus deleteAsset(IServer server, BLAInfo blaInfo, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.SCA_PUBLISHING_CANCEL_ERROR);
        }
        boolean operationsSuccess = false;
        try {
            BLACommandResult commandResult = null;
            boolean localCommandManager = blaInfo.isLocalCommandManager();
            String assetID = blaInfo.getAssetID();
            commandResult = commandRunnerDelegate.deleteAsset(server, assetID, true, localCommandManager, (CommandEventHandler)this, monitor);
            if (commandResult != null) {
                operationsSuccess = commandResult.isSuccessful();
            }
        }
        catch (Throwable throwable) {
            Logger.println(1, (Object)this, "deleteAsset()", "Delete asset failed ", throwable);
            return new Status(2, "com.ibm.ccl.sca.server.websphere", 0, Messages.DELETE_ASSET_ERROR, throwable);
        }
        if (operationsSuccess) {
            return new Status(0, "com.ibm.ccl.sca.server.websphere", 0, Messages.DELETE_ASSET_SUCCESS_INFO, null);
        }
        return new Status(4, "com.ibm.ccl.sca.server.websphere", 0, Messages.DELETE_ASSET_ERROR, null);
    }

    private List<String> getAssetList(IServer server, String assetID, IProgressMonitor monitor) {
        BLACommandResult commandResult;
        ArrayList<String> deployeedAssetsList;
        block6: {
            block5: {
                deployeedAssetsList = new ArrayList<String>();
                commandResult = null;
                commandResult = commandRunnerDelegate.listAssets(server, assetID, "false", null, false, (CommandEventHandler)this, monitor);
                if (commandResult != null) break block5;
                return null;
            }
            if (commandResult.isSuccessful()) break block6;
            return null;
        }
        try {
            ArrayList assetsList = (ArrayList)commandResult.getResult();
            for (String content : assetsList) {
                if (content == null || content.equals("")) continue;
                deployeedAssetsList.add(content);
            }
            return deployeedAssetsList;
        }
        catch (Throwable throwable) {
            Logger.println(0, (Object)this, "getAssetList()", "Getting the list of deployed assets failed ", throwable);
            return null;
        }
    }

    private IStatus addCompositionUnit(IServer server, BLAInfo blaInfo, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.SCA_PUBLISHING_CANCEL_ERROR);
        }
        boolean operationsSuccess = false;
        try {
            BLACommandResult commandResult = null;
            boolean localCommandManager = blaInfo.isLocalCommandManager();
            String blaID = blaInfo.getBlaID();
            String deployableUnits = blaInfo.getDeployableUnits();
            String cuSourceID = blaInfo.getCuSourceID();
            String mapTargets = blaInfo.getMapTargets();
            String cuID = blaInfo.getCuID();
            HashMap<String, String> cuOptions = blaInfo.getCuOptions();
            HashMap<String, String> appDeploymentOptions = blaInfo.getAppDeploymentOptions();
            commandResult = commandRunnerDelegate.addCompositionUnit(server, blaID, cuSourceID, deployableUnits, cuID, cuOptions, appDeploymentOptions, mapTargets, localCommandManager, (CommandEventHandler)this, monitor);
            if (commandResult != null) {
                operationsSuccess = commandResult.isSuccessful();
            }
        }
        catch (Throwable throwable) {
            Logger.println(0, (Object)this, "addCompositionUnit()", "Add composition unit failed ", throwable);
            return new Status(2, "com.ibm.ccl.sca.server.websphere", 0, Messages.ADD_COMPOSITION_UNIT_ERROR, throwable);
        }
        if (operationsSuccess) {
            return new Status(0, "com.ibm.ccl.sca.server.websphere", 0, Messages.ADD_COMPOSITION_UNIT_SUCCESS_INFO, null);
        }
        return new Status(4, "com.ibm.ccl.sca.server.websphere", 0, Messages.ADD_COMPOSITION_UNIT_ERROR, null);
    }

    private IStatus deleteCompositionUnit(IServer server, BLAInfo blaInfo, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.SCA_PUBLISHING_CANCEL_ERROR);
        }
        boolean operationsSuccess = false;
        try {
            BLACommandResult commandResult = null;
            boolean localCommandManager = blaInfo.isLocalCommandManager();
            String blaID = blaInfo.getBlaID();
            String cuID = blaInfo.getCuID();
            boolean forceDelete = true;
            commandResult = commandRunnerDelegate.deleteCompositionUnit(server, blaID, cuID, forceDelete, localCommandManager, (CommandEventHandler)this, monitor);
            if (commandResult != null) {
                operationsSuccess = commandResult.isSuccessful();
            }
        }
        catch (Throwable throwable) {
            Logger.println(1, (Object)this, "deleteCompositionUnit()", "Delete composition unit failed ", throwable);
            return new Status(2, "com.ibm.ccl.sca.server.websphere", 0, Messages.DELETE_COMPOSITION_UNIT_ERROR, throwable);
        }
        if (operationsSuccess) {
            return new Status(0, "com.ibm.ccl.sca.server.websphere", 0, Messages.DELETE_COMPOSITION_UNIT_SUCCESS_INFO, null);
        }
        return new Status(4, "com.ibm.ccl.sca.server.websphere", 0, Messages.DELETE_COMPOSITION_UNIT_ERROR, null);
    }

    private IStatus deleteAllCompositionUnits(IGenericModuleServer genericModuleServer, BLAInfo blaInfo, IProgressMonitor monitor) {
        List<String> cus;
        String blaID;
        boolean operationsSuccess;
        IServer server;
        block6: {
            server = genericModuleServer.getServer();
            if (monitor != null && monitor.isCanceled()) {
                return new Status(4, "com.ibm.ccl.sca.server.websphere", Messages.SCA_PUBLISHING_CANCEL_ERROR);
            }
            operationsSuccess = true;
            blaID = null;
            blaID = blaInfo.getBlaID();
            cus = this.getCompositionUnitsList(server, blaID, monitor);
            if (cus.size() != 0) break block6;
            return null;
        }
        try {
            for (String cu : cus) {
                blaInfo.setCuID(cu);
                IStatus status = this.deleteCompositionUnit(server, blaInfo, monitor);
                if (status.isOK()) continue;
                operationsSuccess = false;
            }
        }
        catch (Throwable throwable) {
            Logger.println(1, (Object)this, "deleteAllCompositionUnits()", "Delete all composition units in BLA " + blaID + " failed ", throwable);
            return new Status(2, "com.ibm.ccl.sca.server.websphere", 0, Messages.DELETE_ALL_COMPOSITION_UNITS_ERROR, throwable);
        }
        if (operationsSuccess) {
            return new Status(0, "com.ibm.ccl.sca.server.websphere", 0, Messages.DELETE_ALL_COMPOSITION_UNITS_SUCCESS_INFO, null);
        }
        return new Status(4, "com.ibm.ccl.sca.server.websphere", 0, Messages.DELETE_ALL_COMPOSITION_UNITS_ERROR, null);
    }

    private List<String> getCompositionUnitsList(IServer server, String blaID, IProgressMonitor monitor) {
        BLACommandResult commandResult;
        ArrayList<String> deployedCompositionUnitsList;
        block6: {
            block5: {
                deployedCompositionUnitsList = new ArrayList<String>();
                commandResult = null;
                commandResult = commandRunnerDelegate.listCompositionUnits(server, blaID, "false", null, false, (CommandEventHandler)this, monitor);
                if (commandResult != null) break block5;
                return null;
            }
            if (commandResult.isSuccessful()) break block6;
            return null;
        }
        try {
            ArrayList compositionUnits = (ArrayList)commandResult.getResult();
            for (String content : compositionUnits) {
                if (content == null || content.equals("")) continue;
                deployedCompositionUnitsList.add(content);
            }
            return deployedCompositionUnitsList;
        }
        catch (Throwable throwable) {
            Logger.println(0, (Object)this, "getCompositionUnitsList()", "Getting the list of deployed composition unitst failed ", throwable);
            return null;
        }
    }

    private boolean createServerTempDirectory(IGenericModuleServer server) {
        String serverId = server.getServer().getId();
        IPath statePath = SCAWebSphereServerCorePlugin.getInstance().getStateLocation();
        String path = null;
        File directory = null;
        int count = 0;
        while (directory == null || directory.exists()) {
            path = "tmp" + count;
            directory = statePath.append(path).toFile();
            ++count;
        }
        directory.mkdirs();
        serverTempDirs.put(serverId, directory.toString());
        return directory.canWrite();
    }

    private IPath getServerTempDirectory(String serverIdKey) {
        return new Path(serverTempDirs.get(serverIdKey));
    }

    private void deleteTemporaryExportedArchives(String serverId, IProgressMonitor monitor) {
        IPath serverTempDirectory = this.getServerTempDirectory(serverId);
        SCAWebSphereServerCorePlugin.deleteFilesFromDirectory(serverTempDirectory.toPortableString());
    }

    private List<QName> getAllCompositeQnames(IModule currentContributionModule) {
        ContributionModule contribution;
        if (currentContributionModule == null) {
            Logger.println(0, (Object)this, "getAllCompositeQnames()", "The module or the archivePath is null");
        }
        if ((contribution = (ContributionModule)currentContributionModule.loadAdapter(ContributionModule.class, null)) == null) {
            Logger.println(0, (Object)this, "getAllCompositeQnames()", "The contribution is null");
            return null;
        }
        List<ISCAComposite> composites = SCAModelUtil.getISCAComposites(contribution.getISCAContribution());
        ArrayList<QName> compositeQNamesList = new ArrayList<QName>();
        for (ISCAComposite o : composites) {
            ISCAComposite scaComposite;
            QName compositeQName;
            if (!(o instanceof ISCAComposite) || (compositeQName = (scaComposite = o).getName()) == null) continue;
            compositeQNamesList.add(compositeQName);
        }
        return compositeQNamesList;
    }

    private List<QName> getAllDeployableCompositeQnames(IModule currentContributionModule) {
        ContributionModule contribution;
        if (currentContributionModule == null) {
            Logger.println(0, (Object)this, "getAllDeployableCompositeQnames()", "The module or the archivePath is null");
        }
        if ((contribution = (ContributionModule)currentContributionModule.loadAdapter(ContributionModule.class, null)) == null) {
            Logger.println(0, (Object)this, "getAllDeployableCompositeQnames()", "The contribution is null");
            return null;
        }
        List qnames = contribution.getISCAContribution().getDeployableComposites();
        return qnames;
    }
}

