/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.server.websphere.launch;

import com.ibm.ccl.sca.core.model.ISCAComposite;
import com.ibm.ccl.sca.core.model.ISCAContribution;
import com.ibm.ccl.sca.core.model.ISCAProject;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IServer;

public class SCAWebSphereLaunchable {
    private IServer server;
    private IProject project;
    private IModule module;
    private String moduleName;
    private IModuleType moduleType;
    private String moduleTypeVersion;
    private String moduleTypeName;
    private String moduleTypeID;
    private ISCAProject scaProject;
    private List<ISCAComposite> scaCompositesList;
    private List<ISCAContribution> scaContributionsList;

    public SCAWebSphereLaunchable(IServer server, IProject project, IModule module, String moduleName, IModuleType moduleType, String moduleTypeVersion, String moduleTypeName, String moduleTypeID, ISCAProject scaProject, List<ISCAComposite> scaCompositesList, List<ISCAContribution> scaContributionsList) {
        this.server = server;
        this.project = project;
        this.module = module;
        this.moduleName = moduleName;
        this.moduleType = moduleType;
        this.moduleTypeVersion = moduleTypeVersion;
        this.moduleTypeName = moduleName;
        this.moduleTypeID = moduleTypeID;
        this.scaProject = scaProject;
        this.scaCompositesList = scaCompositesList;
        this.scaContributionsList = scaContributionsList;
    }

    public IServer getServer() {
        return this.server;
    }

    public IProject getProject() {
        return this.project;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public IModuleType getModuleType() {
        return this.moduleType;
    }

    public String getModuleTypeVersion() {
        return this.moduleTypeVersion;
    }

    public String getModuleTypeName() {
        return this.moduleTypeName;
    }

    public String getModuleTypeID() {
        return this.moduleTypeID;
    }

    public IModule getModule() {
        return this.module;
    }

    public ISCAProject getScaProject() {
        return this.scaProject;
    }

    public List<ISCAComposite> getScaCompositesList() {
        return this.scaCompositesList;
    }

    public List<ISCAContribution> getScaContributionsList() {
        return this.scaContributionsList;
    }

    public String toString() {
        String moduleInfo = "Server: " + this.server.getName() + "\n" + "Project: " + this.project.getName() + "\n" + "Module Name: " + this.moduleName + "\n" + "Module Type: " + this.moduleType.getName() + "\n" + "Module Type Version: " + this.moduleTypeVersion + "\n" + "Module Type Name : " + this.moduleTypeName + "\n" + "ModuleType ID: " + this.moduleTypeID + "\n" + "SCA Module Name: " + this.module.getName() + "\n" + "SCA Project Name: " + this.scaProject.getProject().getName() + "\n";
        StringBuffer composites = new StringBuffer();
        for (ISCAComposite scaComposite : this.scaCompositesList) {
            composites.append("Composite: " + scaComposite.getLogicalName() + "\n");
        }
        StringBuffer contributions = new StringBuffer();
        for (ISCAContribution scaContribution : this.scaContributionsList) {
            contributions.append("Contribution: " + scaContribution.getLogicalName() + "\n");
        }
        return String.valueOf(moduleInfo) + composites.toString() + contributions.toString();
    }
}

