/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.java.ui.contribution.editor.extension;

import com.ibm.ccl.sca.java.ui.messages.Messages;
import com.ibm.ccl.sca.ui.contribution.editor.IImportExportEditHelper;
import com.ibm.ccl.sca.ui.contribution.editor.IImportExportMultiAdder;
import com.ibm.ccl.sca.ui.contribution.editor.ImportExportWrapper;
import com.ibm.ccl.sca.ui.util.UIUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public abstract class AbstractJavaEditHelper
implements IImportExportEditHelper,
IImportExportMultiAdder {
    private ImportExportWrapper wrapper;
    private boolean isAdd = false;
    private Text packageName;
    private ListViewer viewer;
    private List<String> model;
    private Button addButton;
    private Button selectButton;
    private Button removeButton;
    private Button okButton;
    private List<ImportExportWrapper> data;

    public void setData(ImportExportWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public void setIsAdd() {
        this.isAdd = true;
    }

    public void createControls(final Composite composite) {
        String pkg;
        UIUtils utils = new UIUtils("com.ibm.ccl.sca.java.ui");
        Composite childComposite = utils.createComposite(composite, 2);
        GridData gd = new GridData(4, 4, true, true);
        if (this.isAdd) {
            gd.heightHint = 300;
        }
        childComposite.setLayoutData((Object)gd);
        Label label = utils.createLabel(childComposite, Messages.LABEL_CONTRIB_EDITOR_IMPORTEXPORT_PACKAGE, null, 0);
        label.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.packageName = utils.createText(childComposite, null, null, null, 2048);
        if (!this.isAdd && (pkg = this.getPackage(this.wrapper.getData())) != null) {
            this.packageName.setText(pkg);
        }
        this.packageName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractJavaEditHelper.this.updateButtonStatus();
            }
        });
        if (this.isAdd) {
            this.addButton = utils.createPushButton(childComposite, Messages.LABEL_ADD, null, null);
            this.addButton.setLayoutData((Object)new GridData(4, 4, false, false));
            this.addButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    String pkg = AbstractJavaEditHelper.this.packageName.getText().trim();
                    if (!AbstractJavaEditHelper.this.model.contains(pkg)) {
                        AbstractJavaEditHelper.this.model.add(pkg);
                        AbstractJavaEditHelper.this.viewer.refresh();
                    }
                    AbstractJavaEditHelper.this.packageName.setText("");
                    AbstractJavaEditHelper.this.updateButtonStatus();
                }
            });
            this.viewer = new ListViewer(childComposite, 2562);
            this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
            this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    return ((List)inputElement).toArray();
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }
            });
            this.model = new ArrayList<String>();
            this.viewer.setInput(this.model);
        }
        this.selectButton = utils.createPushButton(childComposite, Messages.JavaImportEditHelper_LABEL_BROWSE_JAVA_IMPORT_PACKAGE, null, null);
        this.selectButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.selectButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ElementListSelectionDialog dialog = AbstractJavaEditHelper.this.createPackageDialog(composite.getShell(), AbstractJavaEditHelper.this.wrapper.getProject());
                dialog.setMultipleSelection(AbstractJavaEditHelper.this.isAdd);
                if (dialog.open() == 0) {
                    boolean refresh = false;
                    Object[] objectArray = dialog.getResult();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        if (obj instanceof IPackageFragment) {
                            String packageFragment = ((IPackageFragment)obj).getElementName();
                            if (AbstractJavaEditHelper.this.isAdd) {
                                if (!AbstractJavaEditHelper.this.model.contains(packageFragment)) {
                                    AbstractJavaEditHelper.this.model.add(packageFragment);
                                    refresh = true;
                                }
                            } else {
                                AbstractJavaEditHelper.this.packageName.setText(packageFragment);
                                break;
                            }
                        }
                        ++n2;
                    }
                    if (refresh) {
                        AbstractJavaEditHelper.this.viewer.refresh();
                        AbstractJavaEditHelper.this.updateButtonStatus();
                    }
                }
            }
        });
        if (this.isAdd) {
            this.removeButton = utils.createPushButton(childComposite, Messages.LABEL_REMOVE, null, null);
            this.removeButton.setLayoutData((Object)new GridData(4, 1, false, false));
            this.removeButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    IStructuredSelection selection = (IStructuredSelection)AbstractJavaEditHelper.this.viewer.getSelection();
                    if (AbstractJavaEditHelper.this.model.removeAll(selection.toList())) {
                        AbstractJavaEditHelper.this.viewer.refresh();
                        AbstractJavaEditHelper.this.updateButtonStatus();
                    }
                }
            });
        }
    }

    private void updateButtonStatus() {
        if (this.isAdd) {
            this.addButton.setEnabled(this.packageName.getText().trim().length() != 0);
            this.okButton.setEnabled(this.viewer.getList().getItemCount() != 0);
        } else {
            this.okButton.setEnabled(this.packageName.getText().trim().length() != 0);
        }
    }

    public void setOKButton(Button button) {
        this.okButton = button;
        this.updateButtonStatus();
    }

    public void updateData() {
        if (this.isAdd) {
            this.data = new ArrayList<ImportExportWrapper>();
            for (String text : this.model) {
                Object dataObj = this.newDataObject(text);
                this.data.add(new ImportExportWrapper(dataObj.getClass().getName(), dataObj));
            }
        } else {
            this.setPackage(this.wrapper.getData(), this.packageName.getText());
        }
    }

    public List<ImportExportWrapper> getData() {
        return this.data;
    }

    protected abstract String getPackage(Object var1);

    protected abstract void setPackage(Object var1, String var2);

    protected abstract Object newDataObject(String var1);

    protected abstract ElementListSelectionDialog createPackageDialog(Shell var1, IProject var2);
}

