/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.facets.websphere.validation.web20;

import com.ibm.ccl.sca.core.validation.AbstractValidationRule;
import com.ibm.ccl.sca.core.validation.IValidationConstants;
import com.ibm.ccl.sca.core.validation.IValidationContext;
import com.ibm.ccl.sca.core.validation.ValidationUtils;
import com.ibm.ccl.sca.internal.facets.websphere.messages.Messages;
import javax.xml.namespace.QName;
import javax.xml.stream.events.StartElement;
import org.eclipse.core.runtime.IProgressMonitor;

public class IncompatibleInterfaceRule
extends AbstractValidationRule {
    public IncompatibleInterfaceRule() {
        super("com.ibm.ccl.sca.facets.websphere.IncompatibleInterfaceRule");
    }

    public String getDescription() {
        return Messages.DESC_INCOMPATIBLE_INTERFACE_RULE;
    }

    public void run(IValidationContext context, IProgressMonitor monitor) {
        if (ValidationUtils.getComponentContainer((IValidationContext)context) == null) {
            return;
        }
        StartElement element = (StartElement)context.getModel();
        String name = element.getName().getLocalPart();
        if (name.equals("service")) {
            context.remove(this.getID());
        } else if (ValidationUtils.getServiceContainer((IValidationContext)context) != null) {
            if (name.startsWith("interface")) {
                context.put(this.getID(), (Object)element);
            } else {
                String intfClass;
                StartElement intf = (StartElement)context.get(this.getID());
                if (intf == null) {
                    return;
                }
                if (intf.getName().getLocalPart().equals("interface.java") && ((intfClass = ValidationUtils.getAttribute((StartElement)intf, (QName)IValidationConstants.INTERFACE_ATTR)) == null || intfClass.length() == 0 || intfClass.equals("org.apache.tuscany.sca.data.collection.Collection"))) {
                    return;
                }
                context.postMessage(Messages.MSG_INCOMPATIBLE_INTERFACE_RULE, "com.ibm.ccl.sca.core.SCAProblemMarker", element.getLocation().getLineNumber());
            }
        }
    }
}

