/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.facets.websphere.validation.web20;

import com.ibm.ccl.sca.core.util.JavaUtil;
import com.ibm.ccl.sca.core.validation.AbstractValidationRule;
import com.ibm.ccl.sca.core.validation.IValidationContext;
import com.ibm.ccl.sca.core.validation.ValidationUtils;
import com.ibm.ccl.sca.internal.facets.websphere.messages.Messages;
import com.ibm.ccl.sca.internal.facets.websphere.validation.web20.IWeb20ValidationConstants;
import javax.xml.namespace.QName;
import javax.xml.stream.events.StartElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class AtomCollectionRule
extends AbstractValidationRule {
    public AtomCollectionRule() {
        super("com.ibm.ccl.sca.facets.websphere.AtomCollectionRule");
    }

    public String getDescription() {
        return Messages.DESC_ATOM_COLLECTION_RULE;
    }

    private boolean implementsCollection(IProject project, String clazz) throws JavaModelException {
        IJavaProject jProject = JavaCore.create((IProject)project);
        IType type = jProject.findType(clazz);
        if (type == null) {
            return true;
        }
        return JavaUtil.implementsInterface((IType)type, (String)"org.apache.tuscany.sca.data.collection.Collection");
    }

    public void run(IValidationContext context, IProgressMonitor monitor) {
        StartElement element = (StartElement)context.getModel();
        if (element.getName().getLocalPart().equals("component")) {
            context.remove(this.getID());
        } else if (ValidationUtils.getComponentContainer((IValidationContext)context) != null && ValidationUtils.getServiceContainer((IValidationContext)context) != null && context.get(this.getID()) == null) {
            try {
                element = (StartElement)context.get("com.ibm.ccl.sca.core.ImplementationFinderRule");
                if (element == null || !element.getName().getLocalPart().equals("implementation.java")) {
                    return;
                }
                IProject project = context.getResource().getProject();
                if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                    return;
                }
                String clazz = ValidationUtils.getAttribute((StartElement)element, (QName)IWeb20ValidationConstants.CLASS_ATTR);
                if (clazz == null || clazz.isEmpty()) {
                    return;
                }
                try {
                    if (!this.implementsCollection(project, clazz)) {
                        context.postMessage(Messages.MSG_ATOM_COLLECTION_RULE, "com.ibm.ccl.sca.core.SCAProblemMarker", element.getLocation().getLineNumber());
                    }
                }
                catch (CoreException e) {
                    context.postMessage(e.getMessage(), "com.ibm.ccl.sca.core.SCAProblemMarker", element.getLocation().getLineNumber(), 2);
                }
            }
            finally {
                context.put(this.getID(), (Object)true);
            }
        }
    }
}

