/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.facets.websphere.validation.spring;

import com.ibm.ccl.sca.composite.emf.spring.impl.model.ISCASpringImplementation;
import com.ibm.ccl.sca.composite.emf.spring.impl.model.ISpringImplementation;
import com.ibm.ccl.sca.core.model.ISCAArtifact;
import com.ibm.ccl.sca.core.validation.AbstractValidationRule;
import com.ibm.ccl.sca.core.validation.IValidationContext;
import com.ibm.ccl.sca.core.validation.ValidationUtils;
import com.ibm.ccl.sca.internal.facets.websphere.messages.Messages;
import com.ibm.ccl.sca.internal.facets.websphere.validation.spring.ISpringValidationConstants;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.events.StartElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class BeanDefinitionCountRule
extends AbstractValidationRule {
    public BeanDefinitionCountRule() {
        super("com.ibm.ccl.sca.facets.websphere.BeanDefinitionCountRule");
    }

    public String getDescription() {
        return Messages.DESC_BEAN_DEF_COUNT_RULE;
    }

    public int getDefaultSeverity() {
        return 1;
    }

    private ISCAArtifact<?> findArtifact(List<ISCAArtifact<?>> artifacts, String location) {
        Path path = new Path(location);
        for (ISCAArtifact<?> artifact : artifacts) {
            if (!(artifact instanceof ISCASpringImplementation) || !artifact.getParent().getFullPath().append((IPath)path).equals((Object)artifact.getResource().getFullPath())) continue;
            return artifact;
        }
        return null;
    }

    public void run(IValidationContext context, IProgressMonitor monitor) {
        StartElement element = (StartElement)context.getModel();
        String location = ValidationUtils.getAttribute((StartElement)element, (QName)ISpringValidationConstants.LOCATION_ATTR);
        if (location == null || location.length() == 0) {
            return;
        }
        List artifacts = ValidationUtils.getResolvedArtifacts((IValidationContext)context);
        if (artifacts == null || artifacts.isEmpty()) {
            return;
        }
        ISCAArtifact<?> artifact = this.findArtifact(artifacts, location);
        if (artifact == null) {
            return;
        }
        try {
            ISpringImplementation impl = (ISpringImplementation)artifact.getModelObject();
            if (impl.getBeanDefinitions().length > 1) {
                context.postMessage(Messages.MSG_BEAN_DEF_COUNT_RULE, "com.ibm.ccl.sca.core.SCAProblemMarker", element.getLocation().getLineNumber());
            }
        }
        catch (CoreException e) {
            context.postMessage(e.getMessage(), "com.ibm.ccl.sca.core.SCAProblemMarker", element.getLocation().getLineNumber(), 2);
        }
    }
}

