/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.facets.websphere.validation.spring;

import com.ibm.ccl.sca.core.plugin.SCAToolsCorePlugin;
import com.ibm.ccl.sca.core.preferences.PreferencesState;
import com.ibm.ccl.sca.core.preferences.SCAPreferences;
import com.ibm.ccl.sca.core.validation.AbstractValidationRule;
import com.ibm.ccl.sca.core.validation.IValidationContext;
import com.ibm.ccl.sca.facets.websphere.util.FacetsUtil;
import com.ibm.ccl.sca.internal.facets.websphere.messages.Messages;
import com.ibm.ccl.sca.internal.facets.websphere.validation.FacetVersionRule;
import java.util.List;
import javax.xml.stream.events.StartElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;

public class AssetJarRule
extends AbstractValidationRule {
    private static final String SPRING_ID = "com.ibm.ccl.sca.composite.emf.spring.impl";
    private static final String SPRING_LOCATION = "com.ibm.ccl.sca.composite.emf.spring.impl.springLocation";

    public AssetJarRule() {
        super("com.ibm.ccl.sca.facets.websphere.AssetJarRule");
    }

    public String getDescription() {
        return Messages.DESC_ASSET_JAR_RULE;
    }

    public int getDefaultSeverity() {
        return 1;
    }

    public String[] getRuleDependencies(IValidationContext context) {
        return new String[]{"com.ibm.ccl.sca.facets.websphere.FacetVersionRule"};
    }

    private boolean springAssetJarConfigured() {
        PreferencesState preferences = new PreferencesState(SPRING_ID);
        return preferences.getValue(SPRING_LOCATION, "", null).trim().length() > 0;
    }

    public void run(IValidationContext context, IProgressMonitor monitor) {
        List<IProject> projects = FacetVersionRule.getProjects(context);
        if (projects == null) {
            return;
        }
        if (this.springAssetJarConfigured()) {
            return;
        }
        SCAPreferences preferences = SCAToolsCorePlugin.getInstance().getPreferences();
        for (IProject project : projects) {
            if (FacetsUtil.isProjWAS100(project) || !preferences.getSelectedImplType("implementation.spring", project)) continue;
            context.postMessage(Messages.MSG_ASSET_JAR_RULE, "com.ibm.ccl.sca.core.SCAProblemMarker", ((StartElement)context.getModel()).getLocation().getLineNumber());
            return;
        }
    }
}

